/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageReceiver;
import com.isencia.message.MessageReceiver;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.ReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.net.SocketReceiverChannel;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServerReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketServerReceiverChannel.class);
    private ServerSocket sSocket = null;
    private IMessageExtractor extractor = null;
    private IMessageReceiver receiver = null;

    public SocketServerReceiverChannel(ServerSocket serverSocket, IMessageExtractor iMessageExtractor) {
        if (serverSocket != null) {
            this.setSocket(serverSocket);
        }
        this.setExtractor(iMessageExtractor);
        this.receiver = new MessageReceiver();
    }

    public Collection getSubChannels() {
        return this.receiver.getChannels();
    }

    public ServerSocket getSocket() {
        return this.sSocket;
    }

    public void setSocket(ServerSocket serverSocket) {
        this.sSocket = serverSocket;
    }

    @Override
    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace("run() - entry");
        }
        while (true) {
            Socket socket = null;
            try {
                socket = this.getSocket().accept();
            }
            catch (SocketException socketException) {
                logger.info("run() - " + socketException.getMessage() + ". Terminating...");
                break;
            }
            catch (IOException iOException) {
                logger.info("run() - " + iOException.getMessage() + ". Terminating...");
                break;
            }
            logger.info("run() - Accepted connection request. Socket: " + socket);
            if (this.isInterrupted()) break;
            IMessageExtractor iMessageExtractor = null;
            try {
                iMessageExtractor = (IMessageExtractor)this.getExtractor().getClass().newInstance();
                SocketReceiverChannel socketReceiverChannel = new SocketReceiverChannel(socket, iMessageExtractor);
                this.receiver.addChannel(socketReceiverChannel);
                socketReceiverChannel.start();
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error("run() - Unable to create new channel", (Throwable)illegalAccessException);
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (InstantiationException instantiationException) {
                logger.error("run() - Unable to create new channel", (Throwable)instantiationException);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {}
        if (logger.isTraceEnabled()) {
            logger.trace("run() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        super.close();
        this.receiver.close();
        this.interrupt();
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            logger.error("close() - Error closing server socket", (Throwable)iOException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    public IMessageExtractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(IMessageExtractor iMessageExtractor) {
        this.extractor = iMessageExtractor;
    }

    @Override
    protected Object doGetMessage() throws ChannelException, NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        Object object = this.receiver.getMessage();
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - exit : " + object);
        }
        return object;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        super.open();
        this.receiver.open();
        this.start();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }
}

