/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.ReaderReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketReceiverChannel
extends ReaderReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketReceiverChannel.class);
    private Socket socket = null;

    public SocketReceiverChannel(Socket socket, IMessageExtractor iMessageExtractor) {
        super(iMessageExtractor);
        if (socket != null) {
            this.socket = socket;
        }
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.getReader() != null) {
            try {
                this.getReader().close();
            }
            catch (IOException iOException) {
                logger.error("open() - Could not close reader", (Throwable)iOException);
            }
            this.setReader(null);
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.getSocket().getInputStream());
            this.setReader(inputStreamReader);
        }
        catch (IOException iOException) {
            logger.error("open() - Error getting inputstream from socket", (Throwable)iOException);
            throw new ChannelException("Error getting inputstream from socket " + iOException.getMessage());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void close() throws ChannelException {
        try {
            this.getSocket().close();
        }
        catch (Exception exception) {}
        super.close();
    }
}

