/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.io;

import com.isencia.message.ChannelException;
import com.isencia.message.ReaderReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReceiverChannel
extends ReaderReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(FileReceiverChannel.class);
    private File source = null;
    private String encoding = null;

    public FileReceiverChannel(File file, IMessageExtractor iMessageExtractor) {
        super(iMessageExtractor);
        this.source = file;
    }

    public FileReceiverChannel(File file, String string, IMessageExtractor iMessageExtractor) {
        super(iMessageExtractor);
        this.source = file;
        this.encoding = string;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.source == null) {
            throw new ChannelException("Source file is null");
        }
        try {
            InputStreamReader inputStreamReader = null;
            if (this.encoding != null) {
                FileInputStream fileInputStream = new FileInputStream(this.source);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.encoding);
            } else {
                inputStreamReader = new FileReader(this.source);
            }
            this.setReader(inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ChannelException("Source file " + this.source.getAbsolutePath() + " does not exist");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ChannelException("UnsupportedEncodingException " + this.encoding);
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    public String getSourceInfo() {
        return this.source.getAbsolutePath();
    }
}

