/*
 * Decompiled with CFR 0.152.
 */
package diva.util.jester;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class EventRecorder {
    private Component _component;
    private ArrayList _events = new ArrayList();
    private MouseRecorder _mouseRecorder = new MouseRecorder();
    private MouseMotionRecorder _mouseMotionRecorder = new MouseMotionRecorder();
    private KeyRecorder _keyRecorder = new KeyRecorder();

    public EventRecorder(Component component) {
        this._component = component;
    }

    public void record() {
        this._component.addMouseListener(this._mouseRecorder);
        this._component.addMouseMotionListener(this._mouseMotionRecorder);
        this._component.addKeyListener(this._keyRecorder);
    }

    public synchronized InputEvent[] stop() {
        this._component.removeMouseListener(this._mouseRecorder);
        this._component.removeMouseMotionListener(this._mouseMotionRecorder);
        this._component.removeKeyListener(this._keyRecorder);
        InputEvent[] out = new InputEvent[this._events.size()];
        this._events.toArray(out);
        return out;
    }

    private class KeyRecorder
    implements KeyListener {
        private KeyRecorder() {
        }

        public void keyPressed(KeyEvent e) {
            this.record(e);
        }

        public void keyReleased(KeyEvent e) {
            this.record(e);
        }

        public void keyTyped(KeyEvent e) {
            this.record(e);
        }

        private void record(KeyEvent e) {
            EventRecorder.this._events.add(e);
        }
    }

    private class MouseMotionRecorder
    implements MouseMotionListener {
        private MouseMotionRecorder() {
        }

        public void mouseDragged(MouseEvent e) {
            this.record(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.record(e);
        }

        private void record(MouseEvent e) {
            EventRecorder.this._events.add(e);
        }
    }

    private class MouseRecorder
    implements MouseListener {
        private MouseRecorder() {
        }

        public void mouseClicked(MouseEvent e) {
            this.record(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.record(e);
        }

        public void mouseExited(MouseEvent e) {
            this.record(e);
        }

        public void mousePressed(MouseEvent e) {
            this.record(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.record(e);
        }

        private void record(MouseEvent e) {
            EventRecorder.this._events.add(e);
        }
    }
}

