/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d.svg;

import diva.util.java2d.PaintedObject;
import diva.util.java2d.svg.SVGRenderingListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.JSVGComponent;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGPaintedObject
implements PaintedObject {
    private List svgrListenerList = new Vector();
    private final SVGDocument svgDoc;
    private final JSVGComponent svgComponent;
    private final Container container = new Container();
    private static final Rectangle2D _DEFAULT_SVG_BOUNDS = new Rectangle(20, 20);
    private Rectangle2D svgBounds;

    public SVGPaintedObject(Document doc) {
        this.svgDoc = (SVGDocument)doc;
        this.svgComponent = new JSVGComponent(null, false, false){
            Dimension screenSize;
            {
                this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setMaximumSize(this.screenSize);
                this.setPreferredSize(this.screenSize);
            }

            public Dimension getPreferredSize() {
                Dimension s = super.getPreferredSize();
                if (s.width > this.screenSize.width) {
                    s.width = this.screenSize.width;
                }
                if (s.height > this.screenSize.height) {
                    s.height = this.screenSize.height;
                }
                return s;
            }

            public void setMySize(Dimension d) {
                this.setPreferredSize(d);
                this.invalidate();
                SVGPaintedObject.this.container.doLayout();
            }
        };
        this._addListeners();
        this.container.setLayout(new FlowLayout(1, 0, 0));
        this.container.add((Component)this.svgComponent);
        this.container.doLayout();
        this.svgComponent.setRecenterOnResize(true);
        this.svgComponent.setDoubleBuffered(false);
        this.svgComponent.setDoubleBufferedRendering(false);
        this.svgComponent.setIgnoreRepaint(true);
        this.svgComponent.setDocumentState(2);
        this.svgComponent.setSVGDocument(this.svgDoc);
    }

    public Rectangle2D getBounds() {
        if (this.svgBounds == null) {
            this.svgBounds = _DEFAULT_SVG_BOUNDS;
        }
        return this.svgBounds;
    }

    public void paint(Graphics2D g2d) {
        GraphicsNode gNode = this.svgComponent.getGraphicsNode();
        if (gNode != null) {
            gNode.paint(g2d);
        }
    }

    public void addSVGRenderingListener(SVGRenderingListener listener) {
        if (listener == null) {
            return;
        }
        this.svgrListenerList.add(listener);
    }

    public void removeSVGRenderingListener(SVGRenderingListener listener) {
        if (listener == null) {
            return;
        }
        if (this.svgrListenerList.contains(listener)) {
            this.svgrListenerList.remove(listener);
        }
    }

    private void _addListeners() {
        this.svgComponent.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildCompleted(GVTTreeBuilderEvent evt) {
                SVGPaintedObject.this.svgBounds = evt.getGVTRoot().getBounds();
                SVGPaintedObject.this._notifySVGRenderingListeners();
            }
        });
    }

    private void _notifySVGRenderingListeners() {
        for (SVGRenderingListener l : this.svgrListenerList) {
            if (l == null) continue;
            l.svgRenderingComplete();
        }
    }
}

