/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.Polygon2D;
import diva.util.java2d.Polyline2D;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public final class ShapeUtilities {
    private static boolean _jdk12beta4 = System.getProperty("java.version").equals("1.2beta4");
    private static BasicStroke[] _intStrokes = new BasicStroke[16];

    public static boolean jdk12beta4() {
        return _jdk12beta4;
    }

    public static Shape cloneShape(Shape s) {
        if (s instanceof RectangularShape) {
            return (RectangularShape)((RectangularShape)s).clone();
        }
        return new GeneralPath(s);
    }

    public static Shape createCloudShape() {
        if (ShapeUtilities.jdk12beta4()) {
            Area area = new Area();
            Ellipse2D.Double c = new Ellipse2D.Double();
            ((RectangularShape)c).setFrame(0.0, 25.0, 50.0, 50.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(25.0, 0.0, 40.0, 40.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(25.0, 25.0, 60.0, 60.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(60.0, 30.0, 40.0, 40.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(60.0, 10.0, 30.0, 30.0);
            area.add(new Area(c));
            return area;
        }
        GeneralPath cloud = new GeneralPath();
        cloud.moveTo(25.53f, 25.0f);
        cloud.curveTo(25.18f, 23.42f, 25.0f, 21.75f, 25.0f, 20.0f);
        cloud.curveTo(25.0f, 8.28f, 33.28f, 0.0f, 45.0f, 0.0f);
        cloud.curveTo(54.65f, 0.0f, 61.97f, 5.62f, 64.25f, 14.15f);
        cloud.curveTo(66.9f, 11.53f, 70.63f, 10.0f, 75.0f, 10.0f);
        cloud.curveTo(83.78f, 10.0f, 90.0f, 16.21f, 90.0f, 25.0f);
        cloud.curveTo(90.0f, 27.46f, 89.51f, 29.72f, 88.61f, 31.7f);
        cloud.curveTo(95.57f, 34.7f, 100.0f, 41.43f, 100.0f, 50.0f);
        cloud.curveTo(100.0f, 61.21f, 92.4f, 69.29f, 81.47f, 69.95f);
        cloud.curveTo(76.58f, 79.21f, 66.99f, 85.0f, 55.0f, 85.0f);
        cloud.curveTo(45.01f, 85.0f, 36.69f, 80.98f, 31.36f, 74.3f);
        cloud.curveTo(29.35f, 74.76f, 27.22f, 75.0f, 25.0f, 75.0f);
        cloud.curveTo(10.35f, 75.0f, 0.0f, 64.64f, 0.0f, 50.0f);
        cloud.curveTo(0.0f, 35.35f, 10.35f, 25.0f, 25.0f, 25.0f);
        cloud.curveTo(25.18f, 25.0f, 25.35f, 25.0f, 25.53f, 25.0f);
        cloud.closePath();
        return cloud;
    }

    public static Shape createSwatchShape() {
        if (ShapeUtilities.jdk12beta4()) {
            GeneralPath p = new GeneralPath();
            p.moveTo(10.0f, 30.0f);
            p.quadTo(30.0f, 10.0f, 85.0f, 15.0f);
            BasicStroke str = new BasicStroke(35.0f, 0, 1);
            Shape s = str.createStrokedShape(p);
            AffineTransform at = new AffineTransform();
            at.translate(5.0, 25.0);
            Area area = new Area(s);
            s = at.createTransformedShape(s);
            area.add(new Area(s));
            s = at.createTransformedShape(s);
            area.add(new Area(s));
            return area;
        }
        GeneralPath swatch = new GeneralPath();
        swatch.moveTo(32.37f, 92.37f);
        swatch.curveTo(24.12f, 84.12f, 15.87f, 75.87f, 7.62f, 67.62f);
        swatch.curveTo(10.93f, 64.32f, 14.69f, 61.41f, 18.88f, 58.88f);
        swatch.curveTo(13.46f, 53.46f, 8.04f, 48.04f, 2.62f, 42.62f);
        swatch.curveTo(5.93f, 39.32f, 9.69f, 36.41f, 13.88f, 33.88f);
        swatch.curveTo(8.46f, 28.46f, 3.04f, 23.04f, -2.37f, 17.62f);
        swatch.curveTo(6.8f, 8.47f, 19.36f, 2.29f, 35.3f, -0.9f);
        swatch.curveTo(43.93f, -2.63f, 53.64f, -3.49f, 64.43f, -3.49f);
        swatch.curveTo(71.37f, -3.49f, 78.75f, -3.13f, 86.58f, -2.42f);
        swatch.curveTo(85.84f, 5.71f, 85.1f, 13.86f, 84.36f, 22.0f);
        swatch.curveTo(86.72f, 22.16f, 89.13f, 22.34f, 91.58f, 22.57f);
        swatch.curveTo(90.84f, 30.71f, 90.1f, 38.86f, 89.36f, 47.0f);
        swatch.curveTo(91.72f, 47.16f, 94.13f, 47.34f, 96.58f, 47.57f);
        swatch.curveTo(95.52f, 59.19f, 94.47f, 70.8f, 93.41f, 82.42f);
        swatch.curveTo(86.57f, 81.8f, 80.21f, 81.49f, 74.35f, 81.49f);
        swatch.curveTo(65.95f, 81.49f, 58.57f, 82.13f, 52.19f, 83.4f);
        swatch.curveTo(43.14f, 85.19f, 36.54f, 88.18f, 32.37f, 92.37f);
        swatch.closePath();
        return swatch;
    }

    public static Rectangle2D computeStrokedBounds(Shape shape, Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            Rectangle2D rect = shape.getBounds2D();
            int width = (int)((BasicStroke)stroke).getLineWidth() + 2;
            return new Rectangle2D.Double(rect.getX() - (double)width, rect.getY() - (double)width, rect.getWidth() + (double)width + (double)width, rect.getHeight() + (double)width + (double)width);
        }
        Rectangle2D rect = stroke.createStrokedShape(shape).getBounds2D();
        return new Rectangle2D.Double(rect.getX() - 1.0, rect.getY() - 1.0, rect.getWidth() + 2.0, rect.getHeight() + 2.0);
    }

    public static BasicStroke getStroke(int width) {
        if (width < _intStrokes.length) {
            if (_intStrokes[width] == null) {
                ShapeUtilities._intStrokes[width] = new BasicStroke(width);
            }
            return _intStrokes[width];
        }
        return new BasicStroke(width);
    }

    public static BasicStroke getStroke(float floatwidth) {
        int width = Math.round(floatwidth);
        if ((float)width == floatwidth) {
            return ShapeUtilities.getStroke(width);
        }
        return new BasicStroke(floatwidth);
    }

    public static boolean intersectsOutline(Rectangle2D r, Shape s) {
        PathIterator i = s.getPathIterator(null, 0.01);
        double[] points = new double[6];
        double lastX = 0.0;
        double lastY = 0.0;
        double firstX = 0.0;
        double firstY = 0.0;
        while (!i.isDone()) {
            int type = i.currentSegment(points);
            if (type == 0) {
                firstX = points[0];
                firstY = points[1];
            } else if (type == 1 ? r.intersectsLine(lastX, lastY, points[0], points[1]) : type == 4 && r.intersectsLine(lastX, lastY, firstX, firstY)) {
                return true;
            }
            lastX = points[0];
            lastY = points[1];
            i.next();
        }
        return false;
    }

    public static boolean isOrthogonal(AffineTransform at) {
        int t = at.getType();
        return (t & 0x38) == 0;
    }

    public static String printShapeAsCode(String name, Shape shape) {
        StringBuffer s = new StringBuffer();
        PathIterator p = shape.getPathIterator(null);
        float[] data = new float[6];
        s.append("GeneralPath " + name + " = new GeneralPath();\n");
        while (!p.isDone()) {
            int type = p.currentSegment(data);
            switch (type) {
                case 4: {
                    s.append(String.valueOf(name) + ".closePath();");
                    break;
                }
                case 0: {
                    s.append(String.valueOf(name) + ".moveTo(");
                    s.append(String.valueOf(data[0]) + "f, ");
                    s.append(String.valueOf(data[1]) + "f);\n");
                    break;
                }
                case 1: {
                    s.append(String.valueOf(name) + ".lineTo(");
                    s.append(String.valueOf(data[0]) + "f, ");
                    s.append(String.valueOf(data[1]) + "f);\n");
                    break;
                }
                case 2: {
                    s.append(String.valueOf(name) + ".quadTo(");
                    s.append(String.valueOf(data[0]) + "f, ");
                    s.append(String.valueOf(data[1]) + "f, ");
                    s.append(String.valueOf(data[2]) + "f, ");
                    s.append(String.valueOf(data[3]) + "f);\n");
                    break;
                }
                case 3: {
                    s.append(String.valueOf(name) + ".curveTo(");
                    s.append(String.valueOf(data[0]) + "f, ");
                    s.append(String.valueOf(data[1]) + "f, ");
                    s.append(String.valueOf(data[2]) + "f, ");
                    s.append(String.valueOf(data[3]) + "f, ");
                    s.append(String.valueOf(data[4]) + "f, ");
                    s.append(String.valueOf(data[5]) + "f);\n");
                }
            }
            p.next();
        }
        s.append(String.valueOf(name) + ".closePath();");
        return s.toString();
    }

    public static Rectangle2D transformBounds(Rectangle2D rect, AffineTransform at) {
        double[] coords;
        if (at.isIdentity()) {
            return rect.getBounds2D();
        }
        if (!ShapeUtilities.isOrthogonal(at)) {
            return at.createTransformedShape(rect).getBounds2D();
        }
        if (rect instanceof Rectangle2D.Double) {
            Rectangle2D.Double r = (Rectangle2D.Double)rect;
            double[] coords2 = new double[]{r.x, r.y, r.x + r.width, r.y + r.height};
            at.transform(coords2, 0, coords2, 0, 2);
            return new Rectangle2D.Double(coords2[0], coords2[1], coords2[2] - coords2[0], coords2[3] - coords2[1]);
        }
        if (rect instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)rect;
            float[] coords3 = new float[]{r.x, r.y, r.x + r.width, r.y + r.height};
            at.transform(coords3, 0, coords3, 0, 2);
            return new Rectangle2D.Float(coords3[0], coords3[1], coords3[2] - coords3[0], coords3[3] - coords3[1]);
        }
        coords = new double[]{rect.getX(), rect.getY(), coords[0] + rect.getWidth(), coords[1] + rect.getHeight()};
        at.transform(coords, 0, coords, 0, 2);
        return new Rectangle2D.Double(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
    }

    public static void transformModifyRect(RectangularShape s, AffineTransform at) {
        if (at.isIdentity()) {
            return;
        }
        if (!ShapeUtilities.isOrthogonal(at)) {
            s.setFrame(at.createTransformedShape(s).getBounds2D());
        }
        if (s instanceof Rectangle2D.Double) {
            Rectangle2D.Double r = (Rectangle2D.Double)s;
            double[] coords = new double[]{r.x, r.y, r.x + r.width, r.y + r.height};
            at.transform(coords, 0, coords, 0, 2);
            r.x = coords[0];
            r.y = coords[1];
            r.width = coords[2] - coords[0];
            r.height = coords[3] - coords[1];
        } else if (s instanceof Rectangle2D.Float) {
            Rectangle2D.Float r = (Rectangle2D.Float)s;
            float[] coords = new float[]{r.x, r.y, r.x + r.width, r.y + r.height};
            at.transform(coords, 0, coords, 0, 2);
            r.x = coords[0];
            r.y = coords[1];
            r.width = coords[2] - coords[0];
            r.height = coords[3] - coords[1];
        } else {
            double[] coords;
            coords = new double[]{s.getX(), s.getY(), coords[0] + s.getWidth(), coords[1] + s.getHeight()};
            at.transform(coords, 0, coords, 0, 2);
            s.setFrameFromDiagonal(coords[0], coords[1], coords[2], coords[3]);
        }
    }

    public static Shape transformModify(Shape s, AffineTransform at) {
        if (s instanceof RectangularShape && ShapeUtilities.isOrthogonal(at)) {
            ShapeUtilities.transformModifyRect((RectangularShape)s, at);
            return s;
        }
        if (s instanceof Polygon2D) {
            ((Polygon2D)s).transform(at);
            return s;
        }
        if (s instanceof Polyline2D) {
            ((Polyline2D)s).transform(at);
            return s;
        }
        if (s instanceof GeneralPath) {
            ((GeneralPath)s).transform(at);
            return s;
        }
        return at.createTransformedShape(s);
    }

    public static Shape translateModify(Shape s, double x, double y) {
        if (s instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)s;
            r.setFrame(x + r.getX(), y + r.getY(), r.getWidth(), r.getHeight());
            return r;
        }
        if (s instanceof Polygon2D) {
            ((Polygon2D)s).translate(x, y);
            return s;
        }
        if (s instanceof Polyline2D) {
            ((Polyline2D)s).translate(x, y);
            return s;
        }
        if (s instanceof GeneralPath) {
            AffineTransform at = AffineTransform.getTranslateInstance(x, y);
            ((GeneralPath)s).transform(at);
            return s;
        }
        AffineTransform at1 = AffineTransform.getTranslateInstance(x, y);
        return at1.createTransformedShape(s);
    }

    public static void main(String[] argv) {
        if (ShapeUtilities.jdk12beta4()) {
            System.out.println(ShapeUtilities.printShapeAsCode("cloud", ShapeUtilities.createCloudShape()));
            System.out.println(ShapeUtilities.printShapeAsCode("swatch", ShapeUtilities.createSwatchShape()));
        }
    }
}

