/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.Polyline2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public class PolylineIterator
implements PathIterator {
    private double[] _coords;
    private int _index = 0;

    public PolylineIterator(Polyline2D pl, AffineTransform at) {
        int count = pl.getVertexCount() * 2;
        this._coords = new double[count];
        if (pl instanceof Polyline2D.Float) {
            Polyline2D.Float f = (Polyline2D.Float)pl;
            if (at == null || at.isIdentity()) {
                int i = 0;
                while (i < count) {
                    this._coords[i] = f._coords[i];
                    ++i;
                }
            } else {
                at.transform(f._coords, 0, this._coords, 0, count / 2);
            }
        } else {
            Polyline2D.Double d = (Polyline2D.Double)pl;
            if (at == null || at.isIdentity()) {
                System.arraycopy(d._coords, 0, this._coords, 0, count);
            } else {
                at.transform(d._coords, 0, this._coords, 0, count / 2);
            }
        }
    }

    public int currentSegment(double[] coords) {
        coords[0] = this._coords[this._index];
        coords[1] = this._coords[this._index + 1];
        return this._index == 0 ? 0 : 1;
    }

    public int currentSegment(float[] coords) {
        coords[0] = (float)this._coords[this._index];
        coords[1] = (float)this._coords[this._index + 1];
        return this._index == 0 ? 0 : 1;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this._index >= this._coords.length;
    }

    public void next() {
        this._index += 2;
    }
}

