/*
 * Decompiled with CFR 0.152.
 */
package diva.gui.toolbox;

import diva.canvas.CanvasUtilities;
import diva.canvas.JCanvas;
import diva.canvas.TransformContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JPanner
extends JPanel {
    private JViewport _target = null;
    private ScrollListener _listener = new ScrollListener();
    private ScaleMouseListener _scaleMouseListener = new ScaleMouseListener();

    public JPanner() {
        this((JViewport)null);
    }

    public JPanner(JViewport target) {
        this.setViewport(target);
        this.addMouseListener(new PanMouseListener());
        this.addMouseMotionListener(new PanMouseListener());
    }

    public void setPosition(int x, int y) {
        int max;
        Dimension viewSize = this._target.getView().getSize();
        Rectangle viewRect = new Rectangle(0, 0, viewSize.width, viewSize.height);
        Rectangle myRect = this._getInsetBounds();
        AffineTransform forward = CanvasUtilities.computeFitTransform(viewRect, myRect);
        Dimension extentSize = this._target.getExtentSize();
        x = (int)((double)x / forward.getScaleX()) - extentSize.width / 2;
        y = (int)((double)y / forward.getScaleY()) - extentSize.height / 2;
        if (x < 0) {
            x = 0;
        }
        if (x > (max = viewSize.width - extentSize.width)) {
            x = max;
        }
        if (y < 0) {
            y = 0;
        }
        if (y > (max = viewSize.height - extentSize.height)) {
            y = max;
        }
        this._target.setViewPosition(new Point(x, y));
    }

    public void setViewport(JViewport target) {
        if (this._target != null) {
            this._target.removeChangeListener(this._listener);
            if (this._target.getView() instanceof JCanvas) {
                this.removeMouseListener(this._scaleMouseListener);
                this.removeMouseMotionListener(this._scaleMouseListener);
            }
        }
        this._target = target;
        if (this._target != null) {
            this._target.addChangeListener(this._listener);
            if (this._target.getView() instanceof JCanvas) {
                this.addMouseListener(this._scaleMouseListener);
                this.addMouseMotionListener(this._scaleMouseListener);
            }
        }
        this.repaint();
    }

    public JViewport getViewport() {
        return this._target;
    }

    public void paintComponent(Graphics g) {
        if (this._target != null) {
            AffineTransform inverse;
            JCanvas canvas = null;
            try {
                canvas = (JCanvas)this._target.getView();
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Failed to cast " + this._target.getView() + " to JCanvas.", ex);
            }
            Dimension viewSize = canvas.getSize();
            Rectangle viewRect = new Rectangle(0, 0, viewSize.width, viewSize.height);
            Rectangle myRect = this._getInsetBounds();
            AffineTransform forward = CanvasUtilities.computeFitTransform(viewRect, myRect);
            AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
            try {
                inverse = forward.createInverse();
                inverse.concatenate(current.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e.toString());
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.transform(forward);
            canvas.paint(g);
            g.setColor(Color.red);
            Rectangle r = this._target.getViewRect();
            g.drawRect(r.x, r.y, r.width, r.height);
            g2d.transform(inverse);
        } else {
            Rectangle r = this._getInsetBounds();
            g.clearRect(r.x, r.y, r.width, r.height);
        }
    }

    private Rectangle _getInsetBounds() {
        Dimension mySize = this.getSize();
        Insets insets = this.getInsets();
        Rectangle myRect = new Rectangle(insets.left, insets.top, mySize.width - insets.top - insets.bottom, mySize.height - insets.left - insets.right);
        return myRect;
    }

    public static void main(String[] argv) {
        try {
            Runnable doActions = new Runnable(){

                public void run() {
                    try {
                        JFrame f = new JFrame();
                        String[] data = new String[]{"oneeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee", "twoooooooooooooooooooooooooooooooooooooooo", "threeeeeeeeeeeeeeeee", "fourrrrrrrrrrrrrrrrrrrrrrrrr"};
                        JList<String> dataList = new JList<String>(data);
                        JScrollPane p = new JScrollPane(dataList);
                        p.setSize(200, 200);
                        JPanner pan = new JPanner(p.getViewport());
                        pan.setSize(200, 200);
                        f.getContentPane().setLayout(new GridLayout(2, 1));
                        f.getContentPane().add(p);
                        f.getContentPane().add(pan);
                        f.setSize(200, 400);
                        f.setVisible(true);
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                        ex.printStackTrace();
                    }
                }
            };
            SwingUtilities.invokeAndWait(doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
    }

    private class PanMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private PanMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (JPanner.this._target != null && (evt.getModifiers() & 0x10) != 0) {
                JPanner.this.setPosition(evt.getX(), evt.getY());
            }
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            if (JPanner.this._target != null && (evt.getModifiers() & 0x10) != 0) {
                JPanner.this.setPosition(evt.getX(), evt.getY());
            }
        }
    }

    private class ScaleMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public Point2D origin = null;
        public Point2D scaled = null;
        public AffineTransform transformOrigin = null;

        private ScaleMouseListener() {
        }

        public void setScale(int x, int y) {
            double scale = (double)x > this.origin.getX() && (double)y > this.origin.getY() ? ((double)x - this.origin.getX() > (double)y - this.origin.getY() ? ((double)y - this.origin.getY()) / 5.0 : ((double)x - this.origin.getX()) / 5.0) : ((double)x < this.origin.getX() && (double)y < this.origin.getY() ? (this.origin.getX() - (double)x > this.origin.getY() - (double)y ? ((double)y - this.origin.getY()) / 5.0 : ((double)x - this.origin.getX()) / 5.0) : 0.0);
            scale = Math.pow(1.3, scale);
            JCanvas canvas = (JCanvas)JPanner.this._target.getView();
            AffineTransform current = canvas.getCanvasPane().getTransformContext().getTransform();
            current.setTransform(this.transformOrigin);
            current.translate(this.scaled.getX(), this.scaled.getY());
            current.scale(scale, scale);
            current.translate(-this.scaled.getX(), -this.scaled.getY());
            canvas.getCanvasPane().setTransform(current);
        }

        public void mousePressed(MouseEvent evt) {
            if (JPanner.this._target != null && (evt.getModifiers() & 4) != 0) {
                JPanner.this.setPosition(evt.getX(), evt.getY());
                this.origin = evt.getPoint();
                JCanvas canvas = (JCanvas)JPanner.this._target.getView();
                TransformContext context = canvas.getCanvasPane().getTransformContext();
                this.transformOrigin = (AffineTransform)context.getTransform().clone();
                Dimension viewSize = JPanner.this._target.getView().getSize();
                Rectangle viewRect = new Rectangle(0, 0, viewSize.width, viewSize.height);
                Rectangle myRect = JPanner.this._getInsetBounds();
                AffineTransform forward = CanvasUtilities.computeFitTransform(viewRect, myRect);
                double xScaled = (this.origin.getX() - myRect.getX()) / forward.getScaleX();
                double yScaled = (this.origin.getY() - myRect.getY()) / forward.getScaleY();
                this.scaled = new Point2D.Double(xScaled, yScaled);
                try {
                    context.getInverseTransform().transform(this.scaled, this.scaled);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            if (JPanner.this._target != null && (evt.getModifiers() & 4) != 0) {
                this.setScale(evt.getX(), evt.getY());
            }
        }
    }

    private class ScrollListener
    implements ChangeListener {
        private ScrollListener() {
        }

        public void stateChanged(ChangeEvent e) {
            JPanner.this.repaint();
        }
    }
}

