/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.GeometricSet;
import diva.canvas.ZList;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BasicZList
implements ZList {
    private ArrayList _elements = new ArrayList();

    public void add(Figure f) {
        this._elements.add(f);
    }

    public void add(int index, Figure f) {
        this._elements.add(this._elements.size() - index, f);
    }

    public void clear() {
        this._elements.clear();
    }

    public Rectangle2D getBounds() {
        return CanvasUtilities.computeCompositeBounds(this.figures());
    }

    public boolean contains(Figure f) {
        return this._elements.contains(f);
    }

    public Iterator figures() {
        return this._elements.iterator();
    }

    public Iterator figuresFromBack() {
        return this._elements.iterator();
    }

    public Iterator figuresFromFront() {
        return new Iterator(){
            int cursor;
            {
                this.cursor = BasicZList.this._elements.size();
            }

            public boolean hasNext() {
                return this.cursor > 0;
            }

            public Object next() throws NoSuchElementException {
                if (this.cursor <= 0) {
                    throw new NoSuchElementException("Can't get " + this.cursor + "'th element from BasicZList of size " + BasicZList.this._elements.size());
                }
                --this.cursor;
                return BasicZList.this._elements.get(this.cursor);
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot delete figure from zlist");
            }
        };
    }

    public Figure get(int index) {
        return (Figure)this._elements.get(this._elements.size() - 1 - index);
    }

    public int getFigureCount() {
        return this._elements.size();
    }

    public GeometricSet getContainedFigures(Rectangle2D region) {
        return new EnclosedGSet(region);
    }

    public GeometricSet getIntersectedFigures(Rectangle2D region) {
        return new IntersectedGSet(region);
    }

    public int indexOf(Figure f) {
        int i = this._elements.indexOf(f);
        if (i == -1) {
            return -1;
        }
        return this._elements.size() - 1 - i;
    }

    public void remove(Figure f) {
        this._elements.remove(f);
    }

    public void remove(int index) {
        this._elements.remove(this._elements.size() - 1 - index);
    }

    public void set(int index, Figure f) {
        this._elements.set(this._elements.size() - 1 - index, f);
    }

    public void setIndex(int index, Figure f) {
        this._elements.remove(f);
        this._elements.add(this._elements.size() - index, f);
    }

    private class EnclosedGSet
    extends GSet {
        public EnclosedGSet(Rectangle2D region) {
            super(region);
        }

        public boolean _contains(Figure f, Rectangle2D region) {
            return region.contains(f.getBounds());
        }

        public void _filter(ArrayList result, Iterator i, Rectangle2D region) {
            while (i.hasNext()) {
                Figure f = (Figure)i.next();
                if (!region.contains(f.getBounds())) continue;
                result.add(f);
            }
        }
    }

    private abstract class GSet
    implements GeometricSet {
        private Rectangle2D _region;
        private ArrayList _currentFigures = new ArrayList();

        public GSet(Rectangle2D region) {
            this.setGeometry(region);
        }

        public boolean contains(Figure f) {
            return this._contains(f, this._region);
        }

        public Iterator figures() {
            return this._currentFigures.iterator();
        }

        public Iterator figuresFromBack() {
            return this._currentFigures.iterator();
        }

        public Iterator figuresFromFront() {
            return new Iterator(){
                int cursor;
                {
                    this.cursor = GSet.this._currentFigures.size();
                }

                public boolean hasNext() {
                    return this.cursor > 0;
                }

                public Object next() throws NoSuchElementException {
                    if (this.cursor <= 0) {
                        throw new NoSuchElementException("Can't get " + this.cursor + "'th element from BasicZList of size " + GSet.this._currentFigures.size());
                    }
                    --this.cursor;
                    return GSet.this._currentFigures.get(this.cursor);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Cannot delete figure from geometric set");
                }
            };
        }

        public Shape getGeometry() {
            return this._region;
        }

        public void setGeometry(Shape geometry) {
            this._region = (Rectangle2D)geometry;
            this._currentFigures = new ArrayList(this._currentFigures.size());
            this._filter(this._currentFigures, BasicZList.this._elements.iterator(), this._region);
        }

        public abstract boolean _contains(Figure var1, Rectangle2D var2);

        protected abstract void _filter(ArrayList var1, Iterator var2, Rectangle2D var3);
    }

    private class IntersectedGSet
    extends GSet {
        public IntersectedGSet(Rectangle2D region) {
            super(region);
        }

        public boolean _contains(Figure f, Rectangle2D region) {
            return f.getBounds().intersects(region);
        }

        public void _filter(ArrayList result, Iterator i, Rectangle2D region) {
            while (i.hasNext()) {
                Figure f = (Figure)i.next();
                if (!f.getBounds().intersects(region)) continue;
                result.add(f);
            }
        }
    }
}

