/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class NumberSpinnerEditor
extends PropertyEditorSupport {
    private static boolean allowNullByDefault = true;
    private static String nameOfNull = "null";
    private static String nameOfCreation = "create ...";
    protected SpinnerNumberModel model;
    private Box panel;
    JButton nullButton;
    private JButton button;
    private boolean nullAllowed = true;
    private JSpinner spinner;

    public NumberSpinnerEditor() {
        this(allowNullByDefault);
    }

    public NumberSpinnerEditor(boolean withNullOption) {
        this.nullAllowed = withNullOption;
        this.makeModel();
        this.customize();
        this.panel = new Box(0);
        this.spinner = new JSpinner(this.model);
        this.spinner.setPreferredSize(new Dimension(60, 20));
        this.model.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                NumberSpinnerEditor.this.setValue(NumberSpinnerEditor.this.model.getValue());
            }
        });
        this.button = new JButton(nameOfCreation);
        this.button.setMaximumSize(new Dimension(32000, 25));
        this.button.setPreferredSize(new Dimension(50, 25));
        this.button.setMargin(new Insets(2, 2, 2, 2));
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumberSpinnerEditor.this.setValue(NumberSpinnerEditor.this.model.getValue());
            }
        });
        if (this.nullAllowed) {
            this.nullButton = new JButton(nameOfNull);
            this.nullButton.setMargin(new Insets(2, 2, 2, 2));
            this.nullButton.setMaximumSize(new Dimension(60, 25));
            this.nullButton.setForeground(Color.red);
            this.nullButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    NumberSpinnerEditor.this.setValue(null);
                }
            });
            this.panel.add(this.button);
        } else {
            this.panel.add(this.spinner);
        }
    }

    protected abstract void makeModel();

    public static String getNameOfNull() {
        return nameOfNull;
    }

    public static void setNameOfNull(String nameOfNull) {
        NumberSpinnerEditor.nameOfNull = nameOfNull;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this.panel;
    }

    protected void customize() {
    }

    public void setValue(Object value) {
        if (this.nullAllowed) {
            if (value != null && this.getValue() == null) {
                this.model.setValue(value);
                this.panel.removeAll();
                this.panel.add(this.spinner);
                this.panel.add(this.nullButton);
                this.panel.validate();
            }
            if (value == null && this.getValue() != null) {
                this.panel.removeAll();
                this.panel.add(this.button);
                this.panel.validate();
            }
            if (value != null && this.getValue() != null) {
                this.model.setValue(value);
            }
        } else {
            this.model.setValue(value);
        }
        super.setValue(value);
    }

    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        return ((Integer)this.getValue()).toString();
    }

    public void setAsText(String text) {
        if (text == null) {
            this.setValue(null);
        } else {
            try {
                Integer val = new Integer(Integer.parseInt(text));
                this.setValue(val);
            }
            catch (NumberFormatException nfe) {
                System.out.println("nfe " + text);
                this.setValue(null);
            }
        }
    }

    public static String getNameOfCreation() {
        return nameOfCreation;
    }

    public static void setNameOfCreation(String nameOfCreation) {
        NumberSpinnerEditor.nameOfCreation = nameOfCreation;
    }

    public static boolean isAllowNullByDefault() {
        return allowNullByDefault;
    }

    public static void setAllowNullByDefault(boolean allowNullByDefault) {
        NumberSpinnerEditor.allowNullByDefault = allowNullByDefault;
    }
}

