/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.beans;

import de.jtem.beans.ChangeEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DimensionPanel
extends JPanel {
    private static final long serialVersionUID = -689497176051389498L;
    private SpinnerNumberModel widthModel = new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1));
    private SpinnerNumberModel heightModel;
    private JButton keepAspectButton;
    private boolean keepAspect = true;
    private ChangeListener changeListener;
    private double aspectRatio;
    private boolean doNotFire;
    private ImageIcon openChain;
    private ImageIcon closedChain;

    public DimensionPanel() {
        super(new GridBagLayout());
        this.widthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DimensionPanel.this.setWidthFromSpinner();
            }
        });
        this.heightModel = new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1));
        this.heightModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DimensionPanel.this.setHeightFromSpinner();
            }
        });
        Insets insets = new Insets(3, 3, 3, 3);
        JLabel widthLabel = new JLabel("width:");
        widthLabel.setHorizontalAlignment(4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)widthLabel, gbc);
        JSpinner widthSpinner = new JSpinner(this.widthModel);
        widthSpinner.setPreferredSize(new Dimension(60, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.fill = 1;
        this.add((Component)widthSpinner, gbc);
        JLabel heightLabel = new JLabel("height:");
        heightLabel.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 13;
        gbc.fill = 1;
        this.add((Component)heightLabel, gbc);
        JSpinner heightSpinner = new JSpinner(this.heightModel);
        heightSpinner.setPreferredSize(new Dimension(60, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.fill = 1;
        this.add((Component)heightSpinner, gbc);
        this.keepAspectButton = new JButton();
        this.keepAspectButton.setFocusable(false);
        this.keepAspectButton.setMargin(insets);
        URL imgURL = DimensionPanel.class.getResource("openChain.gif");
        this.openChain = new ImageIcon(imgURL);
        imgURL = DimensionPanel.class.getResource("closedChain.gif");
        this.closedChain = new ImageIcon(imgURL);
        this.keepAspectButton.setIcon(this.keepAspect ? this.closedChain : this.openChain);
        this.keepAspectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DimensionPanel.this.keepAspect = !DimensionPanel.this.keepAspect;
                DimensionPanel.this.keepAspectButton.setIcon(DimensionPanel.this.keepAspect ? DimensionPanel.this.closedChain : DimensionPanel.this.openChain);
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.gridheight = 2;
        gbc.insets = insets;
        gbc.fill = 1;
        this.add((Component)this.keepAspectButton, gbc);
    }

    public Dimension getDimension() {
        return new Dimension(this.widthModel.getNumber().intValue(), this.heightModel.getNumber().intValue());
    }

    public void setDimension(Dimension d) {
        int w = this.widthModel.getNumber().intValue();
        int h = this.heightModel.getNumber().intValue();
        this.aspectRatio = (double)d.height / (double)d.width;
        if (d.width != w || d.height != h) {
            this.doNotFire = true;
            this.widthModel.setValue(new Integer(d.width));
            this.heightModel.setValue(new Integer(d.height));
            this.doNotFire = false;
            this.fireChange();
        }
    }

    private void setWidthFromSpinner() {
        int w = this.widthModel.getNumber().intValue();
        if (!this.doNotFire) {
            if (this.keepAspect) {
                this.doNotFire = true;
                this.heightModel.setValue(new Integer((int)((double)w * this.aspectRatio)));
                this.doNotFire = false;
            } else {
                double h = this.heightModel.getNumber().doubleValue();
                this.aspectRatio = h / (double)w;
            }
        }
        this.fireChange();
    }

    private void setHeightFromSpinner() {
        int h = this.heightModel.getNumber().intValue();
        if (!this.doNotFire) {
            if (this.keepAspect) {
                this.doNotFire = true;
                this.widthModel.setValue(new Integer((int)((double)h / this.aspectRatio)));
                this.doNotFire = false;
            } else {
                double w = this.widthModel.getNumber().doubleValue();
                this.aspectRatio = (double)h / w;
            }
        }
        this.fireChange();
    }

    private void fireChange() {
        if (this.changeListener != null) {
            this.changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.add(this.changeListener, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener = ChangeEventMulticaster.remove(this.changeListener, listener);
    }
}

