/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.iap;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.LiteralException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.iap.ResponseHandler;
import com.sun.mail.iap.ResponseInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class Protocol {
    protected String host;
    private Socket socket;
    protected boolean debug;
    protected boolean quote;
    protected PrintStream out;
    protected Properties props;
    protected String prefix;
    private boolean connected = false;
    private TraceInputStream traceInput;
    private volatile ResponseInputStream input;
    private TraceOutputStream traceOutput;
    private volatile DataOutputStream output;
    private int tagCounter = 0;
    private volatile Vector handlers = null;
    private volatile long timestamp;
    private static final byte[] CRLF = new byte[]{13, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protocol(String string, int n, boolean bl, PrintStream printStream, Properties properties, String string2, boolean bl2) throws IOException, ProtocolException {
        try {
            this.host = string;
            this.debug = bl;
            this.out = printStream;
            this.props = properties;
            this.prefix = string2;
            this.socket = SocketFetcher.getSocket(string, n, properties, string2, bl2);
            String string3 = properties.getProperty("mail.debug.quote");
            this.quote = string3 != null && string3.equalsIgnoreCase("true");
            this.initStreams(printStream);
            this.processGreeting(this.readResponse());
            this.timestamp = System.currentTimeMillis();
            this.connected = true;
            Object var10_9 = null;
            if (!this.connected) {
                this.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!this.connected) {
                this.disconnect();
            }
            throw throwable;
        }
    }

    private void initStreams(PrintStream printStream) throws IOException {
        this.traceInput = new TraceInputStream(this.socket.getInputStream(), printStream);
        this.traceInput.setTrace(this.debug);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream(this.traceInput);
        this.traceOutput = new TraceOutputStream(this.socket.getOutputStream(), printStream);
        this.traceOutput.setTrace(this.debug);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream(this.traceOutput));
    }

    public Protocol(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        this.host = "localhost";
        this.debug = bl;
        this.quote = false;
        this.out = System.out;
        this.traceInput = new TraceInputStream(inputStream, System.out);
        this.traceInput.setTrace(bl);
        this.traceInput.setQuote(this.quote);
        this.input = new ResponseInputStream(this.traceInput);
        this.traceOutput = new TraceOutputStream(outputStream, System.out);
        this.traceOutput.setTrace(bl);
        this.traceOutput.setQuote(this.quote);
        this.output = new DataOutputStream(new BufferedOutputStream(this.traceOutput));
        this.timestamp = System.currentTimeMillis();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public synchronized void addResponseHandler(ResponseHandler responseHandler) {
        if (this.handlers == null) {
            this.handlers = new Vector();
        }
        this.handlers.addElement(responseHandler);
    }

    public synchronized void removeResponseHandler(ResponseHandler responseHandler) {
        if (this.handlers != null) {
            this.handlers.removeElement(responseHandler);
        }
    }

    public void notifyResponseHandlers(Response[] responseArray) {
        if (this.handlers == null) {
            return;
        }
        int n = 0;
        while (n < responseArray.length) {
            Response response = responseArray[n];
            if (response != null) {
                int n2 = this.handlers.size();
                if (n2 == 0) {
                    return;
                }
                Object[] objectArray = new Object[n2];
                this.handlers.copyInto(objectArray);
                int n3 = 0;
                while (n3 < n2) {
                    ((ResponseHandler)objectArray[n3]).handleResponse(response);
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected void processGreeting(Response response) throws ProtocolException {
        if (response.isBYE()) {
            throw new ConnectionException(this, response);
        }
    }

    protected ResponseInputStream getInputStream() {
        return this.input;
    }

    protected OutputStream getOutputStream() {
        return this.output;
    }

    protected synchronized boolean supportsNonSyncLiterals() {
        return false;
    }

    public Response readResponse() throws IOException, ProtocolException {
        return new Response(this);
    }

    protected ByteArray getResponseBuffer() {
        return null;
    }

    public String writeCommand(String string, Argument argument) throws IOException, ProtocolException {
        String string2 = "A" + Integer.toString(this.tagCounter++, 10);
        this.output.writeBytes(string2 + " " + string);
        if (argument != null) {
            this.output.write(32);
            argument.write(this);
        }
        this.output.write(CRLF);
        this.output.flush();
        return string2;
    }

    public synchronized Response[] command(String string, Argument argument) {
        Vector<Response> vector = new Vector<Response>();
        boolean bl = false;
        String string2 = null;
        Response response = null;
        try {
            string2 = this.writeCommand(string, argument);
        }
        catch (LiteralException literalException) {
            vector.addElement(literalException.getResponse());
            bl = true;
        }
        catch (Exception exception) {
            vector.addElement(Response.byeResponse(exception));
            bl = true;
        }
        while (!bl) {
            try {
                response = this.readResponse();
            }
            catch (IOException iOException) {
                response = Response.byeResponse(iOException);
            }
            catch (ProtocolException protocolException) {
                continue;
            }
            vector.addElement(response);
            if (response.isBYE()) {
                bl = true;
            }
            if (!response.isTagged() || !response.getTag().equals(string2)) continue;
            bl = true;
        }
        Object[] objectArray = new Response[vector.size()];
        vector.copyInto(objectArray);
        this.timestamp = System.currentTimeMillis();
        return objectArray;
    }

    public void handleResult(Response response) throws ProtocolException {
        if (response.isOK()) {
            return;
        }
        if (response.isNO()) {
            throw new CommandFailedException(response);
        }
        if (response.isBAD()) {
            throw new BadCommandException(response);
        }
        if (response.isBYE()) {
            this.disconnect();
            throw new ConnectionException(this, response);
        }
    }

    public void simpleCommand(String string, Argument argument) throws ProtocolException {
        Response[] responseArray = this.command(string, argument);
        this.notifyResponseHandlers(responseArray);
        this.handleResult(responseArray[responseArray.length - 1]);
    }

    public synchronized void startTLS(String string) throws IOException, ProtocolException {
        this.simpleCommand(string, null);
        this.socket = SocketFetcher.startTLS(this.socket, this.props, this.prefix);
        this.initStreams(this.out);
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.disconnect();
    }
}

