/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class AcceptLicensesWizardPage
extends WizardPage {
    private static final String DIALOG_SETTINGS_SECTION = "LicensessPage";
    private static final String LIST_WEIGHT = "ListSashWeight";
    private static final String LICENSE_WEIGHT = "LicenseSashWeight";
    private static final String NAME_COLUMN_WIDTH = "NameColumnWidth";
    private static final String VERSION_COLUMN_WIDTH = "VersionColumnWidth";
    TableViewer iuViewer;
    Text licenseTextBox;
    Button acceptButton;
    Button declineButton;
    SashForm sashForm;
    private IInstallableUnit[] originalIUs;
    private IInstallableUnit[] iusWithUnacceptedLicenses;
    private Policy policy;
    IUColumnConfig nameColumn;
    IUColumnConfig versionColumn;

    public AcceptLicensesWizardPage(Policy policy, IInstallableUnit[] ius, ProvisioningPlan plan) {
        super("AcceptLicenses");
        this.setTitle(ProvUIMessages.AcceptLicensesWizardPage_Title);
        this.policy = policy;
        this.update(ius, plan);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        if (this.iusWithUnacceptedLicenses.length == 0) {
            Label label = new Label(parent, 0);
            this.setControl((Control)label);
        } else if (this.iusWithUnacceptedLicenses.length == 1) {
            this.createLicenseSection(parent, true);
        } else {
            this.sashForm = new SashForm(parent, 256);
            this.sashForm.setLayout((Layout)new GridLayout());
            GridData gd = new GridData(4, 4, true, true);
            this.sashForm.setLayoutData((Object)gd);
            this.createIUSection((Composite)this.sashForm);
            this.createLicenseSection((Composite)this.sashForm, false);
            this.sashForm.setWeights(this.getSashWeights());
            this.setControl((Control)this.sashForm);
            Object element = this.iuViewer.getElementAt(0);
            if (element != null) {
                this.iuViewer.setSelection((ISelection)new StructuredSelection(element));
            }
        }
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private void createIUSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.AcceptLicensesWizardPage_ItemsLabel);
        this.iuViewer = new TableViewer(composite, 68352);
        this.setTableColumns(this.iuViewer.getTable());
        this.iuViewer.setContentProvider((IContentProvider)new ProvElementContentProvider());
        this.iuViewer.setLabelProvider((IBaseLabelProvider)new IUDetailsLabelProvider());
        this.iuViewer.setComparator(new ViewerComparator());
        this.iuViewer.setInput((Object)new IUElementListRoot(this.iusWithUnacceptedLicenses));
        this.iuViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceptLicensesWizardPage.this.handleSelectionChanged((IStructuredSelection)event.getSelection());
            }
        });
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.iuViewer.getControl().setLayoutData((Object)gd);
    }

    private void createLicenseAcceptSection(Composite parent, boolean multiple) {
        Composite buttonContainer = new Composite(parent, 0);
        GridData gd = new GridData(256);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)gd);
        this.acceptButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptMultiple);
        } else {
            this.acceptButton.setText(ProvUIMessages.AcceptLicensesWizardPage_AcceptSingle);
        }
        this.acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceptLicensesWizardPage.this.setPageComplete(AcceptLicensesWizardPage.this.acceptButton.getSelection());
            }
        });
        this.declineButton = new Button(buttonContainer, 16);
        if (multiple) {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectMultiple);
        } else {
            this.declineButton.setText(ProvUIMessages.AcceptLicensesWizardPage_RejectSingle);
        }
        this.declineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcceptLicensesWizardPage.this.setPageComplete(AcceptLicensesWizardPage.this.acceptButton.getSelection());
            }
        });
        this.acceptButton.setSelection(false);
        this.declineButton.setSelection(true);
    }

    private void createLicenseSection(Composite parent, boolean singleLicense) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.AcceptLicensesWizardPage_LicenseTextLabel);
        this.licenseTextBox = new Text(composite, 2634);
        this.licenseTextBox.setBackground(this.licenseTextBox.getDisplay().getSystemColor(25));
        this.initializeDialogUnits((Control)this.licenseTextBox);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        this.licenseTextBox.setLayoutData((Object)gd);
        this.createLicenseAcceptSection(composite, !singleLicense);
        if (singleLicense) {
            this.licenseTextBox.setText(this.getLicenseBody(this.iusWithUnacceptedLicenses[0]));
            this.setControl((Control)composite);
        }
    }

    void handleSelectionChanged(IStructuredSelection selection) {
        Object selected;
        if (!selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IInstallableUnit) {
            this.licenseTextBox.setText(this.getLicenseBody((IInstallableUnit)selected));
        }
    }

    private void setTableColumns(Table table) {
        table.setHeaderVisible(true);
        this.nameColumn = new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, this.convertWidthInCharsToPixels(40));
        this.versionColumn = new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, this.convertWidthInCharsToPixels(40));
        this.initializeDialogUnits((Control)table);
        this.getColumnWidthsFromSettings();
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setResizable(true);
        tc.setText(this.nameColumn.columnTitle);
        tc.setWidth(this.nameColumn.getWidth());
        tc = new TableColumn(table, 0, 1);
        tc.setResizable(true);
        tc.setText(this.versionColumn.columnTitle);
        tc.setWidth(this.versionColumn.getWidth());
    }

    public boolean performFinish() {
        this.rememberAcceptedLicenses();
        return true;
    }

    public boolean hasLicensesToAccept() {
        return this.iusWithUnacceptedLicenses.length > 0;
    }

    public void update(IInstallableUnit[] theIUs, ProvisioningPlan currentPlan) {
        this.originalIUs = theIUs;
        this.iusWithUnacceptedLicenses = theIUs == null ? new IInstallableUnit[0] : this.iusWithUnacceptedLicenses(theIUs, currentPlan);
        this.setDescription();
        this.setPageComplete(this.iusWithUnacceptedLicenses.length == 0);
        if (this.getControl() != null) {
            Composite parent = this.getControl().getParent();
            this.getControl().dispose();
            this.createControl(parent);
            parent.layout(true);
        }
    }

    private String getLicenseBody(IInstallableUnit iu) {
        ILicense license = IUPropertyUtils.getLicense(iu);
        if (license != null && license.getBody() != null) {
            return license.getBody();
        }
        return "";
    }

    private IInstallableUnit[] iusWithUnacceptedLicenses(IInstallableUnit[] selectedIUs, ProvisioningPlan currentPlan) {
        IInstallableUnit[] iusToCheck;
        if (currentPlan == null) {
            iusToCheck = selectedIUs;
        } else {
            ArrayList<IInstallableUnit> allIUs = new ArrayList<IInstallableUnit>();
            Operand[] operands = currentPlan.getOperands();
            int i = 0;
            while (i < operands.length) {
                IInstallableUnit addedIU;
                if (operands[i] instanceof InstallableUnitOperand && (addedIU = ((InstallableUnitOperand)operands[i]).second()) != null) {
                    allIUs.add(addedIU);
                }
                ++i;
            }
            iusToCheck = allIUs.toArray(new IInstallableUnit[allIUs.size()]);
        }
        HashMap<String, ILicense> licensesByIUName = new HashMap<String, ILicense>();
        ArrayList<IInstallableUnit> unaccepted = new ArrayList<IInstallableUnit>();
        IUDetailsLabelProvider labelProvider = new IUDetailsLabelProvider();
        int i = 0;
        while (i < iusToCheck.length) {
            IInstallableUnit iu = iusToCheck[i];
            String name = labelProvider.getText(iu);
            ILicense license = IUPropertyUtils.getLicense(iu);
            if (license != null && !this.policy.getLicenseManager().isAccepted(iu)) {
                ILicense potentialDuplicate = (ILicense)licensesByIUName.get(name);
                if (potentialDuplicate == null || !potentialDuplicate.equals((Object)license)) {
                    unaccepted.add(iu);
                }
                if (potentialDuplicate == null) {
                    licensesByIUName.put(name, license);
                }
            }
            ++i;
        }
        return unaccepted.toArray(new IInstallableUnit[unaccepted.size()]);
    }

    private void rememberAcceptedLicenses() {
        int i = 0;
        while (i < this.iusWithUnacceptedLicenses.length) {
            this.policy.getLicenseManager().accept(this.iusWithUnacceptedLicenses[i]);
            ++i;
        }
    }

    private void setDescription() {
        if (this.iusWithUnacceptedLicenses.length == 0) {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_NoLicensesDescription);
        } else if (this.iusWithUnacceptedLicenses.length <= this.originalIUs.length) {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_ReviewLicensesDescription);
        } else {
            this.setDescription(ProvUIMessages.AcceptLicensesWizardPage_ReviewExtraLicensesDescription);
        }
    }

    private String getDialogSettingsName() {
        return String.valueOf(this.getWizard().getClass().getName()) + "." + DIALOG_SETTINGS_SECTION;
    }

    public void saveBoundsRelatedSettings() {
        if (this.iuViewer == null || this.iuViewer.getTable().isDisposed()) {
            return;
        }
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsName());
        }
        section.put(NAME_COLUMN_WIDTH, this.iuViewer.getTable().getColumn(0).getWidth());
        section.put(VERSION_COLUMN_WIDTH, this.iuViewer.getTable().getColumn(1).getWidth());
        if (this.sashForm == null || this.sashForm.isDisposed()) {
            return;
        }
        int[] weights = this.sashForm.getWeights();
        section.put(LIST_WEIGHT, weights[0]);
        section.put(LICENSE_WEIGHT, weights[1]);
    }

    private void getColumnWidthsFromSettings() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section != null) {
            try {
                if (section.get(NAME_COLUMN_WIDTH) != null) {
                    this.nameColumn.columnWidth = section.getInt(NAME_COLUMN_WIDTH);
                }
                if (section.get(VERSION_COLUMN_WIDTH) != null) {
                    this.versionColumn.columnWidth = section.getInt(VERSION_COLUMN_WIDTH);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private int[] getSashWeights() {
        IDialogSettings settings = ProvUIActivator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsName());
        if (section != null) {
            try {
                int[] weights = new int[2];
                if (section.get(LIST_WEIGHT) != null) {
                    weights[0] = section.getInt(LIST_WEIGHT);
                    if (section.get(LICENSE_WEIGHT) != null) {
                        weights[1] = section.getInt(LICENSE_WEIGHT);
                        return weights;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new int[]{55, 45};
    }
}

