/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProvUI {
    public static final String INSTALL_COMMAND_LABEL = ProvUIMessages.InstallIUCommandLabel;
    public static final String INSTALL_COMMAND_TOOLTIP = ProvUIMessages.InstallIUCommandTooltip;
    public static final String UNINSTALL_COMMAND_LABEL = ProvUIMessages.UninstallIUCommandLabel;
    public static final String UNINSTALL_COMMAND_TOOLTIP = ProvUIMessages.UninstallIUCommandTooltip;
    public static final String UPDATE_COMMAND_LABEL = ProvUIMessages.UpdateIUCommandLabel;
    public static final String UPDATE_COMMAND_TOOLTIP = ProvUIMessages.UpdateIUCommandTooltip;
    public static final String REVERT_COMMAND_LABEL = ProvUIMessages.RevertIUCommandLabel;
    public static final String REVERT_COMMAND_TOOLTIP = ProvUIMessages.RevertIUCommandTooltip;
    static ObjectUndoContext provisioningUndoContext;
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    private static IUColumnConfig[] iuColumnConfig;
    private static final List reposNotFound;
    private static final String UPDATE_MANAGER_FIND_AND_INSTALL = "org.eclipse.ui.update.findAndInstallUpdates";
    private static final String UPDATE_MANAGER_MANAGE_CONFIGURATION = "org.eclipse.ui.update.manageConfiguration";
    private static final String INSTALLATION_DIALOG = "org.eclipse.ui.help.installationDialog";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        iuColumnConfig = new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 200), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 200)};
        reposNotFound = Collections.synchronizedList(new ArrayList());
    }

    public static IStatus handleException(Throwable t, String message, int style) {
        if (message == null && t != null) {
            message = t.getMessage();
        }
        Status status = new Status(4, "org.eclipse.equinox.p2.ui", 0, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
        return status;
    }

    public static void reportLoadFailure(final URI location, IStatus status, int style, final RepositoryManipulator repoManipulator) {
        int code = status.getCode();
        if (code == 1000 || code == 1006) {
            if (!ProvUI.hasNotFoundStatusBeenReported(location)) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        URI correctedLocation;
                        RepositoryNameAndLocationDialog dialog;
                        int ret;
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        if (workbench.isClosing()) {
                            return;
                        }
                        Shell shell = ProvUI.getDefaultParentShell();
                        if (MessageDialog.openQuestion((Shell)shell, (String)ProvUIMessages.ProvUI_LoadErrorTitle, (String)NLS.bind((String)ProvUIMessages.ProvUI_PromptForSiteEdit, (Object)URIUtil.toUnencodedString((URI)location))) && (ret = (dialog = new RepositoryNameAndLocationDialog(this, shell, Policy.getDefault(), location){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ URI val$location;
                            {
                                this.this$1 = var1_1;
                                this.val$location = uRI;
                            }

                            protected String getInitialLocationText() {
                                return URIUtil.toUnencodedString((URI)this.val$location);
                            }

                            protected String getInitialNameText() {
                                String nickname = null;
                                try {
                                    nickname = ProvisioningUtil.getMetadataRepositoryProperty(this.val$location, "p2.nickname");
                                }
                                catch (ProvisionException provisionException) {}
                                return nickname == null ? "" : nickname;
                            }
                        }).open()) == 0 && (correctedLocation = dialog.getLocation()) != null) {
                            ProvUI.startBatchOperation();
                            try {
                                RepositoryManipulator repoMan = repoManipulator;
                                if (repoManipulator == null) {
                                    repoMan = Policy.getDefault().getRepositoryManipulator();
                                }
                                RepositoryOperation op = repoMan.getRemoveOperation(new URI[]{location});
                                op.execute(null);
                                ProvUI.endBatchOperation(false);
                                op = repoMan.getAddOperation(correctedLocation);
                                op.execute(null);
                                String nickname = dialog.getName();
                                if (nickname != null && nickname.length() > 0) {
                                    ProvisioningUtil.setMetadataRepositoryProperty(correctedLocation, "p2.nickname", nickname);
                                }
                            }
                            catch (ProvisionException e) {
                                ProvUI.handleException(e, null, 3);
                                ProvUI.endBatchOperation(true);
                            }
                        }
                    }
                });
                reposNotFound.add(location);
            }
        } else {
            ProvUI.reportStatus(status, style);
        }
    }

    public static void notFoundStatusReported(URI location) {
        reposNotFound.add(location);
    }

    public static boolean hasNotFoundStatusBeenReported(URI location) {
        return reposNotFound.contains(location);
    }

    public static void clearRepositoriesNotFound() {
        reposNotFound.clear();
    }

    public static void clearRepositoryNotFound(URI location) {
        reposNotFound.remove(location);
    }

    public static void reportStatus(IStatus status, int style) {
        if ((style & 4) == 4 || (style & 2) == 2) {
            if (status.getSeverity() == 1) {
                MessageDialog.openInformation((Shell)ProvUI.getDefaultParentShell(), (String)ProvUIMessages.ProvUI_InformationTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
                if (status.getCode() == 10000) {
                    style = 0;
                }
            } else if (status.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)ProvUI.getDefaultParentShell(), (String)ProvUIMessages.ProvUI_WarningTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
            }
        }
        if (style != 0) {
            StatusManager.getManager().handle(status, style);
        }
    }

    public static IUColumnConfig[] getIUColumnConfig() {
        return iuColumnConfig;
    }

    public static void setIUColumnConfig(IUColumnConfig[] columnConfig) {
        iuColumnConfig = columnConfig;
    }

    public static Object getAdapter(Object object, Class adapterType) {
        if (object == null) {
            return null;
        }
        if (adapterType.isInstance(object)) {
            return object;
        }
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    public static Shell getDefaultParentShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = ProvUI.getDefaultParentShell(workbench.getDisplay().getShells());
        if (shell != null) {
            return shell;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    private static Shell getDefaultParentShell(Shell[] shells) {
        int i = shells.length - 1;
        while (i >= 0) {
            Shell shell = shells[i];
            Shell modalChild = ProvUI.getDefaultParentShell(shell.getShells());
            if (modalChild != null) {
                return modalChild;
            }
            if (shell.isVisible()) {
                int modal = 229376;
                if ((shell.getStyle() & modal) != 0) {
                    return shell;
                }
            }
            --i;
        }
        return null;
    }

    static IOperationApprover getOperationApprover() {
        return new IOperationApprover(){

            public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus[] status = new IStatus[]{Status.OK_STATUS};
                if (operation.hasContext((IUndoContext)provisioningUndoContext) && operation instanceof IAdvancedUndoableOperation) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(this, status, operation){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IStatus[] val$status;
                        private final /* synthetic */ IUndoableOperation val$operation;
                        {
                            this.this$1 = var1_1;
                            this.val$status = iStatusArray;
                            this.val$operation = iUndoableOperation;
                        }

                        public void run(IProgressMonitor monitor) {
                            try {
                                this.val$status[0] = ((IAdvancedUndoableOperation)this.val$operation).computeUndoableStatus(monitor);
                                if (!this.val$status[0].isOK()) {
                                    ProvUI.reportStatus(this.val$status[0], 3);
                                }
                            }
                            catch (ExecutionException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    };
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, runnable, status){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IRunnableWithProgress val$runnable;
                        private final /* synthetic */ IStatus[] val$status;
                        {
                            this.this$1 = var1_1;
                            this.val$runnable = iRunnableWithProgress;
                            this.val$status = iStatusArray;
                        }

                        public void run() {
                            try {
                                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, this.val$runnable);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    });
                }
                return status[0];
            }

            public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
                IStatus[] status = new IStatus[]{Status.OK_STATUS};
                if (operation.hasContext((IUndoContext)provisioningUndoContext) && operation instanceof IAdvancedUndoableOperation) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(this, status, operation){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IStatus[] val$status;
                        private final /* synthetic */ IUndoableOperation val$operation;
                        {
                            this.this$1 = var1_1;
                            this.val$status = iStatusArray;
                            this.val$operation = iUndoableOperation;
                        }

                        public void run(IProgressMonitor monitor) {
                            try {
                                this.val$status[0] = ((IAdvancedUndoableOperation)this.val$operation).computeRedoableStatus(monitor);
                                if (!this.val$status[0].isOK()) {
                                    ProvUI.reportStatus(this.val$status[0], 2);
                                }
                            }
                            catch (ExecutionException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    };
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this, runnable, status){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ IRunnableWithProgress val$runnable;
                        private final /* synthetic */ IStatus[] val$status;
                        {
                            this.this$1 = var1_1;
                            this.val$runnable = iRunnableWithProgress;
                            this.val$status = iStatusArray;
                        }

                        public void run() {
                            try {
                                new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, this.val$runnable);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException e) {
                                this.val$status[0] = new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e);
                                ProvUI.handleException(e.getCause(), null, 3);
                            }
                        }
                    });
                }
                return status[0];
            }
        };
    }

    public static void addProvisioningListener(ProvUIProvisioningListener listener) {
        ProvUIActivator.getDefault().addProvisioningListener(listener);
    }

    public static void removeProvisioningListener(ProvUIProvisioningListener listener) {
        ProvUIActivator.getDefault().removeProvisioningListener(listener);
    }

    public static void startBatchOperation() {
        ProvUIActivator.getDefault().signalBatchOperationStart();
    }

    public static void endBatchOperation(boolean notify) {
        ProvUIActivator.getDefault().signalBatchOperationComplete(notify);
    }

    public static void openUpdateManagerInstaller(Event event) {
        ProvUI.runCommand(UPDATE_MANAGER_FIND_AND_INSTALL, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenFindAndInstall, event);
    }

    public static void openUpdateManagerConfigurationManager(Event event) {
        ProvUI.runCommand(UPDATE_MANAGER_MANAGE_CONFIGURATION, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenManageConfiguration, event);
    }

    public static void openInstallationDialog(Event event) {
        ProvUI.runCommand(INSTALLATION_DIALOG, ProvUIMessages.ProvUI_InstallDialogError, event);
    }

    private static void runCommand(String commandId, String errorMessage, Event event) {
        ICommandService commandService;
        Command command;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(command = (commandService = (ICommandService)iWorkbench.getService((Class)clazz)).getCommand(commandId)).isDefined()) {
            return;
        }
        IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbench2.getService((Class)clazz2);
        try {
            handlerService.executeCommand(commandId, event);
        }
        catch (ExecutionException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotDefinedException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotEnabledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotHandledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
    }

    private static void reportFail(String message, Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", message, t);
        ProvUI.reportStatus((IStatus)failStatus, 5);
    }
}

