/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ResolutionResult;
import org.eclipse.equinox.internal.provisional.p2.ui.UpdateManagerCompatibility;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PlanAnalyzer {
    public static IStatus getStatus(int statusCode, IInstallableUnit affectedIU) {
        switch (statusCode) {
            case 10001: {
                return new MultiStatus("org.eclipse.equinox.p2.ui", statusCode, ProvUIMessages.PlanStatusHelper_RequestAltered, null);
            }
            case 10003: {
                return new Status(1, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_ImpliedUpdate, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10013: {
                return new Status(2, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanAnalyzer_LockedImpliedUpdate0, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10004: {
                return new Status(2, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_IgnoringImpliedDowngrade, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10005: {
                return new Status(2, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_AlreadyInstalled, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10006: {
                return new Status(1, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanAnalyzer_PartialInstall, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10007: {
                return new Status(1, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanAnalyzer_PartialUninstall, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10050: {
                return new Status(4, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_NothingToDo, (Object)PlanAnalyzer.getIUString(affectedIU)), null);
            }
            case 10000: {
                return new Status(1, "org.eclipse.equinox.p2.ui", statusCode, ProvUIMessages.UpdateOperation_NothingToUpdate, null);
            }
            case 10052: {
                return new Status(4, "org.eclipse.equinox.p2.ui", statusCode, ProvUIMessages.PlanStatusHelper_AnotherOperationInProgress, null);
            }
        }
        return new Status(4, "org.eclipse.equinox.p2.ui", statusCode, NLS.bind((String)ProvUIMessages.PlanStatusHelper_UnexpectedError, (Object)new Integer(statusCode), (Object)PlanAnalyzer.getIUString(affectedIU)), null);
    }

    public static MultiStatus getProfileChangeAlteredStatus() {
        return (MultiStatus)PlanAnalyzer.getStatus(10001, null);
    }

    public static ResolutionResult computeResolutionResult(ProfileChangeRequest originalRequest, ProvisioningPlan plan, MultiStatus originalStatus) {
        RequestStatus rs;
        Assert.isNotNull((Object)originalRequest);
        Assert.isNotNull((Object)plan);
        Assert.isNotNull((Object)originalStatus);
        ResolutionResult report = new ResolutionResult();
        if (plan.getStatus().getSeverity() == 8) {
            report.addSummaryStatus(plan.getStatus());
            return report;
        }
        if (UpdateManagerCompatibility.requiresInstallHandlerSupport(plan)) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    MessageDialog dialog = new MessageDialog(shell, ProvUIMessages.PlanStatusHelper_UpdateManagerPromptTitle, null, ProvUIMessages.PlanStatusHelper_PromptForUpdateManagerUI, 4, new String[]{ProvUIMessages.PlanStatusHelper_Launch, IDialogConstants.CANCEL_LABEL}, 0);
                    if (dialog.open() == 0) {
                        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                UpdateManagerCompatibility.openInstaller();
                            }
                        });
                    }
                }
            });
            report.addSummaryStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.PlanStatusHelper_RequiresUpdateManager));
        }
        if (PlanAnalyzer.nothingToDo(originalRequest)) {
            report.addSummaryStatus(PlanAnalyzer.getStatus(10050, null));
            IStatus[] details = originalStatus.getChildren();
            int i = 0;
            while (i < details.length) {
                report.addSummaryStatus(details[i]);
                ++i;
            }
            return report;
        }
        if (originalStatus != null && originalStatus.getChildren().length > 0) {
            report.addSummaryStatus((IStatus)originalStatus);
        }
        if (!plan.getStatus().isOK()) {
            report.addSummaryStatus(plan.getStatus());
        }
        if (plan.getStatus().getSeverity() != 4) {
            IInstallableUnit[] iusAdded = originalRequest.getAddedInstallableUnits();
            int i = 0;
            while (i < iusAdded.length) {
                RequestStatus rs2 = plan.getRequestStatus(iusAdded[i]);
                if (rs2.getSeverity() == 4) {
                    Status fail = new Status(4, "org.eclipse.equinox.p2.ui", 10011, NLS.bind((String)ProvUIMessages.PlanAnalyzer_IgnoringInstall, (Object)PlanAnalyzer.getIUString(iusAdded[i])), null);
                    report.addStatus(iusAdded[i], (IStatus)fail);
                    report.addSummaryStatus((IStatus)fail);
                }
                ++i;
            }
            IInstallableUnit[] iusRemoved = originalRequest.getRemovedInstallableUnits();
            int i2 = 0;
            while (i2 < iusRemoved.length) {
                rs = plan.getRequestStatus(iusRemoved[i2]);
                if (rs.getSeverity() == 4) {
                    Status fail = new Status(1, "org.eclipse.equinox.p2.ui", 10007, NLS.bind((String)ProvUIMessages.PlanAnalyzer_PartialUninstall, (Object)PlanAnalyzer.getIUString(iusRemoved[i2])), null);
                    report.addStatus(iusRemoved[i2], (IStatus)fail);
                    report.addSummaryStatus((IStatus)fail);
                }
                ++i2;
            }
        }
        Map sideEffects = plan.getSideEffectChanges();
        Iterator iusWithSideEffects = sideEffects.keySet().iterator();
        while (iusWithSideEffects.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iusWithSideEffects.next();
            rs = (RequestStatus)sideEffects.get(iu);
            if (rs.getInitialRequestType() == 0) {
                report.addStatus(iu, (IStatus)new Status(rs.getSeverity(), "org.eclipse.equinox.p2.ui", 10010, NLS.bind((String)ProvUIMessages.PlanAnalyzer_SideEffectInstall, (Object)PlanAnalyzer.getIUString(iu)), null));
                continue;
            }
            report.addStatus(iu, (IStatus)new Status(rs.getSeverity(), "org.eclipse.equinox.p2.ui", 10009, NLS.bind((String)ProvUIMessages.PlanAnalyzer_SideEffectUninstall, (Object)PlanAnalyzer.getIUString(iu)), null));
        }
        return report;
    }

    private static String getIUString(IInstallableUnit iu) {
        if (iu == null) {
            return ProvUIMessages.PlanStatusHelper_Items;
        }
        String name = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
        if (name != null) {
            return name;
        }
        return iu.getId();
    }

    private static boolean nothingToDo(ProfileChangeRequest request) {
        return request.getAddedInstallableUnits().length == 0 && request.getRemovedInstallableUnits().length == 0 && request.getInstallableUnitProfilePropertiesToAdd().size() == 0 && request.getInstallableUnitProfilePropertiesToRemove().size() == 0;
    }
}

