/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.parameters.PortParameter;
import ptolemy.actor.util.ActorTypeUtil;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.Typeable;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class SequenceToArray
extends SDFTransformer {
    public PortParameter arrayLength;

    public SequenceToArray(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input_tokenConsumptionRate.setExpression("arrayLength");
        this.output.setMultiport(true);
        this.arrayLength = new PortParameter((NamedObj)this, "arrayLength");
        this.arrayLength.setExpression("1");
        this.output.setTypeAtLeast(ActorTypeUtil.arrayOf((Typeable)this.input, (Variable)this.arrayLength));
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.arrayLength) {
            int rate = ((IntToken)this.arrayLength.getToken()).intValue();
            if (rate < 0) {
                throw new IllegalActionException((Nameable)this, "Invalid arrayLength: " + rate);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SequenceToArray newObject = (SequenceToArray)((Object)super.clone(workspace));
        try {
            newObject.output.setTypeAtLeast(ActorTypeUtil.arrayOf((Typeable)newObject.input, (Variable)newObject.arrayLength));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.arrayLength.update();
        int length = ((IntToken)this.arrayLength.getToken()).intValue();
        Token[] valueArray = new Token[length];
        System.arraycopy(this.input.get(0, length), 0, valueArray, 0, length);
        this.output.broadcast((Token)new ArrayToken(this.input.getType(), valueArray));
    }

    public boolean prefire() throws IllegalActionException {
        int length = ((IntToken)this.arrayLength.getToken()).intValue();
        if (!this.input.hasToken(0, length)) {
            if (this._debugging) {
                this._debug("Called prefire(), which returns false.");
            }
            return false;
        }
        return super.prefire();
    }
}

