/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class FIR
extends SDFTransformer {
    public Parameter decimation = new Parameter((NamedObj)this, "decimation");
    public Parameter decimationPhase;
    public Parameter interpolation;
    public Parameter taps;
    protected Token[] _data;
    protected int _mostRecent;
    protected int _phaseLength;
    protected int _decimationValue = 1;
    protected int _interpolationValue = 1;
    protected int _decimationPhaseValue = 0;
    protected boolean _reinitializeNeeded = true;
    protected Token[] _taps;
    protected Token _zero;
    private Token _outToken;
    private Token _tapItem;
    private Token _dataItem;

    public FIR(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.decimation.setExpression("1");
        this.decimation.setTypeEquals((Type)BaseType.INT);
        this.decimationPhase = new Parameter((NamedObj)this, "decimationPhase");
        this.decimationPhase.setExpression("0");
        this.decimationPhase.setTypeEquals((Type)BaseType.INT);
        this.interpolation = new Parameter((NamedObj)this, "interpolation");
        this.interpolation.setExpression("1");
        this.interpolation.setTypeEquals((Type)BaseType.INT);
        this.taps = new Parameter((NamedObj)this, "taps");
        this.taps.setExpression("{1.0}");
        this.taps.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.input_tokenConsumptionRate.setExpression("decimation");
        this.output_tokenProductionRate.setExpression("interpolation");
        this._initTypeConstraints();
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.interpolation) {
            IntToken token = (IntToken)this.interpolation.getToken();
            this._interpolationValue = token.intValue();
            if (this._interpolationValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid interpolation: " + this._interpolationValue + ". Must be positive.");
            }
            this._reinitializeNeeded = true;
        } else if (attribute == this.decimation) {
            IntToken token = (IntToken)this.decimation.getToken();
            this._decimationValue = token.intValue();
            if (this._decimationValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid decimation: " + this._decimationValue + ". Must be positive.");
            }
            this._reinitializeNeeded = true;
        } else if (attribute == this.decimationPhase) {
            IntToken token = (IntToken)this.decimationPhase.getToken();
            this._decimationPhaseValue = token.intValue();
            if (this._decimationPhaseValue < 0) {
                throw new IllegalActionException((Nameable)this, "Invalid decimationPhase: " + this._decimationPhaseValue + ". Must be nonnegative.");
            }
            this._reinitializeNeeded = true;
        } else if (attribute == this.taps) {
            ArrayToken tapsToken = (ArrayToken)this.taps.getToken();
            this._taps = tapsToken.arrayValue();
            this._zero = this._taps[0].zero();
            this._reinitializeNeeded = true;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FIR newObject = (FIR)((Object)super.clone(workspace));
        newObject.taps.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newObject._initTypeConstraints();
        return newObject;
    }

    /*
     * Unable to fully structure code
     */
    public void fire() throws IllegalActionException {
        super.fire();
        phase = this._decimationValue - this._decimationPhaseValue - 1;
        inC = 1;
        while (inC <= this._decimationValue) {
            if (--this._mostRecent < 0) {
                this._mostRecent = this._data.length - 1;
            }
            this._data[this._mostRecent] = this.input.get(0);
            ++inC;
        }
        inC = 1;
        ** GOTO lbl30
        {
            this._outToken = this._zero;
            i = 0;
            while (i < this._phaseLength) {
                tapsIndex = i * this._interpolationValue + phase;
                dataIndex = (this._mostRecent + this._decimationValue - inC + i) % this._data.length;
                if (tapsIndex < this._taps.length) {
                    this._tapItem = this._taps[tapsIndex];
                    this._dataItem = this._data[dataIndex];
                    this._dataItem = this._tapItem.multiply(this._dataItem);
                    this._outToken = this._outToken.add(this._dataItem);
                }
                ++i;
            }
            this.output.send(0, this._outToken);
            phase += this._decimationValue;
            do {
                if (phase < this._interpolationValue) continue block1;
                phase -= this._interpolationValue;
                ++inC;
lbl30:
                // 2 sources

            } while (inC <= this._decimationValue);
        }
    }

    public boolean prefire() throws IllegalActionException {
        if (this._reinitializeNeeded) {
            this._reinitialize();
        }
        if (this.input.hasToken(0, this._decimationValue)) {
            return super.prefire();
        }
        if (this._debugging) {
            this._debug("Called prefire(), which returns false.");
        }
        return false;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._data = null;
        this._reinitializeNeeded = true;
    }

    protected void _initTypeConstraints() {
        this.output.setTypeAtLeast((InequalityTerm)new OutputTypeFunction());
    }

    protected void _reinitialize() throws IllegalActionException {
        if (this._decimationPhaseValue >= this._decimationValue) {
            throw new IllegalActionException((Nameable)this, "Invalid decimationPhase: " + this._decimationPhaseValue + ". Must be less than decimation: " + this._decimationValue + ".");
        }
        this._phaseLength = this._taps.length / this._interpolationValue;
        if (this._taps.length % this._interpolationValue != 0) {
            ++this._phaseLength;
        }
        int length = this._phaseLength + this._decimationValue;
        if (this._data == null) {
            this._data = new Token[length];
            int i = 0;
            while (i < length) {
                this._data[i] = this._zero;
                ++i;
            }
            this._mostRecent = this._phaseLength;
        } else if (this._data.length != length) {
            Token[] _oldData = this._data;
            this._data = new Token[length];
            int i = 0;
            while (i < length) {
                this._data[i] = i < _oldData.length ? _oldData[i] : this._zero;
                ++i;
            }
            this._mostRecent = this._phaseLength;
        }
        this._reinitializeNeeded = false;
    }

    private class OutputTypeFunction
    extends MonotonicFunction {
        private OutputTypeFunction() {
        }

        public Object getValue() {
            Type productType;
            Type inputType = FIR.this.input.getType();
            BaseType.UnknownType tapsElementType = BaseType.UNKNOWN;
            if (FIR.this.taps.getType() != BaseType.UNKNOWN) {
                tapsElementType = ((ArrayType)FIR.this.taps.getType()).getElementType();
            }
            Type outputType = productType = inputType.multiply((Type)tapsElementType);
            int phaseLength = FIR.this._taps.length / FIR.this._interpolationValue;
            if (FIR.this._taps.length % FIR.this._interpolationValue != 0) {
                ++phaseLength;
            }
            int i = 0;
            while (i < phaseLength) {
                outputType = outputType.add(productType);
                ++i;
            }
            return outputType;
        }

        public InequalityTerm[] getVariables() {
            try {
                InequalityTerm elementTerm = ArrayType.elementType((Typeable)FIR.this.taps);
                if (FIR.this.input.getTypeTerm().isSettable() && elementTerm.isSettable()) {
                    InequalityTerm[] variable = new InequalityTerm[]{FIR.this.input.getTypeTerm(), elementTerm};
                    return variable;
                }
                if (elementTerm.isSettable()) {
                    InequalityTerm[] variable = new InequalityTerm[]{elementTerm};
                    return variable;
                }
                if (FIR.this.input.getTypeTerm().isSettable()) {
                    InequalityTerm[] variable = new InequalityTerm[]{FIR.this.input.getTypeTerm()};
                    return variable;
                }
                return new InequalityTerm[0];
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
    }
}

