/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.ComplexToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.Complex;
import ptolemy.math.SignalProcessing;

public class FFT
extends SDFTransformer {
    public Parameter order;
    private int _transformSize;
    private int _orderValue;
    private Complex[] _inComplexArray;
    private ComplexToken[] _outTokenArray;

    public FFT(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.COMPLEX);
        this.output.setTypeEquals((Type)BaseType.COMPLEX);
        this.order = new Parameter((NamedObj)this, "order");
        this.order.setExpression("8");
        this.order.setTypeEquals((Type)BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("2^order");
        this.output_tokenProductionRate.setExpression("2^order");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.order) {
            this._orderValue = ((IntToken)this.order.getToken()).intValue();
            if (this._orderValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Order was " + this._orderValue + " but must be greater than zero.");
            }
            this._transformSize = (int)Math.pow(2.0, this._orderValue);
            this._inComplexArray = new Complex[this._transformSize];
            this._outTokenArray = new ComplexToken[this._transformSize];
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        Token[] inTokenArray = this.input.get(0, this._transformSize);
        int i = 0;
        while (i < this._transformSize) {
            this._inComplexArray[i] = ((ComplexToken)inTokenArray[i]).complexValue();
            ++i;
        }
        Complex[] outComplexArray = SignalProcessing.FFTComplexOut((Complex[])this._inComplexArray, (int)this._orderValue);
        int i2 = 0;
        while (i2 < this._transformSize) {
            this._outTokenArray[i2] = new ComplexToken(outComplexArray[i2]);
            ++i2;
        }
        this.output.send(0, (Token[])this._outTokenArray, this._transformSize);
    }
}

