/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import java.util.List;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class ArrayToSequence
extends SDFTransformer {
    public Parameter arrayLength;
    public Parameter enforceArrayLength;

    public ArrayToSequence(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(ArrayType.elementType((Typeable)this.input));
        this.arrayLength = new Parameter((NamedObj)this, "arrayLength");
        this.arrayLength.setExpression("1");
        this.enforceArrayLength = new Parameter((NamedObj)this, "enforceArrayLength");
        this.enforceArrayLength.setExpression("true");
        this.enforceArrayLength.setTypeEquals((Type)BaseType.BOOLEAN);
        this.output_tokenProductionRate.setExpression("arrayLength");
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.arrayLength) {
            int rate = ((IntToken)this.arrayLength.getToken()).intValue();
            if (rate < 0) {
                throw new IllegalActionException((Nameable)this, "Invalid arrayLength: " + rate);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ArrayToSequence newObject = (ArrayToSequence)((Object)super.clone(workspace));
        try {
            newObject.output.setTypeAtLeast(ArrayType.elementType((Typeable)newObject.input));
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken token = (ArrayToken)this.input.get(0);
        int rate = ((IntToken)this.arrayLength.getToken()).intValue();
        boolean enforce = ((BooleanToken)this.enforceArrayLength.getToken()).booleanValue();
        if (enforce && token.length() != rate) {
            throw new IllegalActionException((Nameable)this, "The number of elements in the input ArrayToken (" + token.length() + ") is not the same as the arrayLength " + "parameter (" + rate + ").");
        }
        Token[] elements = token.arrayValue();
        this.output.send(0, elements, elements.length);
    }

    public List typeConstraintList() {
        return this.output.typeConstraintList();
    }
}

