/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.ScheduleElement;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.ConstVariableModelAnalysis;
import ptolemy.actor.util.DFUtilities;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.kernel.BaseSDFScheduler;
import ptolemy.domains.sdf.kernel.SDFDirector;
import ptolemy.domains.sdf.kernel.SDFReceiver;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.Fraction;

public class SDFScheduler
extends BaseSDFScheduler
implements ValueListener {
    public Parameter constrainBufferSizes;
    protected Map _firingVector = new HashMap();
    private Fraction _minusOne = new Fraction(-1);
    protected Map _externalRates = new HashMap();
    protected List _rateVariables = new LinkedList();

    public SDFScheduler() {
        this._init();
    }

    public SDFScheduler(Workspace workspace) {
        super(workspace);
        this._init();
    }

    public SDFScheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SDFScheduler newObject = (SDFScheduler)((Object)super.clone(workspace));
        newObject._firingVector = new HashMap();
        newObject._externalRates = new HashMap();
        newObject._rateVariables = new LinkedList();
        return newObject;
    }

    public void declareRateDependency() throws IllegalActionException {
        ConstVariableModelAnalysis analysis = ConstVariableModelAnalysis.getAnalysis((NamedObj)this);
        SDFDirector director = (SDFDirector)this.getContainer();
        CompositeActor model = (CompositeActor)director.getContainer();
        for (IOPort port : model.portList()) {
            if (port instanceof ParameterPort) continue;
            if (port.isInput()) {
                this._declareDependency(analysis, (Port)port, "tokenConsumptionRate", this._rateVariables);
            }
            if (!port.isOutput()) continue;
            this._declareDependency(analysis, (Port)port, "tokenProductionRate", this._rateVariables);
            this._declareDependency(analysis, (Port)port, "tokenInitProduction", this._rateVariables);
        }
    }

    public Map getExternalRates() {
        return this._externalRates;
    }

    public int getFiringCount(Entity entity) throws IllegalActionException {
        this.getSchedule();
        return this._getFiringCount(entity);
    }

    public void valueChanged(Settable settable) {
        this.setValid(false);
    }

    protected void _checkDynamicRateVariables(CompositeActor model, List rateVariables) throws IllegalActionException {
        ConstVariableModelAnalysis analysis = ConstVariableModelAnalysis.getAnalysis((NamedObj)this.getContainer());
        LinkedList oldList = new LinkedList();
        oldList.addAll(rateVariables);
        LinkedList<Variable> newList = new LinkedList<Variable>();
        for (Entity entity : model.deepEntityList()) {
            for (Port port : entity.portList()) {
                Set set = analysis.getNotConstVariables((NamedObj)port);
                Variable variable = DFUtilities.getRateVariable((Port)port, (String)"tokenInitProduction");
                this._listenToRateVariable(variable, rateVariables);
                newList.add(variable);
                if (set.contains(variable)) {
                    this._assertDynamicRateVariable(model, variable, rateVariables, analysis);
                }
                variable = DFUtilities.getRateVariable((Port)port, (String)"tokenConsumptionRate");
                this._listenToRateVariable(variable, rateVariables);
                newList.add(variable);
                if (set.contains(variable)) {
                    this._assertDynamicRateVariable(model, variable, rateVariables, analysis);
                }
                variable = DFUtilities.getRateVariable((Port)port, (String)"tokenProductionRate");
                this._listenToRateVariable(variable, rateVariables);
                newList.add(variable);
                if (!set.contains(variable)) continue;
                this._assertDynamicRateVariable(model, variable, rateVariables, analysis);
            }
        }
        oldList.removeAll(newList);
        for (Variable variable : oldList) {
            if (this._debugging) {
                this._debug("No longer listening to rate variable " + variable);
            }
            variable.removeValueListener((ValueListener)this);
            rateVariables.remove(variable);
        }
    }

    protected int _computeMaximumFirings(Actor currentActor) throws IllegalActionException {
        int result = Integer.MAX_VALUE;
        for (IOPort inputPort : currentActor.inputPortList()) {
            int tokenRate = DFUtilities.getTokenConsumptionRate((IOPort)inputPort);
            if (tokenRate == 0) continue;
            Receiver[][] receivers = inputPort.getReceivers();
            int channel = 0;
            while (channel < receivers.length) {
                if (receivers[channel] != null) {
                    int copy = 0;
                    while (copy < receivers[channel].length) {
                        if (receivers[channel][copy] instanceof SDFReceiver) {
                            SDFReceiver receiver = (SDFReceiver)receivers[channel][copy];
                            int firings = receiver._waitingTokens / tokenRate;
                            if (firings < result) {
                                result = firings;
                            }
                        }
                        ++copy;
                    }
                }
                ++channel;
            }
        }
        return result;
    }

    protected int _countUnfulfilledInputs(Actor actor, List actorList, boolean resetCapacity) throws IllegalActionException {
        int count = 0;
        for (IOPort inputPort : actor.inputPortList()) {
            int threshold = DFUtilities.getTokenConsumptionRate((IOPort)inputPort);
            Receiver[][] receivers = inputPort.getReceivers();
            boolean isFulfilled = true;
            int channel = 0;
            while (channel < receivers.length) {
                if (receivers[channel] != null) {
                    int copy = 0;
                    while (copy < receivers[channel].length) {
                        if (receivers[channel][copy] instanceof SDFReceiver) {
                            SDFReceiver receiver = (SDFReceiver)receivers[channel][copy];
                            if (resetCapacity) {
                                receiver.setCapacity(-1);
                            }
                            if (receiver._waitingTokens < threshold) {
                                isFulfilled = false;
                                if (!resetCapacity) break;
                            }
                        }
                        ++copy;
                    }
                    if (!isFulfilled) break;
                }
                ++channel;
            }
            if (isFulfilled) continue;
            ++count;
        }
        return count;
    }

    protected int _getFiringCount(Entity entity) {
        return (Integer)this._firingVector.get(entity);
    }

    protected Schedule _getSchedule() throws NotSchedulableException, IllegalActionException {
        SDFDirector director = (SDFDirector)this.getContainer();
        CompositeActor model = (CompositeActor)director.getContainer();
        this._checkDynamicRateVariables(model, this._rateVariables);
        int vectorizationFactor = 1;
        Token token = director.vectorizationFactor.getToken();
        vectorizationFactor = ((IntToken)token).intValue();
        if (vectorizationFactor < 1) {
            throw new NotSchedulableException((Nameable)this, "The supplied vectorizationFactor must be a positive integer. The given value was: " + vectorizationFactor);
        }
        CompositeActor container = (CompositeActor)director.getContainer();
        List allActorList = container.deepEntityList();
        HashMap<IOPort, Fraction> externalRates = new HashMap<IOPort, Fraction>();
        for (IOPort port : container.portList()) {
            externalRates.put(port, Fraction.ZERO);
        }
        Map entityToFiringsPerIteration = this._solveBalanceEquations(container, allActorList, externalRates);
        this._vectorizeFirings(vectorizationFactor, entityToFiringsPerIteration, externalRates);
        this._firingVector = entityToFiringsPerIteration;
        if (this._debugging) {
            this._debug("Normalized Firing Counts:");
            this._debug(entityToFiringsPerIteration.toString());
        }
        Schedule result = this._scheduleConnectedActors(externalRates, allActorList, container);
        this._saveFiringCounts(entityToFiringsPerIteration);
        this._saveContainerRates(externalRates);
        this.setValid(true);
        this._externalRates = externalRates;
        return result;
    }

    protected Map _solveBalanceEquations(CompositeActor container, List actorList, Map externalRates) throws NotSchedulableException, IllegalActionException {
        HashMap<Object, Fraction> entityToFiringsPerIteration = new HashMap<Object, Fraction>();
        if (actorList.size() == 0) {
            this._checkDirectInputOutputConnection(container, externalRates);
            return entityToFiringsPerIteration;
        }
        LinkedList<ComponentEntity> pendingActors = new LinkedList<ComponentEntity>();
        HashSet<ComponentEntity> clusteredActors = new HashSet<ComponentEntity>();
        HashSet clusteredExternalPorts = new HashSet();
        LinkedList remainingActors = new LinkedList();
        remainingActors.addAll(actorList);
        for (ComponentEntity entity : remainingActors) {
            entityToFiringsPerIteration.put(entity, this._minusOne);
        }
        StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
        boolean allowDisconnectedGraphs = false;
        if (director instanceof SDFDirector) {
            allowDisconnectedGraphs = ((SDFDirector)director)._allowDisconnectedGraphs;
        }
        while (!remainingActors.isEmpty()) {
            clusteredActors.clear();
            clusteredExternalPorts.clear();
            ComponentEntity actor = this._pickZeroRatePortActor(remainingActors);
            if (actor == null) {
                actor = (ComponentEntity)remainingActors.removeFirst();
            } else {
                remainingActors.remove(actor);
            }
            clusteredActors.add(actor);
            entityToFiringsPerIteration.put(actor, new Fraction(1));
            pendingActors.addLast(actor);
            while (!pendingActors.isEmpty()) {
                Actor currentActor = (Actor)pendingActors.removeFirst();
                for (IOPort iOPort : ((ComponentEntity)currentActor).portList()) {
                    this._propagatePort(container, iOPort, entityToFiringsPerIteration, externalRates, remainingActors, pendingActors, clusteredActors, clusteredExternalPorts);
                }
            }
            int lcm = 1;
            for (Actor actor2 : clusteredActors) {
                Fraction fraction = (Fraction)entityToFiringsPerIteration.get(actor2);
                int denominator = fraction.getDenominator();
                lcm = Fraction.lcm((int)lcm, (int)denominator);
            }
            Fraction lcmFraction = new Fraction(lcm);
            for (Actor actor3 : clusteredActors) {
                Fraction repetitions = ((Fraction)entityToFiringsPerIteration.get(actor3)).multiply(lcmFraction);
                if (repetitions.getDenominator() != 1) {
                    throw new InternalErrorException("Failed to properly perform fraction normalization.");
                }
                entityToFiringsPerIteration.put(actor3, repetitions);
            }
            for (IOPort iOPort : clusteredExternalPorts) {
                Fraction rate = ((Fraction)externalRates.get(iOPort)).multiply(lcmFraction);
                if (rate.getDenominator() != 1) {
                    throw new InternalErrorException("Failed to properly perform fraction normalization.");
                }
                externalRates.put(iOPort, rate);
            }
            clusteredActors.clear();
            clusteredExternalPorts.clear();
            if (!allowDisconnectedGraphs) break;
        }
        this._checkDirectInputOutputConnection(container, externalRates);
        if (!remainingActors.isEmpty()) {
            StringBuffer messageBuffer = new StringBuffer("SDF scheduler found disconnected actors! Usually, disconnected actors in an SDF model indicates an error.  If this is not an error, try setting the SDFDirector parameter allowDisconnectedGraphs to true.\nUnreached Actors:\n");
            int count = 0;
            Iterator unreachedActors = remainingActors.iterator();
            while (unreachedActors.hasNext() && count < 100) {
                NamedObj namedObj = (NamedObj)unreachedActors.next();
                messageBuffer.append(String.valueOf(namedObj.getFullName()) + " ");
                ++count;
            }
            if (count >= 99) {
                messageBuffer.append("...");
            }
            messageBuffer.append("\nReached Actors:\n");
            LinkedList reachedActorList = new LinkedList();
            reachedActorList.addAll(actorList);
            reachedActorList.removeAll(remainingActors);
            count = 0;
            Iterator iterator = reachedActorList.iterator();
            while (iterator.hasNext() && count < 100) {
                Entity entity = (Entity)iterator.next();
                messageBuffer.append(String.valueOf(entity.getFullName()) + " ");
                ++count;
            }
            if (count >= 99) {
                messageBuffer.append("...");
            }
            throw new NotSchedulableException(messageBuffer.toString());
        }
        return entityToFiringsPerIteration;
    }

    protected void _vectorizeFirings(int vectorizationFactor, Map entityToFiringsPerIteration, Map externalRates) {
        Fraction lcmFraction = new Fraction(vectorizationFactor);
        for (Map.Entry entry : entityToFiringsPerIteration.entrySet()) {
            Fraction repetitions = (Fraction)entry.getValue();
            repetitions = repetitions.multiply(lcmFraction);
            entry.setValue(repetitions.getNumerator());
        }
        for (Map.Entry entry : externalRates.entrySet()) {
            Fraction rate = (Fraction)entry.getValue();
            rate = rate.multiply(lcmFraction);
            entry.setValue(rate.getNumerator());
        }
    }

    private void _assertDynamicRateVariable(CompositeActor model, Variable variable, List rateVariables, ConstVariableModelAnalysis analysis) throws IllegalActionException {
        boolean allowRateChanges = ((BooleanToken)((SDFDirector)this.getContainer()).allowRateChanges.getToken()).booleanValue();
        if (!allowRateChanges) {
            throw new IllegalActionException((Nameable)variable, "The SDF rate parameter may change. This is not allowed in SDF models that will be run through the code generator.  If you don't care about code generation, then you might consider setting the allowRateChanges parameter of the SDF director to false.");
        }
        Entity changeContext = analysis.getChangeContext(variable);
        if (changeContext != model && !changeContext.deepContains((NamedObj)model)) {
            throw new IllegalActionException((Nameable)variable, "The SDF rate parameter changes during execution of the schedule!");
        }
    }

    private void _checkDirectInputOutputConnection(CompositeActor container, Map externalRates) {
        for (IOPort inputPort : container.inputPortList()) {
            Fraction rate = (Fraction)externalRates.get(inputPort);
            if (!rate.equals((Object)Fraction.ZERO)) continue;
            for (IOPort connectedPort : inputPort.deepInsidePortList()) {
                if (connectedPort.isOutput() && connectedPort.getContainer() != container) {
                    throw new NotSchedulableException((Nameable)inputPort, (Nameable)connectedPort, "External input port drive the same relation as an output port. This is not legal in SDF.");
                }
                if (!connectedPort.isInput() || connectedPort.getContainer() != container) continue;
                throw new NotSchedulableException((Nameable)inputPort, (Nameable)connectedPort, "External input port drives the same relation as another external input port. This is not legal in SDF.");
            }
            boolean isDirectionConnection = true;
            List insideSinkPorts = inputPort.insideSinkPortList();
            if (insideSinkPorts.isEmpty()) {
                isDirectionConnection = false;
            } else {
                for (IOPort sinkPort : insideSinkPorts) {
                    if (sinkPort.getContainer() == container) continue;
                    isDirectionConnection = false;
                    break;
                }
            }
            if (!isDirectionConnection) continue;
            externalRates.put(inputPort, new Fraction(1));
            for (IOPort sinkPort : insideSinkPorts) {
                externalRates.put(sinkPort, new Fraction(1));
            }
        }
    }

    private void _init() {
        try {
            this.constrainBufferSizes = new Parameter((NamedObj)this, "constrainBufferSizes");
            this.constrainBufferSizes.setTypeEquals((Type)BaseType.BOOLEAN);
            this.constrainBufferSizes.setExpression("true");
        }
        catch (KernelException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void _listenToRateVariable(Variable variable, List rateVariables) {
        if (variable != null && !rateVariables.contains(variable)) {
            if (this._debugging) {
                this._debug("Listening to rate variable " + variable);
            }
            variable.addValueListener((ValueListener)this);
            rateVariables.add(variable);
        }
    }

    private ComponentEntity _pickZeroRatePortActor(List actorList) throws IllegalActionException {
        for (ComponentEntity actor : actorList) {
            for (IOPort port : actor.portList()) {
                if (DFUtilities.getRate((IOPort)port) != 0) continue;
                return actor;
            }
        }
        return null;
    }

    private void _propagatePort(CompositeActor container, IOPort currentPort, Map entityToFiringsPerIteration, Map externalRates, LinkedList remainingActors, LinkedList pendingActors, Set clusteredActors, Set clusteredExternalPorts) throws NotSchedulableException, IllegalActionException {
        Director director;
        CompositeActor model;
        int currentRate;
        ComponentEntity currentActor = (ComponentEntity)currentPort.getContainer();
        if (currentPort.isOutput() && currentPort.getContainer() != container) {
            for (IOPort connectedPort : currentPort.deepConnectedPortList()) {
                if (connectedPort.isOutput() && connectedPort.getContainer() != container) {
                    throw new NotSchedulableException((Nameable)currentPort, (Nameable)connectedPort, "Output ports drive the same relation. This is not legal in SDF.");
                }
                if (!connectedPort.isInput() || connectedPort.getContainer() != container) continue;
                throw new NotSchedulableException((Nameable)currentPort, (Nameable)connectedPort, "Output port drives the same relation as the external input port. This is not legal in SDF.");
            }
        }
        if (currentPort.isInput() && currentPort.getContainer() == container) {
            for (IOPort connectedPort : currentPort.deepInsidePortList()) {
                if (connectedPort.isOutput() && connectedPort.getContainer() != container) {
                    throw new NotSchedulableException((Nameable)currentPort, (Nameable)connectedPort, "External input port drive the same relation as an output port. This is not legal in SDF.");
                }
                if (!connectedPort.isInput() || connectedPort.getContainer() != container) continue;
                throw new NotSchedulableException((Nameable)currentPort, (Nameable)connectedPort, "External input port drives the same relation as another external input port. This is not legal in SDF.");
            }
        }
        if ((currentRate = currentActor == (model = (CompositeActor)(director = (Director)this.getContainer()).getContainer()) ? 1 : DFUtilities.getRate((IOPort)currentPort)) < 0) {
            throw new NotSchedulableException((Nameable)currentPort, "Rate cannot be less than zero.  It was: " + currentRate);
        }
        Iterator connectedPorts = currentPort.getContainer() == container ? currentPort.deepInsidePortList().iterator() : currentPort.deepConnectedPortList().iterator();
        while (connectedPorts.hasNext()) {
            Fraction desiredFiring;
            IOPort connectedPort = (IOPort)connectedPorts.next();
            ComponentEntity connectedActor = (ComponentEntity)connectedPort.getContainer();
            int connectedRate = connectedActor == model ? 1 : DFUtilities.getRate((IOPort)connectedPort);
            Fraction currentFiring = (Fraction)entityToFiringsPerIteration.get(currentActor);
            if (currentRate == 0 && connectedRate > 0) {
                desiredFiring = Fraction.ZERO;
            } else if (currentRate > 0 && connectedRate == 0) {
                currentFiring = Fraction.ZERO;
                entityToFiringsPerIteration.put(currentActor, currentFiring);
                desiredFiring = new Fraction(1);
            } else {
                desiredFiring = currentRate == 0 && connectedRate == 0 ? currentFiring : currentFiring.multiply(new Fraction(currentRate, connectedRate));
            }
            Fraction presentFiring = (Fraction)entityToFiringsPerIteration.get(connectedActor);
            if (connectedActor == model || presentFiring == null) {
                entityToFiringsPerIteration.put(connectedActor, desiredFiring);
                Fraction rate = currentFiring.multiply(new Fraction(currentRate, 1));
                Fraction previousRate = (Fraction)externalRates.get(connectedPort);
                if (previousRate == null) {
                    throw new InternalErrorException("Invalid connection found between ports: " + currentPort.getFullName() + " and " + connectedPort.getFullName());
                }
                if (!clusteredExternalPorts.contains(connectedPort)) {
                    clusteredExternalPorts.add(connectedPort);
                    externalRates.put(connectedPort, rate);
                    this._propagatePort(container, connectedPort, entityToFiringsPerIteration, externalRates, remainingActors, pendingActors, clusteredActors, clusteredExternalPorts);
                    continue;
                }
                if (rate.equals((Object)previousRate)) continue;
                throw new NotSchedulableException("No solution exists for the balance equations.\nGraph is not consistent under the SDF domain detected on external port " + connectedPort.getFullName());
            }
            if (presentFiring.equals((Object)this._minusOne)) {
                entityToFiringsPerIteration.put(connectedActor, desiredFiring);
                remainingActors.remove(connectedActor);
                clusteredActors.add(connectedActor);
                pendingActors.addLast(connectedActor);
                continue;
            }
            if (presentFiring.equals((Object)desiredFiring)) continue;
            throw new NotSchedulableException((Nameable)this, "No solution exists for the balance equations.\nGraph is not consistent under the SDF domain detected on external port " + connectedPort.getFullName());
        }
    }

    private Schedule _scheduleConnectedActors(Map externalRates, List actorList, CompositeActor container) throws NotSchedulableException {
        LinkedList<Actor> readyToScheduleActorList = new LinkedList<Actor>();
        Schedule newSchedule = new Schedule();
        HashMap<Actor, Integer> firingsRemainingVector = new HashMap<Actor, Integer>();
        firingsRemainingVector.putAll(this._firingVector);
        LinkedList unscheduledActorList = new LinkedList();
        unscheduledActorList.addAll(actorList);
        try {
            for (Actor actor : actorList) {
                for (IOPort inputPort : actor.inputPortList()) {
                    Receiver[][] receivers = inputPort.getReceivers();
                    if (receivers == null) continue;
                    int m = 0;
                    while (m < receivers.length) {
                        int n = 0;
                        while (n < receivers[m].length) {
                            ((SDFReceiver)receivers[m][n])._waitingTokens = 0;
                            ++n;
                        }
                        ++m;
                    }
                }
            }
            for (IOPort outputPort : container.outputPortList()) {
                Receiver[][] receivers = outputPort.getInsideReceivers();
                if (receivers == null) continue;
                int m = 0;
                while (m < receivers.length) {
                    int n = 0;
                    while (n < receivers[m].length) {
                        ((SDFReceiver)receivers[m][n])._waitingTokens = 0;
                        ++n;
                    }
                    ++m;
                }
            }
            for (Actor actor : actorList) {
                int firingsRemaining = (Integer)firingsRemainingVector.get(actor);
                if (firingsRemaining == 0) {
                    unscheduledActorList.remove(actor);
                    continue;
                }
                int inputCount = this._countUnfulfilledInputs(actor, actorList, true);
                if (inputCount != 0) continue;
                readyToScheduleActorList.addFirst(actor);
            }
            for (Actor actor : actorList) {
                for (IOPort outputPort : actor.outputPortList()) {
                    int count = DFUtilities.getTokenInitProduction((IOPort)outputPort);
                    if (count <= 0) continue;
                    this._simulateTokensCreated(outputPort, count, actorList, readyToScheduleActorList);
                }
            }
            for (IOPort port : container.inputPortList()) {
                int count = (Integer)externalRates.get(port);
                if (count <= 0) continue;
                this._simulateExternalInputs(port, count, actorList, readyToScheduleActorList);
            }
            while (readyToScheduleActorList.size() > 0) {
                int firingsRemaining;
                Actor currentActor = (Actor)readyToScheduleActorList.getFirst();
                while (readyToScheduleActorList.remove(currentActor)) {
                }
                int numberOfFirings = this._computeMaximumFirings(currentActor);
                if (numberOfFirings > (firingsRemaining = ((Integer)firingsRemainingVector.get(currentActor)).intValue())) {
                    numberOfFirings = firingsRemaining;
                }
                firingsRemainingVector.put(currentActor, firingsRemaining -= numberOfFirings);
                this._simulateInputConsumption(currentActor, numberOfFirings);
                Firing firing = new Firing();
                firing.setActor(currentActor);
                firing.setIterationCount(numberOfFirings);
                newSchedule.add((ScheduleElement)firing);
                for (IOPort outputPort : currentActor.outputPortList()) {
                    int count = DFUtilities.getTokenProductionRate((IOPort)outputPort);
                    this._simulateTokensCreated(outputPort, count * numberOfFirings, unscheduledActorList, readyToScheduleActorList);
                }
                if (firingsRemaining < 0) {
                    throw new InternalErrorException("Balance Equation solution does not agree with scheduling algorithm!");
                }
                if (firingsRemaining == 0) {
                    while (unscheduledActorList.remove(currentActor)) {
                    }
                    continue;
                }
                int inputCount = this._countUnfulfilledInputs(currentActor, unscheduledActorList, false);
                if (inputCount > 0 || !unscheduledActorList.contains(currentActor)) continue;
                readyToScheduleActorList.addFirst(currentActor);
            }
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException((Nameable)this, (Throwable)ex, "SDF Scheduler Failed internal consistency check.");
        }
        if (unscheduledActorList.size() > 0) {
            StringBuffer message = new StringBuffer("Actors remain that cannot be scheduled!\nUnscheduled actors:\n");
            int count = 0;
            Iterator actors = unscheduledActorList.iterator();
            while (actors.hasNext() && count < 100) {
                Entity entity = (Entity)actors.next();
                message.append(String.valueOf(entity.getFullName()) + " ");
                ++count;
            }
            if (count >= 99) {
                message.append("...");
            }
            message.append("\nScheduled actors:\n");
            LinkedList scheduledActorList = new LinkedList();
            scheduledActorList.addAll(actorList);
            scheduledActorList.removeAll(unscheduledActorList);
            count = 0;
            Iterator actors2 = scheduledActorList.iterator();
            while (actors2.hasNext() && count < 100) {
                Entity entity = (Entity)actors2.next();
                message.append(String.valueOf(entity.getFullName()) + " ");
                ++count;
            }
            if (count >= 99) {
                message.append("...");
            }
            throw new NotSchedulableException(message.toString());
        }
        if (this._debugging) {
            this._debug("Schedule is:");
            this._debug(newSchedule.toString());
        }
        return newSchedule;
    }

    protected void _simulateExternalInputs(IOPort port, int count, List actorList, LinkedList readyToScheduleActorList) throws IllegalActionException {
        Receiver[][] receivers = port.deepGetReceivers();
        int channel = 0;
        while (channel < receivers.length) {
            if (receivers[channel] != null) {
                int copy = 0;
                while (copy < receivers[channel].length) {
                    if (receivers[channel][copy] instanceof SDFReceiver) {
                        int capacity;
                        SDFReceiver receiver = (SDFReceiver)receivers[channel][copy];
                        IOPort connectedPort = receivers[channel][copy].getContainer();
                        ComponentEntity connectedActor = (ComponentEntity)connectedPort.getContainer();
                        receiver._waitingTokens = count;
                        boolean enforce = ((BooleanToken)this.constrainBufferSizes.getToken()).booleanValue();
                        if (enforce && ((capacity = receiver.getCapacity()) == -1 || receiver._waitingTokens > capacity)) {
                            receiver.setCapacity(count);
                        }
                        if (actorList.contains(connectedActor)) {
                            int inputCount = this._countUnfulfilledInputs((Actor)connectedActor, actorList, false);
                            int firingsRemaining = this._getFiringCount((Entity)connectedActor);
                            if (inputCount < 1 && firingsRemaining > 0) {
                                readyToScheduleActorList.addFirst(connectedActor);
                            }
                        }
                    }
                    ++copy;
                }
            }
            ++channel;
        }
    }

    protected boolean _simulateInputConsumption(Actor currentActor, int firingCount) throws IllegalActionException {
        boolean stillReadyToSchedule = true;
        for (IOPort inputPort : currentActor.inputPortList()) {
            int tokenRate = DFUtilities.getTokenConsumptionRate((IOPort)inputPort);
            Receiver[][] receivers = inputPort.getReceivers();
            int channel = 0;
            while (channel < receivers.length) {
                if (receivers[channel] != null) {
                    int copy = 0;
                    while (copy < receivers[channel].length) {
                        if (receivers[channel][copy] instanceof SDFReceiver) {
                            SDFReceiver receiver = (SDFReceiver)receivers[channel][copy];
                            receiver._waitingTokens -= tokenRate * firingCount;
                            if (receiver._waitingTokens < tokenRate) {
                                stillReadyToSchedule = false;
                            }
                        }
                        ++copy;
                    }
                }
                ++channel;
            }
        }
        return stillReadyToSchedule;
    }

    private void _simulateTokensCreated(IOPort outputPort, int createdTokens, List actorList, LinkedList readyToScheduleActorList) throws IllegalActionException {
        Receiver[][] receivers = outputPort.getRemoteReceivers();
        int channel = 0;
        while (channel < receivers.length) {
            if (receivers[channel] != null) {
                int copy = 0;
                while (copy < receivers[channel].length) {
                    if (receivers[channel][copy] instanceof SDFReceiver) {
                        int capacity;
                        SDFReceiver receiver = (SDFReceiver)receivers[channel][copy];
                        IOPort connectedPort = receivers[channel][copy].getContainer();
                        ComponentEntity connectedActor = (ComponentEntity)connectedPort.getContainer();
                        receiver._waitingTokens += createdTokens;
                        boolean enforce = ((BooleanToken)this.constrainBufferSizes.getToken()).booleanValue();
                        if (enforce && ((capacity = receiver.getCapacity()) == -1 || receiver._waitingTokens > capacity)) {
                            receiver.setCapacity(receiver._waitingTokens);
                        }
                        if (actorList.contains(connectedActor)) {
                            int inputCount = this._countUnfulfilledInputs((Actor)connectedActor, actorList, false);
                            int firingsRemaining = this._getFiringCount((Entity)connectedActor);
                            if (inputCount < 1 && firingsRemaining > 0) {
                                readyToScheduleActorList.addFirst(connectedActor);
                            }
                        }
                    }
                    ++copy;
                }
            }
            ++channel;
        }
    }
}

