/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public final class SDFIOPort
extends TypedIOPort {
    public Parameter tokenConsumptionRate;
    public Parameter tokenInitProduction;
    public Parameter tokenProductionRate;

    public SDFIOPort() {
        this._initialize();
    }

    public SDFIOPort(Workspace workspace) {
        super(workspace);
        this._initialize();
    }

    public SDFIOPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._initialize();
    }

    public SDFIOPort(ComponentEntity container, String name, boolean isInput, boolean isOutput) throws IllegalActionException, NameDuplicationException {
        this(container, name);
        this.setInput(isInput);
        this.setOutput(isOutput);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SDFIOPort newObject = (SDFIOPort)((Object)super.clone(workspace));
        newObject.tokenConsumptionRate = (Parameter)newObject.getAttribute("tokenConsumptionRate");
        newObject.tokenInitProduction = (Parameter)newObject.getAttribute("tokenInitProduction");
        newObject.tokenProductionRate = (Parameter)newObject.getAttribute("tokenProductionRate");
        return newObject;
    }

    public int getTokenConsumptionRate() throws IllegalActionException {
        return ((IntToken)this.tokenConsumptionRate.getToken()).intValue();
    }

    public int getTokenInitProduction() throws IllegalActionException {
        return ((IntToken)this.tokenInitProduction.getToken()).intValue();
    }

    public int getTokenProductionRate() throws IllegalActionException {
        return ((IntToken)this.tokenProductionRate.getToken()).intValue();
    }

    public void setInput(boolean isInput) throws IllegalActionException {
        super.setInput(isInput);
        try {
            if (isInput) {
                this.tokenConsumptionRate.setToken((Token)new IntToken(1));
            } else {
                this.tokenConsumptionRate.setToken((Token)new IntToken(0));
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
    }

    public void setOutput(boolean isOutput) throws IllegalActionException {
        super.setOutput(isOutput);
        try {
            if (isOutput) {
                this.tokenProductionRate.setToken((Token)new IntToken(1));
            } else {
                this.tokenProductionRate.setToken((Token)new IntToken(0));
                this.tokenInitProduction.setToken((Token)new IntToken(0));
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(e.getMessage());
        }
    }

    public void setTokenConsumptionRate(int rate) throws IllegalActionException {
        if (rate < 0) {
            throw new IllegalActionException("Rate must be >= 0");
        }
        if (!this.isInput()) {
            throw new IllegalActionException((Nameable)this, "Port is not an input port.");
        }
        this.tokenConsumptionRate.setToken((Token)new IntToken(rate));
    }

    public void setTokenInitProduction(int count) throws IllegalActionException {
        if (count < 0) {
            throw new IllegalActionException("Count must be >= 0");
        }
        if (!this.isOutput()) {
            throw new IllegalActionException((Nameable)this, "Port is not an Output Port.");
        }
        this.tokenInitProduction.setToken((Token)new IntToken(count));
    }

    public void setTokenProductionRate(int rate) throws IllegalActionException {
        if (rate < 0) {
            throw new IllegalActionException("Rate must be >= 0");
        }
        if (!this.isOutput()) {
            throw new IllegalActionException((Nameable)this, "Port is not an Output Port.");
        }
        this.tokenProductionRate.setToken((Token)new IntToken(rate));
    }

    private void _initialize() {
        try {
            this.tokenConsumptionRate = new Parameter((NamedObj)this, "tokenConsumptionRate", (Token)new IntToken(0));
            this.tokenInitProduction = new Parameter((NamedObj)this, "tokenInitProduction", (Token)new IntToken(0));
            this.tokenProductionRate = new Parameter((NamedObj)this, "tokenProductionRate", (Token)new IntToken(0));
        }
        catch (Throwable throwable) {
            throw new InternalErrorException((Nameable)this, throwable, "");
        }
    }
}

