/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IORelation;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.CompositeProcessDirector;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.pn.kernel.PNQueueReceiver;
import ptolemy.domains.pn.kernel.event.PNProcessListener;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class PNDirector
extends CompositeProcessDirector {
    public Parameter initialQueueCapacity;
    public Parameter maximumQueueCapacity;
    public static boolean READ_BLOCKED = true;
    public static boolean WRITE_BLOCKED = false;
    protected HashMap _readBlockedQueues = new HashMap();
    protected HashMap _writeBlockedQueues = new HashMap();
    private LinkedList _processListeners = new LinkedList();
    private LinkedList _receivers = new LinkedList();

    public PNDirector() throws IllegalActionException, NameDuplicationException {
        this._init();
    }

    public PNDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public PNDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    public void addProcessListener(PNProcessListener listener) {
        this._processListeners.add(listener);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        PNDirector newObject = (PNDirector)((Object)super.clone(workspace));
        newObject._readBlockedQueues = new HashMap();
        newObject._writeBlockedQueues = new HashMap();
        return newObject;
    }

    public void initialize() throws IllegalActionException {
        this._readBlockedQueues.clear();
        this._writeBlockedQueues.clear();
        super.initialize();
    }

    public Receiver newReceiver() {
        PNQueueReceiver receiver = new PNQueueReceiver();
        this._receivers.add(new WeakReference<PNQueueReceiver>(receiver));
        try {
            int capacity = ((IntToken)this.initialQueueCapacity.getToken()).intValue();
            receiver.setCapacity(capacity);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return receiver;
    }

    public boolean postfire() throws IllegalActionException {
        this._notDone = super.postfire();
        if (!((CompositeActor)this.getContainer()).inputPortList().isEmpty() && this._getActiveThreadsCount() != 0) {
            return !this._stopRequested;
        }
        return this._notDone;
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        CompositeEntity container = (CompositeEntity)this.getContainer();
        for (IORelation relation : container.relationList()) {
            if (relation.linkedSourcePortList().size() <= 1) continue;
            throw new IllegalActionException((Nameable)relation, "Relation has multiple sources of data, which is not allowed in PN. If you want nondeterministic merge, use the NondeterministicMerge actor.");
        }
        Parameter parameter = (Parameter)this.getAttribute("initialQueueCapacity");
        int capacity = ((IntToken)parameter.getToken()).intValue();
        ListIterator receivers = this._receivers.listIterator();
        while (receivers.hasNext()) {
            WeakReference reference = (WeakReference)receivers.next();
            if (reference.get() == null) {
                receivers.remove();
                continue;
            }
            PNQueueReceiver receiver = (PNQueueReceiver)((Object)reference.get());
            if (receiver.getDirector() == this) {
                receiver.clear();
                receiver.setCapacity(capacity);
                continue;
            }
            receivers.remove();
        }
    }

    public void removeProcessListener(PNProcessListener listener) {
        this._processListeners.remove(listener);
    }

    public String[] suggestedModalModelDirectors() {
        return new String[]{"ptolemy.domains.fsm.kernel.MultirateFSMDirector", "ptolemy.domains.fsm.kernel.FSMDirector"};
    }

    public boolean supportMultirateFiring() {
        return true;
    }

    public synchronized void threadBlocked(Thread thread, ProcessReceiver receiver, boolean readOrWrite) {
        if (readOrWrite == READ_BLOCKED) {
            this._readBlockedQueues.put(receiver, thread);
        } else {
            this._writeBlockedQueues.put(receiver, thread);
        }
        super.threadBlocked(thread, receiver);
    }

    public synchronized void threadUnblocked(Thread thread, ProcessReceiver receiver, boolean readOrWrite) {
        if (readOrWrite == READ_BLOCKED) {
            this._readBlockedQueues.remove(receiver);
        } else {
            this._writeBlockedQueues.remove(receiver);
        }
        super.threadUnblocked(thread, receiver);
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void _incrementLowestWriteCapacityPort() throws IllegalActionException {
        smallestCapacityQueue = null;
        smallestCapacity = -1;
        receivers = this._writeBlockedQueues.keySet().iterator();
        if (receivers.hasNext()) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            queue = (PNQueueReceiver)receivers.next();
            if (smallestCapacity == -1) {
                smallestCapacityQueue = queue;
                smallestCapacity = queue.getCapacity();
                continue;
            }
            if (smallestCapacity <= queue.getCapacity()) continue;
            smallestCapacityQueue = queue;
            smallestCapacity = queue.getCapacity();
lbl14:
            // 4 sources

            ** while (receivers.hasNext())
        }
lbl15:
        // 1 sources

        capacity = smallestCapacityQueue.getCapacity();
        if (capacity <= 0) {
            smallestCapacityQueue.setCapacity(1);
            capacity = 1;
        } else {
            maximumCapacity = ((IntToken)this.maximumQueueCapacity.getToken()).intValue();
            if (maximumCapacity > 0 && capacity * 2 > maximumCapacity) {
                msg = "Queue size " + capacity * 2 + " exceeds the maximum capacity in port " + smallestCapacityQueue.getContainer().getFullName() + ". Perhaps you have an unbounded queue?";
                if (this._debugging) {
                    this._debug(msg);
                }
                throw new IllegalActionException((Nameable)this, msg);
            }
            smallestCapacityQueue.setCapacity(capacity * 2);
        }
        if (this._debugging) {
            this._debug("increasing the capacity of receiver " + smallestCapacityQueue.getContainer() + " to " + smallestCapacityQueue.getCapacity());
        }
        this.threadUnblocked((Thread)this._writeBlockedQueues.get((Object)smallestCapacityQueue), smallestCapacityQueue, PNDirector.WRITE_BLOCKED);
    }

    protected boolean _resolveInternalDeadlock() throws IllegalActionException {
        if (this._writeBlockedQueues.size() == 0 && this._readBlockedQueues.size() > 0) {
            if (this._debugging) {
                this._debug("Deadlock detected: no processes blocked on write, but some are blocked on read.");
            }
            return false;
        }
        if (this._getActiveThreadsCount() == 0) {
            if (this._debugging) {
                this._debug("No more active processes.");
            }
            return false;
        }
        if (this._debugging) {
            this._debug("Artificial Deadlock - increasing queue capacity.");
        }
        this._incrementLowestWriteCapacityPort();
        return true;
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.initialQueueCapacity = new Parameter((NamedObj)this, "initialQueueCapacity", (Token)new IntToken(1));
        this.initialQueueCapacity.setTypeEquals((Type)BaseType.INT);
        this.maximumQueueCapacity = new Parameter((NamedObj)this, "maximumQueueCapacity", (Token)new IntToken(65536));
        this.maximumQueueCapacity.setTypeEquals((Type)BaseType.INT);
    }
}

