/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.modal;

import ptolemy.actor.IOPort;
import ptolemy.domains.fsm.modal.ModalModel;
import ptolemy.domains.fsm.modal.RefinementPort;
import ptolemy.domains.fsm.modal.TransitionRefinement;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class TransitionRefinementPort
extends RefinementPort {
    protected boolean _hasSibling = false;

    public TransitionRefinementPort(Workspace workspace) {
        super(workspace);
    }

    public TransitionRefinementPort(ComponentEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void link(Relation relation) throws IllegalActionException {
        if (this.isInput() && this._hasSibling && this.isLinked(relation)) {
            return;
        }
        super.link(relation);
    }

    public int moveDown() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveDown();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveDown();
                    success = true;
                }
                if (!success) {
                    result = super.moveDown();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToFirst() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToFirst();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToFirst();
                    success = true;
                }
                if (!success) {
                    result = super.moveToFirst();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToIndex(int index) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToIndex(index);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToIndex(index);
                    success = true;
                }
                if (!success) {
                    result = super.moveToIndex(index);
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveToLast() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveToLast();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveToLast();
                    success = true;
                }
                if (!success) {
                    result = super.moveToLast();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public int moveUp() throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            int result = -1;
            if (this._mirrorDisable || this.getContainer() == null) {
                result = super.moveUp();
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).moveUp();
                    success = true;
                }
                if (!success) {
                    result = super.moveUp();
                }
            }
            int n = result;
            return n;
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setContainer(Entity container) throws IllegalActionException, NameDuplicationException {
        NamedObj oldContainer = this.getContainer();
        if (container == oldContainer) {
            return;
        }
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                if (this._hasSibling && this.isOutput() && this.getContainer() != null) {
                    TransitionRefinement transContainer = (TransitionRefinement)oldContainer;
                    TransitionRefinementPort sibling = (TransitionRefinementPort)transContainer.getPort(String.valueOf(this.getName()) + "_in");
                    sibling._mirrorDisable = true;
                    sibling.setContainer(container);
                    sibling._mirrorDisable = false;
                }
                super.setContainer(container);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                String portName = this.getName();
                if (this._hasSibling && this.isInput() && !this.isOutput()) {
                    portName = this.getName().substring(0, this.getName().length() - 3);
                }
                if (oldContainer != null && (modal = oldContainer.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(portName)) != null) {
                    port.setContainer(null);
                    success = true;
                }
                if (!success) {
                    super.setContainer(container);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setInput(boolean isInput) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                super.setInput(isInput);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setInput(isInput);
                    success = true;
                }
                if (!success) {
                    super.setInput(isInput);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setMultiport(boolean isMultiport) throws IllegalActionException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                if (this._hasSibling && this.isOutput() && this.getContainer() != null) {
                    TransitionRefinement container = (TransitionRefinement)this.getContainer();
                    TransitionRefinementPort sibling = (TransitionRefinementPort)container.getPort(String.valueOf(this.getName()) + "_in");
                    sibling._mirrorDisable = true;
                    sibling.setMultiport(isMultiport);
                    sibling._mirrorDisable = false;
                }
                super.setMultiport(isMultiport);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setMultiport(isMultiport);
                    success = true;
                }
                if (!success) {
                    super.setMultiport(isMultiport);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setName(String name) throws IllegalActionException, NameDuplicationException {
        boolean disableStatus = this._mirrorDisable;
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                if (this._hasSibling && this.isOutput() && this.getContainer() != null) {
                    TransitionRefinement container = (TransitionRefinement)this.getContainer();
                    TransitionRefinementPort sibling = (TransitionRefinementPort)container.getPort(String.valueOf(this.getName()) + "_in");
                    sibling._mirrorDisable = true;
                    sibling.setName(String.valueOf(name) + "_in");
                    sibling._mirrorDisable = false;
                }
                super.setName(name);
            } else {
                Port port;
                NamedObj modal;
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) != null) {
                    port.setName(name);
                    success = true;
                }
                if (!success) {
                    super.setName(name);
                }
            }
        }
        finally {
            this._mirrorDisable = disableStatus;
            this._workspace.doneWriting();
        }
    }

    public void setOutput(boolean isOutput) throws IllegalActionException {
        block12: {
            boolean disableStatus = this._mirrorDisable;
            if (this._hasSibling && this.isInput() && !this.isOutput()) {
                if (isOutput) {
                    throw new InternalErrorException("TransitionRefinementPort.setOutput: cannot set input sibling port to be an output");
                }
                return;
            }
            try {
                Port port;
                NamedObj modal;
                this._workspace.getWriteAccess();
                if (this._mirrorDisable || this.getContainer() == null) {
                    super.setOutput(isOutput);
                    if (this._hasSibling || !isOutput) break block12;
                    try {
                        TransitionRefinement container = (TransitionRefinement)this.getContainer();
                        TransitionRefinementPort sibling = new TransitionRefinementPort((ComponentEntity)container, String.valueOf(this.getName()) + "_in");
                        sibling._hasSibling = true;
                        sibling._mirrorDisable = true;
                        sibling.setInput(true);
                        sibling.setMultiport(this.isMultiport());
                        sibling._mirrorDisable = false;
                        String relationName = String.valueOf(this.getName()) + "Relation";
                        ModalModel model = (ModalModel)container.getContainer();
                        ComponentRelation relation = model.getRelation(relationName);
                        if (relation != null) {
                            sibling.link((Relation)relation);
                        }
                        this._hasSibling = true;
                        break block12;
                    }
                    catch (IllegalActionException ex) {
                        throw new InternalErrorException("TransitionRefinementPort.setOutput: Internal error: " + ex.getMessage());
                    }
                    catch (NameDuplicationException ex) {
                        throw new InternalErrorException("TransitionRefinementPort.setOutput: Internal error: " + ex.getMessage());
                    }
                }
                this._mirrorDisable = true;
                boolean success = false;
                NamedObj container = this.getContainer();
                if (container != null && (modal = container.getContainer()) instanceof ModalModel && (port = ((ModalModel)modal).getPort(this.getName())) instanceof IOPort) {
                    ((IOPort)port).setOutput(isOutput);
                    success = true;
                }
                if (!success) {
                    super.setOutput(isOutput);
                }
            }
            finally {
                this._mirrorDisable = disableStatus;
                this._workspace.doneWriting();
            }
        }
    }
}

