/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.modal;

import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedActor;
import ptolemy.actor.util.FunctionDependencyOfCompositeActor;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.modal.ModalModel;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.util.MessageHandler;

public class FunctionDependencyOfModalModel
extends FunctionDependencyOfCompositeActor {
    boolean _conservativeAnalysis = true;

    public FunctionDependencyOfModalModel(CompositeActor compositeActor) throws IllegalActionException, NameDuplicationException {
        super(compositeActor);
    }

    public void setConservativeAnalysis(boolean flag) {
        this._conservativeAnalysis = flag;
    }

    protected List _getEntities() {
        LinkedList<TypedActor> entities = new LinkedList<TypedActor>();
        try {
            FSMActor controller = ((ModalModel)this.getContainer()).getController();
            if (this._conservativeAnalysis) {
                for (State state : controller.entityList(State.class)) {
                    TypedActor[] actors = state.getRefinement();
                    if (actors == null || actors.length <= 0) continue;
                    int i = 0;
                    while (i < actors.length) {
                        if (!entities.contains(actors[i])) {
                            entities.add(actors[i]);
                        }
                        ++i;
                    }
                }
            } else {
                TypedActor[] actors = controller.currentState().getRefinement();
                if (actors != null && actors.length > 0) {
                    int i = 0;
                    while (i < actors.length) {
                        entities.add(actors[i]);
                        ++i;
                    }
                } else {
                    entities.add(controller);
                }
            }
        }
        catch (IllegalActionException e) {
            MessageHandler.error((String)"Invalid refinements.", (Throwable)e);
        }
        return entities;
    }
}

