/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.expr.ASTPtLeafNode;
import ptolemy.data.expr.ASTPtLogicalNode;
import ptolemy.data.expr.ASTPtRelationalNode;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.ParseTreeFreeVariableCollector;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.Token;
import ptolemy.domains.fsm.kernel.RelationList;
import ptolemy.kernel.util.IllegalActionException;

public class ParseTreeEvaluatorForGuardExpression
extends ParseTreeEvaluator {
    private LinkedList _absentDiscreteVariables = new LinkedList();
    private boolean _constructingRelationList = true;
    private double _difference;
    private double _errorTolerance;
    private int _relationIndex;
    private RelationList _relationList;
    private int _relationType;
    private ParseTreeFreeVariableCollector _variableCollector;

    public ParseTreeEvaluatorForGuardExpression(RelationList relationList, double errorTolerance) {
        this._errorTolerance = errorTolerance;
        this._relationIndex = 0;
        this._relationList = relationList;
        this._variableCollector = new ParseTreeFreeVariableCollector();
    }

    public ptolemy.data.Token evaluateParseTree(ASTPtRootNode node, ParserScope scope) throws IllegalActionException {
        this._relationIndex = 0;
        ptolemy.data.Token result = super.evaluateParseTree(node, scope);
        if (this._constructingRelationList) {
            this._constructingRelationList = false;
        }
        return result;
    }

    public RelationList getRelationList() {
        return this._relationList;
    }

    public void setConstructionMode() {
        this._constructingRelationList = true;
        this._relationList.destroy();
    }

    public void visitLeafNode(ASTPtLeafNode node) throws IllegalActionException {
        int variableNameEndIndex;
        String nodeName = node.getName();
        String discreteVariableName = "";
        if (nodeName != null && (variableNameEndIndex = nodeName.indexOf("_isPresent")) != -1) {
            discreteVariableName = nodeName.substring(0, variableNameEndIndex);
        }
        if (this._absentDiscreteVariables.contains(nodeName)) {
            this._evaluatedChildToken = new BooleanToken(false);
            if (this._constructingRelationList) {
                this._relationList.addRelation(0, 0.0);
            } else {
                ++this._relationIndex;
                if (this._relationIndex >= this._relationList.length()) {
                    this._relationIndex -= this._relationList.length();
                }
            }
            return;
        }
        super.visitLeafNode(node);
        ptolemy.data.Token result = this._evaluatedChildToken;
        if (!(result instanceof BooleanToken)) {
            return;
        }
        if (((BooleanToken)result).booleanValue()) {
            this._relationType = 1;
            if (this._absentDiscreteVariables.contains(discreteVariableName)) {
                this._absentDiscreteVariables.remove(discreteVariableName);
            }
        } else {
            this._relationType = 2;
            if (!this._absentDiscreteVariables.contains(discreteVariableName)) {
                this._absentDiscreteVariables.add(discreteVariableName);
            }
        }
        this._difference = 0.0;
        if (this._constructingRelationList) {
            this._relationList.addRelation(this._relationType, this._difference);
        } else {
            this._relationList.setRelation(this._relationIndex, this._relationType, this._difference);
            ++this._relationIndex;
            if (this._relationIndex >= this._relationList.length()) {
                this._relationIndex -= this._relationList.length();
            }
        }
    }

    public void visitLogicalNode(ASTPtLogicalNode node) throws IllegalActionException {
        if (node.isConstant() && node.isEvaluated()) {
            return;
        }
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren > 0, (ASTPtRootNode)node, "The number of child nodes must be greater than zero");
        ptolemy.data.Token result = this._evaluateChild((ASTPtRootNode)node, 0);
        if (!(result instanceof BooleanToken)) {
            throw new IllegalActionException("Cannot perform logical operation on " + result + " which is a " + result.getClass().getName());
        }
        this._assert(node.isLogicalAnd() ^ node.isLogicalOr(), (ASTPtRootNode)node, "Invalid operation");
        boolean flag = node.isLogicalAnd();
        int i = 1;
        while (i < numChildren) {
            ptolemy.data.Token nextToken = this._evaluateChild((ASTPtRootNode)node, i);
            if (!(nextToken instanceof BooleanToken)) {
                throw new IllegalActionException("Cannot perform logical operation on " + nextToken + " which is a " + result.getClass().getName());
            }
            result = flag ? ((BooleanToken)nextToken).and((BooleanToken)result) : ((BooleanToken)nextToken).or((BooleanToken)result);
            ++i;
        }
        this._evaluatedChildToken = result;
    }

    public void visitRelationalNode(ASTPtRelationalNode node) throws IllegalActionException {
        BooleanToken result;
        if (node.isConstant() && node.isEvaluated()) {
            return;
        }
        Set variablesOfNode = this._variableCollector.collectFreeVariables((ASTPtRootNode)node);
        ListIterator absentDiscreteVariables = this._absentDiscreteVariables.listIterator();
        while (absentDiscreteVariables.hasNext()) {
            String variableName = (String)absentDiscreteVariables.next();
            if (!variablesOfNode.contains(variableName)) continue;
            this._evaluatedChildToken = new BooleanToken(false);
            if (this._constructingRelationList) {
                this._relationList.addRelation(0, 0.0);
            } else {
                ++this._relationIndex;
                if (this._relationIndex >= this._relationList.length()) {
                    this._relationIndex -= this._relationList.length();
                }
            }
            return;
        }
        ptolemy.data.Token[] tokens = this._evaluateAllChildren((ASTPtRootNode)node);
        int numChildren = node.jjtGetNumChildren();
        this._assert(numChildren == 2, (ASTPtRootNode)node, "The number of child nodes must be two");
        Token operator = node.getOperator();
        ptolemy.data.Token leftToken = tokens[0];
        ptolemy.data.Token rightToken = tokens[1];
        if (operator.kind == 33 || operator.kind == 32) {
            result = operator.kind == 33 ? leftToken.isCloseTo(rightToken, this._errorTolerance) : leftToken.isCloseTo(rightToken, this._errorTolerance).not();
            if (leftToken instanceof ScalarToken && rightToken instanceof ScalarToken && !(leftToken instanceof BooleanToken)) {
                ScalarToken difference = (ScalarToken)leftToken.subtract(rightToken);
                this._relationType = result.booleanValue() ? 3 : (difference.doubleValue() < 0.0 ? 4 : 5);
                this._difference = difference.doubleValue();
            } else {
                this._relationType = result.booleanValue() ? 1 : 2;
                this._difference = 0.0;
            }
        } else {
            if (!(leftToken instanceof ScalarToken) || !(rightToken instanceof ScalarToken)) {
                throw new IllegalActionException("The " + operator.image + " operator can only be applied between scalars.");
            }
            ScalarToken leftScalar = (ScalarToken)leftToken;
            ScalarToken rightScalar = (ScalarToken)rightToken;
            if (operator.kind == 30) {
                result = leftScalar.isLessThan(rightScalar).not();
            } else if (operator.kind == 28) {
                result = rightScalar.isLessThan(leftScalar);
            } else if (operator.kind == 31) {
                result = rightScalar.isLessThan(leftScalar).not();
            } else if (operator.kind == 29) {
                result = leftScalar.isLessThan(rightScalar);
            } else {
                throw new IllegalActionException("Invalid operation " + operator.image + " between " + leftToken.getClass().getName() + " and " + rightToken.getClass().getName());
            }
            this._relationType = result.booleanValue() ? 1 : 2;
            this._difference = ((ScalarToken)leftScalar.subtract((ptolemy.data.Token)rightScalar)).doubleValue();
        }
        this._difference = Math.abs(this._difference);
        if (this._constructingRelationList) {
            this._relationList.addRelation(this._relationType, this._difference);
        } else {
            this._relationList.setRelation(this._relationIndex, this._relationType, this._difference);
            ++this._relationIndex;
            if (this._relationIndex >= this._relationList.length()) {
                this._relationIndex -= this._relationList.length();
            }
        }
        this._evaluatedChildToken = result;
    }
}

