/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.AddSubtract;
import ptolemy.actor.lib.Scale;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ct.lib.Integrator;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ContinuousTransferFunction
extends TypedCompositeActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort output = new TypedIOPort((ComponentEntity)this, "output", false, true);
    public Parameter numerator = new Parameter((NamedObj)this, "numerator");
    public Parameter denominator;
    private boolean _opaque = true;

    public ContinuousTransferFunction(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.numerator.setExpression("{1.0}");
        this.numerator.setTypeEquals((Type)new ArrayType((Type)BaseType.DOUBLE));
        this.denominator = new Parameter((NamedObj)this, "denominator");
        this.denominator.setExpression("{1.0}");
        this.denominator.setTypeEquals((Type)new ArrayType((Type)BaseType.DOUBLE));
        this.setClassName("ptolemy.domains.ct.lib.ContinuousTransferFunction");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<text x=\"-25\" y=\"0\" style=\"font-size:14\">\nb(s)/a(s) \n</text>\nstyle=\"fill:blue\"/>\n</svg>\n");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numerator) {
            this._opaque = true;
            Director dir = this.getDirector();
            if (dir != null) {
                dir.requestInitialization((Actor)this);
            }
        } else if (attribute == this.denominator) {
            ArrayToken aToken = (ArrayToken)this.denominator.getToken();
            if (((DoubleToken)aToken.getElement(0)).doubleValue() == 0.0) {
                throw new IllegalActionException((Nameable)this, "The denominator coefficient cannot start with 0.");
            }
            this._opaque = true;
            Director dir = this.getDirector();
            if (dir != null) {
                dir.requestInitialization((Actor)this);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Director getDirector() {
        if (this._opaque) {
            return null;
        }
        return this.getExecutiveDirector();
    }

    public boolean isOpaque() {
        return this._opaque;
    }

    public void preinitialize() throws IllegalActionException {
        ArrayToken bToken = (ArrayToken)this.numerator.getToken();
        int m = bToken.length();
        double[] bRow = new double[m];
        int i = 0;
        while (i < m) {
            bRow[i] = ((DoubleToken)bToken.getElement(i)).doubleValue();
            ++i;
        }
        ArrayToken aToken = (ArrayToken)this.denominator.getToken();
        int n = aToken.length();
        double[] a = new double[n];
        int i2 = 0;
        while (i2 < n) {
            a[i2] = ((DoubleToken)aToken.getElement(i2)).doubleValue();
            ++i2;
        }
        if (m > n) {
            throw new IllegalActionException((Nameable)this, "The order of the denominator must be greater than or equal to the order of the numerator.");
        }
        double[] b = new double[n];
        int i3 = 1;
        while (i3 <= m) {
            b[n - i3] = bRow[m - i3];
            ++i3;
        }
        try {
            try {
                this._workspace.getWriteAccess();
                this.removeAllEntities();
                this.removeAllRelations();
                if (n == 1) {
                    if (a[0] == b[0]) {
                        this.connect((ComponentPort)this.input, (ComponentPort)this.output);
                    } else {
                        Scale scaleD = new Scale((CompositeEntity)this, "ScaleD");
                        scaleD.factor.setToken((Token)new DoubleToken(b[0] / a[0]));
                        this.connect((ComponentPort)this.input, (ComponentPort)scaleD.input);
                        this.connect((ComponentPort)this.output, (ComponentPort)scaleD.output);
                    }
                } else {
                    double d = b[0] / a[0];
                    int order = n - 1;
                    AddSubtract inputAdder = new AddSubtract((CompositeEntity)this, "InputAdder");
                    AddSubtract outputAdder = new AddSubtract((CompositeEntity)this, "OutputAdder");
                    Integrator[] integrators = new Integrator[order];
                    IORelation[] nodes = new IORelation[order];
                    Scale[] feedback = new Scale[order];
                    Scale[] feedforward = new Scale[order];
                    int i4 = 0;
                    while (i4 < order) {
                        integrators[i4] = new Integrator((CompositeEntity)this, "Integrator" + i4);
                        feedback[i4] = new Scale((CompositeEntity)this, "Feedback" + i4);
                        feedback[i4].factor.setToken((Token)new DoubleToken(-a[i4 + 1] / a[0]));
                        feedforward[i4] = new Scale((CompositeEntity)this, "Feedforward" + i4);
                        feedforward[i4].factor.setToken((Token)new DoubleToken((b[i4 + 1] - d * a[i4 + 1]) / a[0]));
                        nodes[i4] = (IORelation)this.connect((ComponentPort)integrators[i4].output, (ComponentPort)feedforward[i4].input, "node" + i4);
                        feedback[i4].input.link((Relation)nodes[i4]);
                        this.connect((ComponentPort)feedback[i4].output, (ComponentPort)inputAdder.plus);
                        this.connect((ComponentPort)feedforward[i4].output, (ComponentPort)outputAdder.plus);
                        if (i4 >= 1) {
                            integrators[i4].input.link((Relation)nodes[i4 - 1]);
                        }
                        ++i4;
                    }
                    this.connect((ComponentPort)inputAdder.output, (ComponentPort)integrators[0].input);
                    IORelation inputRelation = (IORelation)this.connect((ComponentPort)this.input, (ComponentPort)inputAdder.plus, "inputRelation");
                    this.connect((ComponentPort)this.output, (ComponentPort)outputAdder.output, "outputRelation");
                    if (d != 0.0) {
                        Scale scaleD = new Scale((CompositeEntity)this, "ScaleD");
                        scaleD.factor.setToken((Token)new DoubleToken(d));
                        scaleD.input.link((Relation)inputRelation);
                        this.connect((ComponentPort)scaleD.output, (ComponentPort)outputAdder.plus);
                    }
                }
                this._opaque = false;
                this._workspace.incrVersion();
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException("Duplicated name when constructing the subsystem" + ex.getMessage());
            }
        }
        finally {
            this._workspace.doneWriting();
        }
        for (Actor actor : this.deepEntityList()) {
            actor.preinitialize();
        }
    }

    public void wrapup() throws IllegalActionException {
        this._opaque = true;
        super.wrapup();
    }
}

