/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.tutorial;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class SimpleALU
extends TypedAtomicActor {
    public TypedIOPort A = new TypedIOPort((ComponentEntity)this, "A", true, false);
    public TypedIOPort B;
    public TypedIOPort operation;
    public TypedIOPort output;

    public SimpleALU(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.A.setTypeEquals((Type)BaseType.INT);
        this.B = new TypedIOPort((ComponentEntity)this, "B", true, false);
        this.B.setTypeEquals((Type)BaseType.INT);
        this.operation = new TypedIOPort((ComponentEntity)this, "operation", true, false);
        this.operation.setTypeEquals((Type)BaseType.INT);
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setTypeEquals((Type)BaseType.INT);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SimpleALU newObject = (SimpleALU)((Object)super.clone(workspace));
        newObject.A.setTypeEquals((Type)BaseType.INT);
        newObject.B.setTypeEquals((Type)BaseType.INT);
        newObject.operation.setTypeEquals((Type)BaseType.INT);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        IntToken result = null;
        if (this.A.hasToken(0) && this.B.hasToken(0) && this.operation.hasToken(0)) {
            int opcode = ((IntToken)this.operation.get(0)).intValue();
            IntToken tokenA = (IntToken)this.A.get(0);
            IntToken tokenB = (IntToken)this.B.get(0);
            switch (opcode) {
                case 0: {
                    result = IntToken.ZERO;
                    break;
                }
                case 1: {
                    result = tokenA.add((Token)tokenB);
                    break;
                }
                case 2: {
                    result = tokenA.subtract((Token)tokenB);
                    break;
                }
                case 3: {
                    result = tokenA.multiply((Token)tokenB);
                    break;
                }
                case 4: {
                    result = tokenA.divide((Token)tokenB);
                    break;
                }
                default: {
                    throw new IllegalActionException((Nameable)this, "Unsupported operation code: " + opcode + ".\n");
                }
            }
        }
        this.output.send(0, result);
    }
}

