/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import ptolemy.actor.Actor;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class DatagramReader
extends TypedAtomicActor {
    public TypedIOPort returnAddress;
    public TypedIOPort returnSocketNumber;
    public TypedIOPort output;
    public TypedIOPort trigger = null;
    public Parameter localSocketNumber;
    public Parameter actorBufferLength;
    public Parameter platformBufferLength;
    public Parameter setPlatformBufferLength;
    public Parameter overwrite;
    public Parameter blockAwaitingDatagram;
    public Parameter defaultReturnAddress;
    public Parameter defaultReturnSocketNumber;
    public Parameter defaultOutput;
    private Object _syncFireAndThread = new Object();
    private Object _syncDefaultOutputs = new Object();
    private Object _syncBufferLength = new Object();
    private Object _syncSocket = new Object();
    private int _actorBufferLength;
    private boolean _overwrite;
    private boolean _blockAwaitingDatagram;
    private boolean _multiCast = false;
    private String _defaultReturnAddress;
    private int _defaultReturnSocketNumber;
    private Token _defaultOutputToken;
    private DatagramPacket _receivePacket = null;
    private DatagramPacket _broadcastPacket = null;
    private int _receiveAllocated = 0;
    private int _broadcastAllocated = 0;
    private int _packetsAlreadyAwaitingFire = 0;
    private int _ChangeRequestedToPlatformBufferLength;
    private DatagramSocket _socket;
    private MulticastSocket _multicastSocket;
    private SocketReadingThread _socketReadingThread;
    private String _returnAddress;
    private int _returnSocketNumber;
    private Token _outputToken;
    private InetAddress _address = null;
    private boolean _inReceive = false;
    private boolean _fireIsWaiting = false;
    private boolean _stopFire = false;

    public DatagramReader(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.returnAddress = new TypedIOPort((ComponentEntity)this, "returnAddress");
        this.returnAddress.setTypeEquals((Type)BaseType.STRING);
        this.returnAddress.setOutput(true);
        this.returnSocketNumber = new TypedIOPort((ComponentEntity)this, "returnSocketNumber");
        this.returnSocketNumber.setTypeEquals((Type)BaseType.INT);
        this.returnSocketNumber.setOutput(true);
        this.output = new TypedIOPort((ComponentEntity)this, "output");
        this.output.setTypeEquals((Type)new ArrayType((Type)BaseType.UNSIGNED_BYTE));
        this.output.setOutput(true);
        this.trigger = new TypedIOPort((ComponentEntity)this, "trigger", true, false);
        this.trigger.setTypeEquals((Type)BaseType.GENERAL);
        this.trigger.setMultiport(true);
        this.localSocketNumber = new Parameter((NamedObj)this, "localSocketNumber");
        this.localSocketNumber.setTypeEquals((Type)BaseType.INT);
        this.localSocketNumber.setToken((Token)new IntToken(4004));
        this.actorBufferLength = new Parameter((NamedObj)this, "actorBufferLength");
        this.actorBufferLength.setTypeEquals((Type)BaseType.INT);
        this.actorBufferLength.setToken((Token)new IntToken(440));
        this.platformBufferLength = new Parameter((NamedObj)this, "platformBufferLength");
        this.platformBufferLength.setTypeEquals((Type)BaseType.INT);
        this.platformBufferLength.setToken((Token)new IntToken(64));
        this.setPlatformBufferLength = new Parameter((NamedObj)this, "setPlatformBufferLength", (Token)new BooleanToken(false));
        this.setPlatformBufferLength.setTypeEquals((Type)BaseType.BOOLEAN);
        this.overwrite = new Parameter((NamedObj)this, "overwrite", (Token)new BooleanToken(true));
        this.overwrite.setTypeEquals((Type)BaseType.BOOLEAN);
        this.blockAwaitingDatagram = new Parameter((NamedObj)this, "blockAwaitingDatagram");
        this.blockAwaitingDatagram.setTypeEquals((Type)BaseType.BOOLEAN);
        this.blockAwaitingDatagram.setExpression("true");
        this.defaultReturnAddress = new Parameter((NamedObj)this, "defaultReturnAddress");
        this.defaultReturnAddress.setTypeEquals((Type)BaseType.STRING);
        this.defaultReturnAddress.setToken((Token)new StringToken("localhost"));
        this.defaultReturnSocketNumber = new Parameter((NamedObj)this, "defaultReturnSocketNumber");
        this.defaultReturnSocketNumber.setTypeEquals((Type)BaseType.INT);
        this.defaultReturnSocketNumber.setExpression("0");
        this.defaultOutput = new Parameter((NamedObj)this, "defaultOutput");
        this.defaultOutput.setTypeEquals((Type)new ArrayType((Type)BaseType.UNSIGNED_BYTE));
        this.defaultOutput.setExpression("{0ub}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.defaultReturnAddress) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultReturnAddress = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
                if (this._defaultReturnAddress.compareTo("224.0.0.1") >= 0 && this._defaultReturnAddress.compareTo("239.255.255.255") <= 0) {
                    this._multiCast = true;
                    try {
                        this._address = InetAddress.getByName(this._defaultReturnAddress);
                    }
                    catch (UnknownHostException ex) {
                        throw new IllegalActionException((Nameable)this, (Throwable)ex, "The default remote address specifies an unknown host");
                    }
                    if (this._multicastSocket != null) {
                        try {
                            this._multicastSocket.joinGroup(this._address);
                        }
                        catch (IOException exp) {
                            throw new IllegalActionException("can't join the multicast group" + exp);
                        }
                    }
                } else {
                    this._multiCast = false;
                    if (this._multicastSocket != null) {
                        try {
                            this._multicastSocket.leaveGroup(this._address);
                        }
                        catch (IOException exp) {
                            throw new IllegalActionException((Nameable)this, (Throwable)exp, "Disconnecting from the multicast group failed.");
                        }
                    }
                }
            }
        }
        if (attribute == this.defaultReturnSocketNumber) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultReturnSocketNumber = ((IntToken)this.defaultReturnSocketNumber.getToken()).intValue();
            }
        }
        if (attribute == this.defaultOutput) {
            Object object = this._syncDefaultOutputs;
            synchronized (object) {
                this._defaultOutputToken = this.output.getType().convert(this.defaultOutput.getToken());
            }
        }
        if (attribute == this.overwrite) {
            this._overwrite = ((BooleanToken)this.overwrite.getToken()).booleanValue();
            if (this._overwrite) {
                Object object = this._syncFireAndThread;
                synchronized (object) {
                    this._syncFireAndThread.notifyAll();
                }
            }
        } else if (attribute == this.blockAwaitingDatagram) {
            this._blockAwaitingDatagram = ((BooleanToken)this.blockAwaitingDatagram.getToken()).booleanValue();
            if (!this._blockAwaitingDatagram) {
                Object object = this._syncFireAndThread;
                synchronized (object) {
                    this._syncFireAndThread.notifyAll();
                }
            }
        } else {
            if (attribute == this.localSocketNumber) {
                DatagramReader datagramReader = this;
                synchronized (datagramReader) {
                    if (this._socket != null || this._multicastSocket != null) {
                        if (this._socketReadingThread == null) {
                            throw new IllegalActionException((Nameable)this, "thread == null");
                        }
                        if (!this._socketReadingThread.isAlive()) {
                            throw new IllegalActionException((Nameable)this, "thread is not Alive");
                        }
                        int newSocketNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
                        if (this._multicastSocket != null && newSocketNumber != this._multicastSocket.getLocalPort()) {
                            Object object = this._syncSocket;
                            synchronized (object) {
                                if (this._inReceive) {
                                    try {
                                        this._syncSocket.wait(444L);
                                    }
                                    catch (InterruptedException ex) {
                                        throw new IllegalActionException((Nameable)this, (Throwable)ex, "Interrupted while waiting");
                                    }
                                }
                                this._multicastSocket.close();
                                try {
                                    this._multicastSocket = new MulticastSocket(newSocketNumber);
                                }
                                catch (Exception ex) {
                                    throw new InternalErrorException((Nameable)this, (Throwable)ex, "Couldn't open new socket number " + newSocketNumber);
                                }
                                if (this._address != null) {
                                    try {
                                        this._multicastSocket.joinGroup(this._address);
                                    }
                                    catch (IOException exp) {
                                        throw new IllegalActionException("can't join the multicast group" + exp);
                                    }
                                }
                            }
                        }
                        if (this._socket != null && newSocketNumber != this._socket.getLocalPort()) {
                            Object object = this._syncSocket;
                            synchronized (object) {
                                if (this._inReceive) {
                                    try {
                                        this._syncSocket.wait(444L);
                                    }
                                    catch (InterruptedException ex) {
                                        throw new IllegalActionException((Nameable)this, (Throwable)ex, "Interrupted while waiting");
                                    }
                                }
                                this._socket.close();
                                try {
                                    this._socket = new DatagramSocket(newSocketNumber);
                                }
                                catch (SocketException ex) {
                                    throw new InternalErrorException((Nameable)this, (Throwable)ex, "Couldn't open new socket number " + newSocketNumber);
                                }
                            }
                        }
                    }
                }
            }
            if (attribute == this.actorBufferLength) {
                Object object = this._syncBufferLength;
                synchronized (object) {
                    this._actorBufferLength = ((IntToken)this.actorBufferLength.getToken()).intValue();
                }
            } else if (attribute == this.platformBufferLength && this._socket != null) {
                Object object = this._syncBufferLength;
                synchronized (object) {
                    ++this._ChangeRequestedToPlatformBufferLength;
                }
            } else {
                super.attributeChanged(attribute);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire() throws IllegalActionException {
        boolean useDefaultOutput;
        super.fire();
        int i = 0;
        while (i < this.trigger.getWidth()) {
            if (this.trigger.hasToken(i)) {
                this.trigger.get(i);
            }
            ++i;
        }
        Object object = this._syncFireAndThread;
        synchronized (object) {
            int bytesAvailable = 0;
            byte[] dataBytes = new byte[]{};
            while (this._blockAwaitingDatagram && this._packetsAlreadyAwaitingFire == 0) {
                try {
                    try {
                        this._fireIsWaiting = true;
                        this._syncFireAndThread.wait();
                        this._fireIsWaiting = false;
                    }
                    catch (InterruptedException ex) {
                        throw new InternalErrorException((Nameable)this, (Throwable)ex, "!!fire()'s wait interrupted!!");
                    }
                }
                finally {
                    if (this._stopFire) {
                        this._stopFire = false;
                        if (this._debugging) {
                            this._debug("return due to stopFire");
                        }
                        return;
                    }
                }
            }
            if (this._packetsAlreadyAwaitingFire != 0) {
                bytesAvailable = this._broadcastPacket.getLength();
                useDefaultOutput = bytesAvailable <= 0;
                dataBytes = this._broadcastPacket.getData();
                this._returnAddress = this._broadcastPacket.getAddress().getHostAddress();
                this._returnSocketNumber = this._broadcastPacket.getPort();
                --this._packetsAlreadyAwaitingFire;
            } else {
                useDefaultOutput = true;
            }
            if (!useDefaultOutput) {
                Token[] dataTokens = new Token[bytesAvailable];
                int j = 0;
                while (j < bytesAvailable) {
                    dataTokens[j] = new UnsignedByteToken(dataBytes[j]);
                    ++j;
                }
                this._outputToken = new ArrayToken((Type)BaseType.UNSIGNED_BYTE, dataTokens);
            }
            this._syncFireAndThread.notifyAll();
        }
        if (!useDefaultOutput) {
            this.returnAddress.broadcast((Token)new StringToken(this._returnAddress));
            this.returnSocketNumber.broadcast((Token)new IntToken(this._returnSocketNumber));
            this.output.broadcast(this._outputToken);
        } else if (this._defaultOutputToken == null) {
            if (this._debugging) {
                this._debug("DO NOT Broadcast ANY output (blank default)");
            }
        } else {
            if (this._debugging) {
                this._debug("Broadcast default outputs");
            }
            object = this._syncDefaultOutputs;
            synchronized (object) {
                this.returnAddress.broadcast((Token)new StringToken(this._defaultReturnAddress));
                this.returnSocketNumber.broadcast((Token)new IntToken(this._defaultReturnSocketNumber));
                this.output.broadcast(this._defaultOutputToken);
            }
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._packetsAlreadyAwaitingFire = 0;
        this._defaultReturnAddress = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
        this._multiCast = this._defaultReturnAddress.compareTo("224.0.0.1") >= 0 && this._defaultReturnAddress.compareTo("239.255.255.255") <= 0;
        int portNumber = ((IntToken)this.localSocketNumber.getToken()).intValue();
        if (portNumber < 0 || portNumber > 65535) {
            throw new IllegalActionException((Nameable)this, this.localSocketNumber + " is outside the required 0..65535 range");
        }
        if (this._debugging) {
            this._debug((Object)((Object)this) + "portNumber = " + portNumber);
        }
        if (this._multiCast) {
            try {
                if (this._debugging) {
                    this._debug("Trying to create a new multicast socket on port " + portNumber);
                }
                this._multicastSocket = new MulticastSocket(portNumber);
                if (this._debugging) {
                    this._debug("Multicast Socket created successfully!");
                }
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to create a new multicast socket on port " + portNumber);
            }
            String address = ((StringToken)this.defaultReturnAddress.getToken()).stringValue();
            try {
                this._address = InetAddress.getByName(address);
            }
            catch (UnknownHostException ex) {
                throw new IllegalActionException((Nameable)this, (Throwable)ex, "The default remote address specifies an unknown host");
            }
            try {
                this._multicastSocket.joinGroup(this._address);
            }
            catch (IOException exp) {
                throw new IllegalActionException("can't join the multicast group" + exp);
            }
        }
        try {
            if (this._debugging) {
                this._debug("Trying to create a new socket on port " + portNumber);
            }
            this._socket = new DatagramSocket(portNumber);
            if (this._debugging) {
                this._debug("Socket created successfully!");
            }
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to create a new socket on port " + portNumber);
        }
        this._ChangeRequestedToPlatformBufferLength = 1;
        this._socketReadingThread = new SocketReadingThread();
        this._socketReadingThread.start();
    }

    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container != this.getContainer()) {
            this.wrapup();
        }
        super.setContainer(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFire() {
        Object object = this._syncFireAndThread;
        synchronized (object) {
            if (this._fireIsWaiting) {
                this._stopFire = true;
                this._syncFireAndThread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        super.stop();
        Object object = this._syncFireAndThread;
        synchronized (object) {
            if (this._fireIsWaiting) {
                this._syncFireAndThread.notifyAll();
            }
        }
    }

    public void wrapup() throws IllegalActionException {
        if (this._socketReadingThread != null) {
            this._socketReadingThread.interrupt();
            this._socketReadingThread = null;
        } else if (this._debugging) {
            this._debug("socketReadingThread null at wrapup!?");
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        } else if (this._multicastSocket != null) {
            this._multicastSocket.close();
            this._multicastSocket = null;
        } else if (this._debugging) {
            this._debug("Socket null at wrapup!?");
        }
    }

    static /* synthetic */ Object access$0(DatagramReader datagramReader) {
        return datagramReader._syncBufferLength;
    }

    static /* synthetic */ int access$1(DatagramReader datagramReader) {
        return datagramReader._ChangeRequestedToPlatformBufferLength;
    }

    static /* synthetic */ void access$2(DatagramReader datagramReader, int n) {
        datagramReader._ChangeRequestedToPlatformBufferLength = n;
    }

    static /* synthetic */ boolean access$3(DatagramReader datagramReader) {
        return datagramReader._multiCast;
    }

    static /* synthetic */ MulticastSocket access$4(DatagramReader datagramReader) {
        return datagramReader._multicastSocket;
    }

    static /* synthetic */ DatagramSocket access$5(DatagramReader datagramReader) {
        return datagramReader._socket;
    }

    static /* synthetic */ DatagramPacket access$6(DatagramReader datagramReader) {
        return datagramReader._receivePacket;
    }

    static /* synthetic */ int access$7(DatagramReader datagramReader) {
        return datagramReader._receiveAllocated;
    }

    static /* synthetic */ int access$8(DatagramReader datagramReader) {
        return datagramReader._actorBufferLength;
    }

    static /* synthetic */ void access$9(DatagramReader datagramReader, DatagramPacket datagramPacket) {
        datagramReader._receivePacket = datagramPacket;
    }

    static /* synthetic */ void access$10(DatagramReader datagramReader, int n) {
        datagramReader._receiveAllocated = n;
    }

    static /* synthetic */ DatagramPacket access$11(DatagramReader datagramReader) {
        return datagramReader._broadcastPacket;
    }

    static /* synthetic */ void access$12(DatagramReader datagramReader, DatagramPacket datagramPacket) {
        datagramReader._broadcastPacket = datagramPacket;
    }

    static /* synthetic */ void access$13(DatagramReader datagramReader, int n) {
        datagramReader._broadcastAllocated = n;
    }

    static /* synthetic */ Object access$14(DatagramReader datagramReader) {
        return datagramReader._syncSocket;
    }

    static /* synthetic */ void access$15(DatagramReader datagramReader, boolean bl) {
        datagramReader._inReceive = bl;
    }

    static /* synthetic */ boolean access$16(DatagramReader datagramReader) {
        return datagramReader._inReceive;
    }

    static /* synthetic */ boolean access$17(DatagramReader datagramReader) {
        return ((NamedObj)datagramReader)._debugging;
    }

    static /* synthetic */ void access$18(DatagramReader datagramReader, String string) {
        datagramReader._debug(string);
    }

    static /* synthetic */ Object access$19(DatagramReader datagramReader) {
        return datagramReader._syncFireAndThread;
    }

    static /* synthetic */ int access$20(DatagramReader datagramReader) {
        return datagramReader._packetsAlreadyAwaitingFire;
    }

    static /* synthetic */ boolean access$21(DatagramReader datagramReader) {
        return datagramReader._overwrite;
    }

    static /* synthetic */ int access$22(DatagramReader datagramReader) {
        return datagramReader._broadcastAllocated;
    }

    static /* synthetic */ boolean access$23(DatagramReader datagramReader) {
        return datagramReader._fireIsWaiting;
    }

    static /* synthetic */ void access$24(DatagramReader datagramReader, int n) {
        datagramReader._packetsAlreadyAwaitingFire = n;
    }

    private class SocketReadingThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                var1_2 = DatagramReader.access$0(DatagramReader.this);
                synchronized (var1_2) {
                    if (DatagramReader.access$1(DatagramReader.this) > 0) {
                        DatagramReader.access$2(DatagramReader.this, -1);
                        try {
                            if (((BooleanToken)DatagramReader.this.setPlatformBufferLength.getToken()).booleanValue()) {
                                if (DatagramReader.access$3(DatagramReader.this)) {
                                    DatagramReader.access$4(DatagramReader.this).setReceiveBufferSize(((IntToken)DatagramReader.this.platformBufferLength.getToken()).intValue());
                                } else {
                                    DatagramReader.access$5(DatagramReader.this).setReceiveBufferSize(((IntToken)DatagramReader.this.platformBufferLength.getToken()).intValue());
                                }
                            }
                        }
                        catch (SocketException ex) {
                            System.out.println("Socket Ex." + ex.toString());
                        }
                        catch (IllegalActionException ex) {
                            System.out.println("getToken or setToken failedon platformBufferSize" + ex.toString());
                        }
                    }
                }
                var1_2 = DatagramReader.access$0(DatagramReader.this);
                synchronized (var1_2) {
                    if (DatagramReader.access$6(DatagramReader.this) == null || DatagramReader.access$7(DatagramReader.this) != DatagramReader.access$8(DatagramReader.this)) {
                        DatagramReader.access$9(DatagramReader.this, new DatagramPacket(new byte[DatagramReader.access$8(DatagramReader.this)], DatagramReader.access$8(DatagramReader.this)));
                        DatagramReader.access$10(DatagramReader.this, DatagramReader.access$8(DatagramReader.this));
                    }
                }
                if (DatagramReader.access$11(DatagramReader.this) == null) {
                    var1_2 = DatagramReader.access$0(DatagramReader.this);
                    synchronized (var1_2) {
                        DatagramReader.access$12(DatagramReader.this, new DatagramPacket(new byte[DatagramReader.access$8(DatagramReader.this)], DatagramReader.access$8(DatagramReader.this)));
                        DatagramReader.access$13(DatagramReader.this, DatagramReader.access$8(DatagramReader.this));
                    }
                }
                var1_2 = DatagramReader.access$14(DatagramReader.this);
                synchronized (var1_2) {
                    DatagramReader.access$15(DatagramReader.this, true);
                    // MONITOREXIT @DISABLED, blocks:[4, 36, 15] lbl51 : MonitorExitStatement: MONITOREXIT : var1_2
                    if (true) ** GOTO lbl87
                }
                do {
                    DatagramReader.access$6(DatagramReader.this).setLength(DatagramReader.access$8(DatagramReader.this));
                    if (DatagramReader.access$3(DatagramReader.this)) {
                        try {
                            DatagramReader.access$4(DatagramReader.this).receive(DatagramReader.access$6(DatagramReader.this));
                            var1_2 = DatagramReader.access$14(DatagramReader.this);
                            synchronized (var1_2) {
                                DatagramReader.access$15(DatagramReader.this, false);
                                DatagramReader.access$14(DatagramReader.this).notifyAll();
                            }
                        }
                        catch (IOException v5) {
                            v6 = DatagramReader.access$14(DatagramReader.this);
                            ** synchronized (v6)
lbl64:
                            // 1 sources

                        }
                        catch (NullPointerException v7) {
                            if (DatagramReader.access$17(DatagramReader.this)) {
                                DatagramReader.access$18(DatagramReader.this, "--!!--" + (DatagramReader.access$5(DatagramReader.this) == null));
                            }
                            return;
                        }
                    } else {
                        try {
                            DatagramReader.access$5(DatagramReader.this).receive(DatagramReader.access$6(DatagramReader.this));
                            var1_2 = DatagramReader.access$14(DatagramReader.this);
                            synchronized (var1_2) {
                                DatagramReader.access$15(DatagramReader.this, false);
                                DatagramReader.access$14(DatagramReader.this).notifyAll();
                            }
                        }
                        catch (IOException v9) {
                            v10 = DatagramReader.access$14(DatagramReader.this);
                            ** synchronized (v10)
lbl82:
                            // 1 sources

                        }
                        catch (NullPointerException v11) {
                            if (DatagramReader.access$17(DatagramReader.this)) {
                                DatagramReader.access$18(DatagramReader.this, "--!!--" + (DatagramReader.access$5(DatagramReader.this) == null));
                            }
                            return;
                        }
                    }
lbl87:
                    // 5 sources

                } while (DatagramReader.access$16(DatagramReader.this));
                ex = DatagramReader.access$19(DatagramReader.this);
                synchronized (ex) {
                    while (DatagramReader.access$20(DatagramReader.this) != 0 && !DatagramReader.access$21(DatagramReader.this)) {
                        try {
                            DatagramReader.access$19(DatagramReader.this).wait();
                        }
                        catch (InterruptedException v12) {
                            throw new RuntimeException("-interrupted-");
                        }
                    }
                    tmp = DatagramReader.access$11(DatagramReader.this);
                    DatagramReader.access$12(DatagramReader.this, DatagramReader.access$6(DatagramReader.this));
                    DatagramReader.access$9(DatagramReader.this, tmp);
                    tmpLength = DatagramReader.access$22(DatagramReader.this);
                    DatagramReader.access$13(DatagramReader.this, DatagramReader.access$7(DatagramReader.this));
                    DatagramReader.access$10(DatagramReader.this, tmpLength);
                    if (DatagramReader.access$20(DatagramReader.this) != 0) {
                        fireAtWillBeCalled = false;
                    } else if (DatagramReader.access$23(DatagramReader.this)) {
                        fireAtWillBeCalled = false;
                        DatagramReader.access$19(DatagramReader.this).notifyAll();
                        v13 = DatagramReader.this;
                        DatagramReader.access$24(v13, DatagramReader.access$20(v13) + 1);
                    } else {
                        fireAtWillBeCalled = true;
                        v14 = DatagramReader.this;
                        DatagramReader.access$24(v14, DatagramReader.access$20(v14) + 1);
                    }
                }
                if (!fireAtWillBeCalled) continue;
                try {
                    DatagramReader.this.getDirector().fireAtCurrentTime((Actor)DatagramReader.this);
                }
                catch (IllegalActionException ex) {
                    throw new RuntimeException("fireAtCurrentTime() threw an exception", ex);
                }
            }
        }
    }
}

