/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.Iterator;
import java.util.List;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLChangeRequest;

public class MultiInstanceComposite
extends TypedCompositeActor {
    public Parameter nInstances;
    public Parameter instance;
    private boolean _isMasterCopy = false;

    public MultiInstanceComposite(Workspace workspace) {
        super(workspace);
        this._initialize();
    }

    public MultiInstanceComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._initialize();
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        MultiInstanceComposite newObject = (MultiInstanceComposite)((Object)super.clone(workspace));
        newObject._isMasterCopy = this._isMasterCopy;
        return newObject;
    }

    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        if (!this._isMasterCopy) {
            return;
        }
        if (this.getDirector() == null || this.getDirector().getContainer() != this) {
            throw new IllegalActionException((Nameable)this, String.valueOf(this.getFullName()) + "No director.");
        }
        int N = ((IntToken)this.nInstances.getToken()).intValue();
        this.instance.setToken((Token)new IntToken(0));
        TypedCompositeActor container = (TypedCompositeActor)this.getContainer();
        int i = 1;
        while (i < N) {
            MultiInstanceComposite clone = (MultiInstanceComposite)container.getEntity(String.valueOf(this.getName()) + "_" + i);
            if (clone == null) {
                try {
                    clone = (MultiInstanceComposite)((Object)this._cloneClone(container.workspace()));
                }
                catch (CloneNotSupportedException ex) {
                    throw new IllegalActionException((Nameable)this, (Throwable)ex, "Clone failed.");
                }
                try {
                    clone.setName(String.valueOf(this.getName()) + "_" + i);
                    clone.setContainer((CompositeEntity)container);
                    clone.validateSettables();
                    if (this._debugging) {
                        this._debug("Cloned: " + clone.getFullName());
                    }
                    for (TypedIOPort port : this.portList()) {
                        TypedIORelation relation;
                        TypedIOPort newPort = (TypedIOPort)clone.getPort(port.getName());
                        List relations = port.linkedRelationList();
                        if (relations == null || relations.size() < 1) continue;
                        if (relations.size() > 1) {
                            throw new IllegalActionException((Nameable)port, "Can be linked to one relation only");
                        }
                        TypedIORelation oldRelation = relation = (TypedIORelation)relations.get(0);
                        Iterator otherPorts = relation.linkedPortList((Port)port).iterator();
                        boolean isRelationCreated = false;
                        boolean isPortLinked = false;
                        while (otherPorts.hasNext()) {
                            TypedIOPort otherPort = (TypedIOPort)otherPorts.next();
                            if (port.isOutput() && !otherPort.isMultiport()) {
                                throw new IllegalActionException((Nameable)this, String.valueOf(this.getFullName()) + ".preinitialize(): " + "output port " + port.getName() + "must be connected to a multi-port");
                            }
                            boolean isInsideLinked = otherPort.isInsideGroupLinked((Relation)oldRelation);
                            if (!(port.isInput() && (!isInsideLinked && otherPort.isOutput() || isInsideLinked && otherPort.isInput())) && (!port.isOutput() || (isInsideLinked || !otherPort.isInput()) && (!isInsideLinked || !otherPort.isOutput()))) continue;
                            if (otherPort.isMultiport()) {
                                if (!isRelationCreated) {
                                    relation = new TypedIORelation((CompositeEntity)container, "r_" + this.getName() + "_" + i + "_" + port.getName());
                                    relation.setPersistent(false);
                                    isRelationCreated = true;
                                    if (this._debugging) {
                                        this._debug(String.valueOf(port.getFullName()) + ": created relation " + relation.getFullName());
                                    }
                                }
                                otherPort.link((Relation)relation);
                            }
                            if (isPortLinked) continue;
                            newPort.link((Relation)relation);
                            isPortLinked = true;
                            if (!this._debugging) continue;
                            this._debug(String.valueOf(newPort.getFullName()) + ": linked to " + relation.getFullName());
                        }
                    }
                    clone.instance.setToken((Token)new IntToken(i));
                }
                catch (NameDuplicationException ex) {
                    throw new IllegalActionException((Nameable)this, (Throwable)ex, "couldn't clone/create");
                }
                clone.preinitialize();
            }
            ++i;
        }
    }

    public void wrapup() throws IllegalActionException {
        MultiInstanceComposite clone;
        super.wrapup();
        if (this._debugging) {
            this._debug(String.valueOf(this.getFullName()) + ".wrapup()");
        }
        if (!this._isMasterCopy) {
            return;
        }
        TypedCompositeActor container = (TypedCompositeActor)this.getContainer();
        if (container == null) {
            return;
        }
        int i = 1;
        while ((clone = (MultiInstanceComposite)container.getEntity(String.valueOf(this.getName()) + "_" + i)) != null) {
            ++i;
            for (TypedIOPort port : clone.portList()) {
                for (TypedIORelation relation : port.linkedRelationList()) {
                    TypedIOPort mirrorPort = (TypedIOPort)this.getPort(port.getName());
                    if (!port.isDeeplyConnected((ComponentPort)mirrorPort)) {
                        try {
                            if (this._debugging) {
                                this._debug("Deleting " + relation.getFullName());
                            }
                            relation.setContainer(null);
                            continue;
                        }
                        catch (NameDuplicationException ex) {
                            throw new InternalErrorException((Throwable)ex);
                        }
                    }
                    if (this._debugging) {
                        this._debug("Unlinking " + port.getFullName() + " from " + relation.getFullName());
                    }
                    port.unlink((Relation)relation);
                }
            }
            try {
                if (this._debugging) {
                    this._debug("Deleting " + clone.getFullName());
                }
                clone.setContainer(null);
            }
            catch (NameDuplicationException ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<group>\n");
        buffer.append("</group>");
        MoMLChangeRequest request = new MoMLChangeRequest((Object)this, (NamedObj)container, buffer.toString());
        request.setPersistent(false);
        this.requestChange((ChangeRequest)request);
    }

    private Object _cloneClone(Workspace workspace) throws CloneNotSupportedException {
        MultiInstanceComposite newObject = (MultiInstanceComposite)((Object)super.clone(workspace));
        newObject._isMasterCopy = false;
        newObject.setPersistent(false);
        try {
            new Attribute((NamedObj)newObject, "_hide");
        }
        catch (KernelException kernelException) {}
        return newObject;
    }

    private void _initialize() {
        this.setClassName("ptolemy.actor.lib.hoc.MultiInstanceComposite");
        try {
            this.nInstances = new Parameter((NamedObj)this, "nInstances", (Token)new IntToken(1));
            this.instance = new Parameter((NamedObj)this, "instance", (Token)new IntToken(0));
        }
        catch (Exception ex) {
            throw new InternalErrorException((Nameable)this, (Throwable)ex, "Problem setting up instances or nInstances parameter");
        }
        this._isMasterCopy = true;
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-20\" y=\"-10\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-18\" y=\"-8\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-25\" y=\"-15\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-23\" y=\"-13\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:red\"/>\n<rect x=\"-28\" y=\"-18\" width=\"56\" height=\"36\" style=\"fill:lightgrey\"/>\n<rect x=\"-15\" y=\"-10\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"-15\" y=\"2\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<rect x=\"5\" y=\"-4\" width=\"10\" height=\"8\" style=\"fill:white\"/>\n<line x1=\"-5\" y1=\"-6\" x2=\"0\" y2=\"-6\"/><line x1=\"-5\" y1=\"6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"-6\" x2=\"0\" y2=\"6\"/><line x1=\"0\" y1=\"0\" x2=\"5\" y2=\"0\"/></svg>\n");
    }
}

