/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.net.URL;
import java.util.LinkedList;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Executable;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.Typeable;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;

public class ApplyFilterOverArray
extends TypedAtomicActor
implements ExecutionListener {
    public TypedIOPort inputArray = new TypedIOPort((ComponentEntity)this, "inputArray", true, false);
    public TypedIOPort outputArray;
    public Parameter maxOutputLength;
    public FileParameter modelFileOrURL;
    protected NamedObj _model;
    private Manager _manager = null;
    private int _outputLength = 1;
    private transient Throwable _throwable = null;

    public ApplyFilterOverArray(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.inputArray.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.outputArray = new TypedIOPort((ComponentEntity)this, "outputArray", false, true);
        this.outputArray.setTypeSameAs((Typeable)this.inputArray);
        this.modelFileOrURL = new FileParameter((NamedObj)this, "modelFileOrURL");
        this.maxOutputLength = new Parameter((NamedObj)this, "maxOutputLength");
        this.maxOutputLength.setTypeEquals((Type)BaseType.INT);
        this.maxOutputLength.setExpression("1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.modelFileOrURL) {
            URL url = this.modelFileOrURL.asURL();
            if (url != null) {
                MoMLParser parser = new MoMLParser();
                try {
                    this._model = parser.parse(null, url);
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, (Throwable)ex, "Failed to read model.");
                }
                if (!(this._model instanceof CompositeActor)) return;
                this._manager = new Manager(this._model.workspace(), "Manager");
                ((CompositeActor)this._model).setManager(this._manager);
                if (!this._debugging) return;
                this._debug("** Created new manager.");
                return;
            }
            this._model = null;
            this._manager = null;
            this._throwable = null;
            return;
        }
        if (attribute == this.maxOutputLength) {
            IntToken length = (IntToken)this.maxOutputLength.getToken();
            if (length.intValue() <= 0) throw new IllegalActionException((Nameable)this, "output array length is less than or equal 0?!");
            this._outputLength = length.intValue();
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ApplyFilterOverArray newActor = (ApplyFilterOverArray)((Object)super.clone(workspace));
        newActor._manager = null;
        newActor._model = null;
        newActor._throwable = null;
        newActor.inputArray.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newActor.outputArray.setTypeSameAs((Typeable)newActor.inputArray);
        return newActor;
    }

    public synchronized void executionError(Manager manager, Throwable throwable) {
        this._throwable = throwable;
        manager.removeDebugListener((DebugListener)this);
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void executionFinished(Manager manager) {
        manager.removeDebugListener((DebugListener)this);
        ((Object)((Object)this)).notifyAll();
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this._model instanceof CompositeActor) {
            Director director;
            CompositeActor executable = (CompositeActor)this._model;
            this._manager = executable.getManager();
            if (this._manager == null) {
                throw new InternalErrorException("No manager!");
            }
            if (this._debugging) {
                this._manager.addDebugListener((DebugListener)this);
                director = executable.getDirector();
                if (director != null) {
                    director.addDebugListener((DebugListener)this);
                }
            } else {
                this._manager.removeDebugListener((DebugListener)this);
                director = executable.getDirector();
                if (director != null) {
                    director.removeDebugListener((DebugListener)this);
                }
            }
            int i = 0;
            int j = 0;
            LinkedList<Token> list = new LinkedList<Token>();
            ArrayToken array = (ArrayToken)this.inputArray.get(0);
            while (i < this._outputLength && j < array.length()) {
                Token t = array.getElement(j);
                this._updateParameter(t);
                if (this._debugging) {
                    this._debug("** Executing filter model.");
                }
                try {
                    this._manager.execute();
                }
                catch (KernelException ex) {
                    throw new IllegalActionException((Nameable)this, (Throwable)ex, "Execution failed.");
                }
                if (this._getResult()) {
                    ++i;
                    list.add(t);
                }
                ++j;
            }
            Token[] result = new Token[list.size()];
            i = 0;
            while (i < list.size()) {
                result[i] = (Token)list.get(i);
                ++i;
            }
            this.outputArray.send(0, (Token)new ArrayToken(array.getElementType(), result));
        }
    }

    public void managerStateChanged(Manager manager) {
        if (this._debugging) {
            this._debug("Referenced model manager state: " + manager.getState());
        }
    }

    public boolean postfire() throws IllegalActionException {
        if (this._manager != null) {
            this._manager.removeExecutionListener((ExecutionListener)this);
            this._manager = null;
        }
        return super.postfire();
    }

    public void stop() {
        if (this._model instanceof Executable) {
            ((Executable)this._model).stop();
        }
        super.stop();
    }

    public void stopFire() {
        if (this._model instanceof Executable) {
            ((Executable)this._model).stopFire();
        }
        super.stopFire();
    }

    public void terminate() {
        if (this._model instanceof Executable) {
            ((Executable)this._model).terminate();
        }
        super.terminate();
    }

    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._throwable != null) {
            Throwable throwable = this._throwable;
            this._throwable = null;
            throw new IllegalActionException((Nameable)this, throwable, "Background run threw an exception");
        }
    }

    private void _updateParameter(Token t) throws IllegalActionException {
        Attribute attribute = this._model.getAttribute("inputArrayElement");
        if (attribute instanceof Variable) {
            if (this._debugging) {
                this._debug("** Transferring input to parameter inputArrayElement.");
            }
            ((Variable)attribute).setToken(t);
        } else if (attribute instanceof Settable) {
            if (this._debugging) {
                this._debug("** Transferring input as string to inputArrayElement.");
            }
            ((Settable)attribute).setExpression(t.toString());
        } else {
            throw new IllegalActionException((Nameable)this, "The specified model does not have an inputArrayElement parameter.");
        }
    }

    private boolean _getResult() throws IllegalActionException {
        Attribute attribute = this._model.getAttribute("evaluatedValue");
        if (attribute instanceof Variable) {
            Token t = ((Variable)attribute).getToken();
            return ((BooleanToken)t).booleanValue();
        }
        if (attribute instanceof Settable) {
            BooleanToken t = new BooleanToken(((Settable)attribute).getExpression());
            return t.booleanValue();
        }
        throw new IllegalActionException((Nameable)this, "The specified model does not have an evaluatedValue parameter.");
    }
}

