/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.FixToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixToFix
extends Converter {
    public Parameter precision;
    public StringAttribute rounding;
    public StringAttribute overflow;
    private FixPointQuantization _quantization = new FixPointQuantization(new Precision(0, 0), (Overflow)Overflow.SATURATE, (Rounding)Rounding.NEAREST);

    public FixToFix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeAtMost((Type)BaseType.UNSIZED_FIX);
        this.output.setTypeEquals((Type)BaseType.UNSIZED_FIX);
        this.precision = new Parameter((NamedObj)this, "precision");
        this.precision.setTypeEquals((Type)BaseType.INT_MATRIX);
        this.precision.setExpression("[16, 2]");
        this.rounding = new StringAttribute((NamedObj)this, "rounding");
        this.rounding.setExpression("nearest");
        this.overflow = new StringAttribute((NamedObj)this, "overflow");
        this.overflow.setExpression("saturate");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.precision) {
            IntMatrixToken token = (IntMatrixToken)this.precision.getToken();
            if (token.getRowCount() != 1 || token.getColumnCount() != 2) {
                throw new IllegalActionException((Nameable)this, "Invalid precision (not a 1 by 2 matrix).");
            }
            Precision precision = new Precision(token.getElementAt(0, 0), token.getElementAt(0, 1));
            this._quantization = this._quantization.setPrecision(precision);
            if (this._quantization.getOverflow() == Overflow.GROW) {
                this.output.setTypeEquals((Type)BaseType.UNSIZED_FIX);
            } else {
                this.output.setTypeEquals((Type)new FixType(this._quantization.getPrecision()));
            }
        } else if (attribute == this.rounding) {
            Rounding r = Rounding.getName((String)this.rounding.getExpression());
            this._quantization = this._quantization.setRounding(r);
        } else if (attribute == this.overflow) {
            Overflow o = Overflow.forName((String)this.overflow.getExpression());
            this._quantization = this._quantization.setOverflow(o);
            if (this._quantization.getOverflow() == Overflow.GROW) {
                this.output.setTypeEquals((Type)BaseType.UNSIZED_FIX);
            } else {
                this.output.setTypeEquals((Type)new FixType(this._quantization.getPrecision()));
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FixToFix newObject = (FixToFix)((Object)super.clone(workspace));
        newObject.input.setTypeAtMost((Type)BaseType.UNSIZED_FIX);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        FixToken in = (FixToken)this.input.get(0);
        FixPoint fixValue = in.fixValue().quantize((Quantization)this._quantization);
        FixToken result = new FixToken(fixValue);
        this.output.send(0, (Token)result);
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

