/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class ConvolutionalCoder
extends Transformer {
    public Parameter polynomialArray;
    public Parameter initialState;
    public Parameter uncodedRate = new Parameter((NamedObj)this, "uncodedRate");
    private Parameter _inputRate;
    private Parameter _outputRate;
    private int _shiftReg;
    private int _latestShiftReg;
    private int _inputNumber;
    private int[] _mask;
    private int _maskNumber;
    private int _maxPolyValue;
    private transient boolean _inputNumberInvalid = true;

    public ConvolutionalCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.uncodedRate.setTypeEquals((Type)BaseType.INT);
        this.uncodedRate.setExpression("1");
        this.polynomialArray = new Parameter((NamedObj)this, "polynomialArray");
        this.polynomialArray.setTypeEquals((Type)new ArrayType((Type)BaseType.INT));
        this.polynomialArray.setExpression("{05, 07}");
        this.initialState = new Parameter((NamedObj)this, "initialState");
        this.initialState.setTypeEquals((Type)BaseType.INT);
        this.initialState.setExpression("0");
        this.input.setTypeEquals((Type)BaseType.BOOLEAN);
        this._inputRate = new Parameter((NamedObj)this.input, "tokenConsumptionRate");
        this._inputRate.setExpression("1");
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        this._outputRate = new Parameter((NamedObj)this.output, "tokenProductionRate");
        this._outputRate.setExpression("1");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.uncodedRate) {
            this._inputNumber = ((IntToken)this.uncodedRate.getToken()).intValue();
            if (this._inputNumber < 1) {
                throw new IllegalActionException((Nameable)this, "inputLength must be non-negative.");
            }
            this._inputNumberInvalid = true;
            this._inputRate.setToken((Token)new IntToken(this._inputNumber));
        } else if (attribute == this.polynomialArray) {
            ArrayToken maskToken = (ArrayToken)this.polynomialArray.getToken();
            this._maskNumber = maskToken.length();
            this._mask = new int[this._maskNumber];
            this._maxPolyValue = 0;
            int i = 0;
            while (i < this._maskNumber) {
                this._mask[i] = ((IntToken)maskToken.getElement(i)).intValue();
                if (this._mask[i] <= 0) {
                    throw new IllegalActionException((Nameable)this, "Polynomial is required to be strictly positive.");
                }
                if (this._mask[i] > this._maxPolyValue) {
                    this._maxPolyValue = this._mask[i];
                }
                ++i;
            }
            this._inputNumberInvalid = true;
            this._outputRate.setToken((Token)new IntToken(this._maskNumber));
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this._inputNumberInvalid) {
            if (this._inputNumber >= this._maskNumber) {
                throw new IllegalActionException((Nameable)this, "Output rate should be larger than input rate.");
            }
            if (1 << this._inputNumber > this._maxPolyValue) {
                throw new IllegalActionException((Nameable)this, "The highest order of all polynomials is too low.");
            }
            this._inputNumberInvalid = false;
        }
        this._latestShiftReg = this._shiftReg;
        Token[] inputToken = this.input.get(0, this._inputNumber);
        int reg = this._latestShiftReg;
        int i = 0;
        while (i < this._inputNumber) {
            reg <<= 1;
            BooleanToken input = (BooleanToken)inputToken[i];
            reg |= input.booleanValue() ? 1 : 0;
            ++i;
        }
        this._latestShiftReg = reg;
        BooleanToken[] result = new BooleanToken[this._maskNumber];
        int[] parity = this._calculateParity(this._mask, this._maskNumber, reg);
        int i2 = 0;
        while (i2 < this._maskNumber) {
            result[i2] = parity[i2] == 1 ? BooleanToken.TRUE : BooleanToken.FALSE;
            ++i2;
        }
        this.output.broadcast((Token[])result, result.length);
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._latestShiftReg = this._shiftReg = ((IntToken)this.initialState.getToken()).intValue();
    }

    public boolean postfire() throws IllegalActionException {
        this._shiftReg = this._latestShiftReg;
        return super.postfire();
    }

    private int[] _calculateParity(int[] mask, int maskNumber, int reg) {
        int[] parity = new int[maskNumber];
        int i = 0;
        while (i < maskNumber) {
            int masked = mask[i] & reg;
            parity[i] = 0;
            while (masked > 0) {
                parity[i] = parity[i] ^ masked & 1;
                masked >>= 1;
            }
            ++i;
        }
        return parity;
    }
}

