#!/usr/bin/env python
'''
From double dataset generate other classes

$ python fromdouble.py ../DoubleDataset.java

'''

from markers import transmutate #@UnresolvedImport

# default dataset definition
defds = { "DoubleDataset":["FLOAT64", "Double", "double", "getElementDouble", "toReal", "%.8g",
"NaN"] }

defkey = defds.keys()[0]

# all other dataset definitions
fds = { "FloatDataset":["FLOAT32", "Float", "float", "getElementDouble", "(float) toReal", "%.8g",
"NaN"] }

allds = { 
"IntegerDataset":["INT32", "Integer", "int", "getElementLong", "(int) toLong", "%d",
"MIN_VALUE"],
"LongDataset":["INT64", "Long", "long", "getElementLong", "toLong", "%d",
"MIN_VALUE"],
"ShortDataset":["INT16", "Short", "short", "getElementLong", "(short) toLong", "%d",
"MIN_VALUE"],
"ByteDataset":["INT8", "Byte", "byte", "getElementLong", "(byte) toLong", "%d",
"MIN_VALUE"]
 }

bds = { "BooleanDatasetBase":["BOOL", "Boolean", "boolean", "getElementBoolean", "toBoolean", "%b",
"FALSE"] }

def generateclass(dclass):
    handlers  = [ transmutate(__file__, defkey, defds[defkey], d, fds[d], True) for d in fds ]
    handlers += [ transmutate(__file__, defkey, defds[defkey], d, allds[d], False) for d in allds ]
    handlers += [ transmutate(__file__, defkey, defds[defkey], d, bds[d], False, True) for d in bds ]
    files  = [ open(d + ".java", "w") for d in fds ]
    files += [ open(d + ".java", "w") for d in allds ]
    files += [ open(d + ".java", "w") for d in bds ]
    ncls = len(files)

    while True:
        l = dclass.readline()
        if not l:
            break
        for n in range(ncls):
            nl = handlers[n].processline(l)
            if nl != None:
                print >> files[n], nl

if __name__ == '__main__':
    import sys
    if len(sys.argv) > 1:
        fname = sys.argv[1]
    else:
        fname = "DoubleDataset.java"

    dclass_file = open(fname, 'r')

    generateclass(dclass_file)
