'''
I/O  package
'''

import scisoftpy as _np

_toList = _np.toList
_asDList = _np.asDatasetList
_asDDict = _np.asDatasetDict

from uk.ac.diamond.scisoft.analysis.io import PNGLoader as _pngload
from uk.ac.diamond.scisoft.analysis.io import PNGSaver as _pngsave
from uk.ac.diamond.scisoft.analysis.io import PNGScaledSaver as _pngscaledsave
from uk.ac.diamond.scisoft.analysis.io import JPEGLoader as _jpegload
from uk.ac.diamond.scisoft.analysis.io import JPEGSaver as _jpegsave
from uk.ac.diamond.scisoft.analysis.io import JPEGScaledSaver as _jpegscaledsave
from uk.ac.diamond.scisoft.analysis.io import TIFFImageLoader as _tiffload
from uk.ac.diamond.scisoft.analysis.io import JavaImageLoader as _javaload
from uk.ac.diamond.scisoft.analysis.io import JavaImageSaver as _javasave
from uk.ac.diamond.scisoft.analysis.io import ADSCImageLoader as _adscload

try:
    from uk.ac.diamond.scisoft.analysis.io import CBFLoader as _cbfload
except:
    import sys
    print >> sys.stderr, "Could not import CBF loader"
    print >> sys.stderr, "Problem with path for dynamic/shared library or product bundling"
    _cbfload = None

from uk.ac.diamond.scisoft.analysis.io import CrysalisLoader as _crysload
from uk.ac.diamond.scisoft.analysis.io import MARLoader as _marload
from uk.ac.diamond.scisoft.analysis.io import PilatusTiffLoader as ptiffload
from uk.ac.diamond.scisoft.analysis.io import SRSLoader as _srsload
#from gda.analysis.io import RawBinaryLoader as _rawbinload
#from gda.analysis.io import RawBinarySaver as _rawbinsave
from uk.ac.diamond.scisoft.analysis.io import RawBinarySaver as _rawbinsave
from uk.ac.diamond.scisoft.analysis.io import RawBinaryLoader as _rawbinload
from gda.analysis.io import RawOutput as _rawtextsave
from uk.ac.diamond.scisoft.analysis.io import XMapLoader as _xmapload
from gda.analysis.io import ScanFileHolderException as _scanfhexception
from uk.ac.diamond.scisoft.analysis.io import DataHolder as  _dholder

__iformats = { "png": _pngload, "gif": _javaload,
               "jpeg": _jpegload, "jpg": _jpegload,
               "tiff": _tiffload, "tif": _tiffload,
               "adsc": _adscload, "img": _adscload,
               "cbf": _cbfload, "crys":_crysload,
               "mar": _marload, "mccd": _marload,
               "pil": ptiffload,
               "srs": _srsload,
               "binary": _rawbinload, "xmap": _xmapload #, "nxs": NexusLoader, "h5": NexusLoader
               }
__colourclasses = [ _pngload, _javaload, _jpegload, _tiffload ]
__loaders = [ _pngload, _adscload, _crysload, _marload, _cbfload, _xmapload, _rawbinload, _srsload ]
__oformats = { "png": _pngsave, "gif": _javasave, "jpeg": _jpegsave, "tiff": _javasave, "text": _rawtextsave,
              "binary": _rawbinsave }

__soformats = { "png": _pngscaledsave, "jpeg": _jpegscaledsave }

def _findsuffix(name, formats):
    bits = name.split('.')
    if len(bits) > 1:
        suffix = bits[-1].lower()
        if suffix in formats:
            return suffix
    return None

def load(name, formats=None, asdict=False, withmetadata=False, ascolour=False):
    '''Load a file and return a list of datasets (or a dictionary of datasets) and
    optionally a dictionary of metadata items

    formats -- list of formats to try. Supported input formats:
        png, gif, jpeg, tiff
        adsc, crysalis, mar, pilatus -> image detectors
        cbf
        xmap
        srs
        binary -> raw

    '''
    try:
        f = open(name)
        f.close()
    except:
        raise ValueError, 'File %s does not exist' % name
        
    if formats is None:
        # parse name to find extension and match with loader
        suf = _findsuffix(name, __iformats)
        if suf:
            formats = [suf]

    if formats: # remove unsupported
        for f in formats:
            if f not in __iformats:
                formats.remove(f)

    lfh = None
    if not formats:
        # need to attempt to use all supported formats
        for l in __loaders:
            if not l:
                continue

            try:
                if l in __colourclasses:
                    lfh = l(name, not ascolour).loadFile()
                else:
                    lfh = l(name).loadFile()
                break
            except _scanfhexception, e:
                print e
                continue
    else:
        for f in formats:
            loader = __iformats[f]

            if not loader:
                continue

            try:
                if loader in __colourclasses:
                    lfh = loader(name, not ascolour).loadFile()
                else:
                    lfh = loader(name).loadFile()
                break
            except _scanfhexception, e:
                print e
                continue

    if lfh is None:
        raise ValueError, "Cannot load file"

    if asdict:
        if withmetadata:
            return _asDDict(lfh.getMap()), lfh.getMetadata() 
        return _asDDict(lfh.getMap())
    else:
        if withmetadata:
            return _asDList(lfh.getList()), lfh.getMetadata() 
        return _asDList(lfh.getList())

def save(name, data, format=None, range=(), autoscale=False):
    '''Save a (list of) datasets with optional scaling range

    Supported output formats:
        png, gif, jpeg, tiff
        binary -> raw
        text -> raw

    '''
    saver = None
    try:
        if len(range) > 0 or autoscale:
            if not autoscale:
                if len(range) != 2:
                    raise ValueError, "Range has to be a pair of limits (lower, upper)"
                if range[0] >= range[1]:
                    raise ValueError, "Given minimum must be less than maximum"
            if format is None:
                format = _findsuffix(name, __soformats)
            print "scaled save format", format
            sclass = __soformats[format]
            if autoscale:
                saver = sclass(name)
            else:
                saver = sclass(name, range[0], range[1])
        else:
            if format is None:
                format = _findsuffix(name, __oformats)
            print "save format", format, "as ", name
            sclass = __oformats[format]
            saver = sclass(name)
    except KeyError:
        raise ValueError, "Format not supported"

    dh = _dholder()
    if format == "binary":
        for d in _np.asIterable(data):
            dh.addDataset(d.name, d)
    else:
        for d in _toList(data):
            dh.addDataset(d.name, d)
    saver.saveFile(dh)

from uk.ac.diamond.scisoft.analysis.io import NexusLoader as _nxsloader #@UnresolvedImport
from gda.data.nexus.tree.NexusTreeNodeSelection import SKIP as _skip
from gda.data.nexus.tree.NexusTreeNodeSelection import createTreeForAllNXEntries as _createtree

def loadnexus(name):
    '''Load a NeXus file and return a NeXus tree'''
    st = _createtree()
    nxloader = _nxsloader(name, _skip, st, None)
    lfh = nxloader.loadFile()
    return lfh.getNexusTree()


import os as _os
import os.path as _path
#from scisoftpy import ndarraywrapped as _npwrapped

class srsrun(object):
    '''Represent a run from an SRS file'''
    def __init__(self, run, datadir=None, ending=".dat"):
        '''Specify a run number (or file name) and data directory

        Arguments:
        run -- integer (negative values mean relative to last run number) or filename
        datadir -- data directory
        ending -- file name ending, defaults to ".dat"
        '''
#        try:
#            self.run = int(run)
#            if run <= 0:
#                try:
#                    import gda.data.NumTracker as NumTracker #@UnresolvedImport
#                    self.run += NumTracker().getCurrentFileNumber()
#                except ImportError:
#                    print "No gda configuration access so cannot support negative numbers"
#                    raise
#
#            if datadir is None:
#                datadir = self._getgdadir()
#            self.srsfile = _path.join(datadir, self.run + ending)
#            if not _os.access(self.srsfile, _os.R_OK):
#                self.srsfile = self._findsrs(datadir, ending)
#        except ValueError:
#            if isinstance(run, str):
#                if run.startswith('/'):
#                    datadir = ""
#                else:
#                    if datadir is None:
#                        datadir = self._getgdadir()
#                self.srsfile = _path.join(datadir, run)
#            else:
#                print "run must be a number or a file path"
        self.run = int(run)
        self.srsfile = self._findsrs(datadir, ending)

        print 'file is', self.srsfile
        self.basedir = _path.dirname(self.srsfile)
        dh = _srsload(self.srsfile).loadFile()
        self.metadata = dh.getMetadata()[0]
        self.data = _asDList(dh.getList())

        # build dictionary to map column names to list index
        self.names = {}
        for i in range(len(dh.names)):
            self.names[dh.names[i]] = i

    def _getgdadir(self):
        try:
            import gda.data.PathConstructor as PathConstructor
            datadir = PathConstructor.createFromDefaultProperty()
        except ImportError:
            print "No gda configuration access so please specify data directory"
            raise
        return datadir

    def _findsrs(self, datadir, ending=".dat"):
        '''Find an SRS file by looking down two layers from given data directory'''
        fname = "%d%s" % (self.run, ending)
        print 'looking for', fname
        dirs = _os.listdir(datadir)
        dirs = [ _path.join(datadir, d) for d in dirs if _path.isdir(_path.join(datadir, d)) ]
        dirs.sort()
        print dirs
        for d in dirs:
            ldirs = _os.listdir(d)
            ldirs = [ l for l in ldirs if _path.isdir(_path.join(d, l)) ]
            ldirs.sort(reverse=True)
            print ' ', d, ldirs
            for l in ldirs:
                file = _path.join(d, l, fname)
                if _os.access(file, _os.R_OK):
                    return file
        return None

    def __str__(self):
        return "\t".join(self.names)

    def __contains__(self, key):
        return key in self.names

    def __getitem__(self, key):
        '''Retrieve a column as a dataset'''
        if isinstance(key, str):
            key = self.names[key]
        return self.data[key]

    def getmetafloat(self, key):
        '''Retrieve an item of metadata as a float'''
        value = self.metadata[key]
        return float(value)

