/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.model.AbstractApiComponent;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;

public class SystemLibraryApiComponent
extends AbstractApiComponent {
    protected String[] fExecEnv;
    protected LibraryLocation[] fLibraries;
    protected String fLocation;
    protected String[] fSystemPackages;
    protected String fVersion;

    protected SystemLibraryApiComponent(IApiBaseline profile) {
        super(profile);
    }

    public SystemLibraryApiComponent(IApiBaseline profile, ExecutionEnvironmentDescription description, String[] systemPackages) throws CoreException {
        super(profile);
        this.init(description);
        this.fSystemPackages = systemPackages;
    }

    protected IApiDescription createApiDescription() throws CoreException {
        ApiDescription api = new ApiDescription(this.getId());
        int i = 0;
        while (i < this.fSystemPackages.length) {
            IPackageDescriptor pkg = Factory.packageDescriptor(this.fSystemPackages[i]);
            api.setVisibility(pkg, 1);
            ++i;
        }
        String[] packageNames = this.getPackageNames();
        int i2 = 0;
        while (i2 < packageNames.length) {
            if (packageNames[i2].startsWith("java.")) {
                IPackageDescriptor pkg = Factory.packageDescriptor(packageNames[i2]);
                api.setVisibility(pkg, 1);
            }
            ++i2;
        }
        return api;
    }

    protected IApiFilterStore createApiFilterStore() {
        return null;
    }

    protected List createApiTypeContainers() throws CoreException {
        ArrayList<ArchiveApiTypeContainer> libs = new ArrayList<ArchiveApiTypeContainer>(this.fLibraries.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation lib = this.fLibraries[i];
            libs.add(new ArchiveApiTypeContainer(this, lib.getSystemLibraryPath().toOSString()));
            ++i;
        }
        return libs;
    }

    public String[] getExecutionEnvironments() {
        return this.fExecEnv;
    }

    public String getId() {
        return this.fExecEnv[0];
    }

    public String getLocation() {
        return this.fLocation;
    }

    public IRequiredComponentDescription[] getRequiredComponents() {
        return new IRequiredComponentDescription[0];
    }

    public String getVersion() {
        return this.fVersion;
    }

    private void init(ExecutionEnvironmentDescription description) throws CoreException {
        this.fLibraries = description.getLibraryLocations();
        this.fExecEnv = new String[]{description.getProperty("-Dee.class.library.level")};
        this.fVersion = this.fExecEnv[0];
        this.setName(this.fExecEnv[0]);
        this.fLocation = description.getProperty("-Djava.home");
    }

    public boolean isSourceComponent() {
        return false;
    }

    public boolean isSystemComponent() {
        return true;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean hasFragments() {
        return false;
    }

    public String getOrigin() {
        return null;
    }

    public boolean hasApiDescription() {
        return false;
    }

    public IApiDescription getSystemApiDescription(int eeValue) throws CoreException {
        return null;
    }

    public String[] getLowestEEs() {
        return null;
    }

    public ResolverError[] getErrors() throws CoreException {
        return null;
    }
}

