/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.EntityLibrary;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.tree.FullTreeModel;

public class VisibleTreeModel
extends FullTreeModel {
    private Workspace _workspace;
    private long _workspaceAttributeVersion;
    private long _workspacePortVersion;
    private long _workspaceRelationVersion;
    private Map _attributeListCache = new HashMap();
    private Map _portListCache = new HashMap();
    private Map _relationListCache = new HashMap();

    public VisibleTreeModel(CompositeEntity root) {
        super(root);
        this._workspace = root.workspace();
        this._workspaceAttributeVersion = this._workspace.getVersion();
    }

    public boolean isLeaf(Object object) {
        Attribute marker;
        if (object instanceof EntityLibrary) {
            return false;
        }
        if (object instanceof CompositeEntity && (marker = ((CompositeEntity)object).getAttribute("_libraryMarker")) == null) {
            return true;
        }
        return super.isLeaf(object);
    }

    protected List _attributes(Object object) {
        LinkedList<Object> result;
        if (!(object instanceof NamedObj)) {
            return Collections.EMPTY_LIST;
        }
        long version = this._workspace.getVersion();
        if (version == this._workspaceAttributeVersion && (result = this._attributeListCache.get(object)) != null) {
            return result;
        }
        result = new LinkedList();
        for (NamedObj attribute : ((NamedObj)object).attributeList()) {
            if (!this._isVisible(attribute)) continue;
            result.add(attribute);
        }
        this._attributeListCache.put(object, result);
        this._workspaceAttributeVersion = this._workspace.getVersion();
        return result;
    }

    protected boolean _isVisible(NamedObj object) {
        List iconList = object.attributeList(EditorIcon.class);
        return iconList.size() > 0 || object.getAttribute("_iconDescription") != null || object.getAttribute("_smallIconDescription") != null;
    }

    protected List _ports(Object object) {
        LinkedList<Object> result;
        if (!(object instanceof Entity)) {
            return Collections.EMPTY_LIST;
        }
        long version = this._workspace.getVersion();
        if (version == this._workspacePortVersion && (result = this._portListCache.get(object)) != null) {
            return result;
        }
        result = new LinkedList();
        for (NamedObj port : ((Entity)object).portList()) {
            if (!this._isVisible(port)) continue;
            result.add(port);
        }
        this._portListCache.put(object, result);
        this._workspacePortVersion = this._workspace.getVersion();
        return result;
    }

    protected List _relations(Object object) {
        LinkedList<Object> result;
        if (!(object instanceof CompositeEntity)) {
            return Collections.EMPTY_LIST;
        }
        long version = this._workspace.getVersion();
        if (version == this._workspaceRelationVersion && (result = this._relationListCache.get(object)) != null) {
            return result;
        }
        result = new LinkedList();
        for (NamedObj relation : ((CompositeEntity)object).relationList()) {
            if (!this._isVisible(relation)) continue;
            result.add(relation);
        }
        this._relationListCache.put(object, result);
        this._workspaceRelationVersion = this._workspace.getVersion();
        return result;
    }
}

