/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.toolbox.GraphicsParser;
import diva.util.java2d.PaintedObject;
import diva.util.java2d.PaintedString;
import diva.util.xml.XmlElement;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GraphicElement {
    private static final PaintedString _errorObject = new PaintedString("ERROR!");
    private Map _attributes = new HashMap();
    private String _type;
    private String _label;

    public GraphicElement(String type) {
        this._type = type;
        this._label = "";
    }

    public Set attributeNameSet() {
        return this._attributes.keySet();
    }

    public void exportMoML(Writer out, String prefix) throws IOException {
        XmlElement element = new XmlElement(this._type, this._attributes);
        element.setPCData(this._label);
        element.writeXML(out, prefix);
    }

    public String getAttribute(String name) {
        return (String)this._attributes.get(name);
    }

    public String getLabel() {
        return this._label;
    }

    public PaintedObject getPaintedObject() {
        String label;
        String type = this.getType();
        PaintedObject paintedObject = GraphicsParser.createPaintedObject((String)type, (Map)this._attributes, (String)(label = this.getLabel()));
        if (paintedObject == null) {
            return _errorObject;
        }
        return paintedObject;
    }

    public String getType() {
        return this._type;
    }

    public boolean containsAttribute(String name) {
        return this._attributes.containsKey(name);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void setAttribute(String name, String value) {
        this._attributes.put(name, value);
    }

    public void setLabel(String name) {
        this._label = name;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{");
        result.append(String.valueOf(this.getClass().getName()) + " {" + this._type + "}" + " attributes {");
        Set attributeSet = this.attributeNameSet();
        for (String p : attributeSet) {
            result.append(" {" + p + "=" + this.getAttribute(p) + "}");
        }
        result.append("} label {" + this.getLabel() + "}}");
        return result.toString();
    }
}

