/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.CanvasLayer;
import diva.canvas.CanvasPane;
import diva.canvas.Figure;
import diva.canvas.event.LayerEvent;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.JGraph;
import diva.gui.toolbox.JContextMenu;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NamedObj;

public class FigureAction
extends AbstractAction {
    public static final SourceType CANVAS_TYPE = new SourceType("canvas");
    public static final SourceType CONTEXTMENU_TYPE = new SourceType("contextmenu");
    public static final SourceType TOOLBAR_TYPE = new SourceType("toolbar");
    public static final SourceType MENUBAR_TYPE = new SourceType("menubar");
    public static final SourceType HOTKEY_TYPE = new SourceType("hotkey");
    private Figure _figure = null;
    private Frame _frame = null;
    private SourceType _sourceType = null;
    private NamedObj _target = null;
    private int _x = 0;
    private int _y = 0;

    public FigureAction(String name) {
        super(name);
    }

    public void actionPerformed(ActionEvent e) {
        CanvasPane canvasPane;
        Object object;
        GraphModel model;
        GraphController controller;
        CanvasLayer layer;
        Object source = e.getSource();
        Component parent = null;
        if (source instanceof LayerEvent) {
            this._sourceType = CANVAS_TYPE;
            LayerEvent event = (LayerEvent)source;
            layer = event.getLayerSource();
            GraphPane pane = (GraphPane)layer.getCanvasPane();
            controller = pane.getGraphController();
            model = controller.getGraphModel();
            this._figure = event.getFigureSource();
            if (this._figure == null) {
                this._target = (NamedObj)model.getRoot();
            } else {
                object = this._figure.getUserObject();
                this._target = (NamedObj)model.getSemanticObject(object);
            }
            this._x = event.getX();
            this._y = event.getY();
            canvasPane = layer.getCanvasPane();
            parent = canvasPane.getCanvas();
        } else if (source instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)source;
            Component contextMenu = item.getParent();
            if (!(contextMenu instanceof JContextMenu)) {
                if (contextMenu instanceof JPopupMenu) {
                    contextMenu = ((JPopupMenu)contextMenu).getInvoker();
                }
                if (contextMenu instanceof JMenu) {
                    contextMenu = contextMenu.getParent();
                }
            }
            if (contextMenu instanceof JContextMenu) {
                this._sourceType = CONTEXTMENU_TYPE;
                JContextMenu menu = (JContextMenu)contextMenu;
                parent = menu.getInvoker();
                this._target = (NamedObj)menu.getTarget();
                this._x = item.getX();
                this._y = item.getY();
            } else {
                this._sourceType = MENUBAR_TYPE;
            }
        } else if (source instanceof JButton) {
            this._sourceType = TOOLBAR_TYPE;
            this._target = null;
            parent = ((Component)source).getParent();
        } else if (source instanceof JGraph) {
            GraphPane pane = ((JGraph)source).getGraphPane();
            layer = pane.getForegroundLayer();
            Figure currentFigure = layer.getCurrentFigure();
            controller = pane.getGraphController();
            model = controller.getGraphModel();
            if (currentFigure != null) {
                this._target = null;
                while (this._target == null && currentFigure != null) {
                    object = currentFigure;
                    if (object instanceof Figure) {
                        object = currentFigure.getUserObject();
                    }
                    this._target = (NamedObj)model.getSemanticObject(object);
                    currentFigure = currentFigure.getParent();
                }
                if (this._target == null) {
                    throw new InternalErrorException("Internal error: Figure has no associated Ptolemy II object!");
                }
            } else {
                this._target = (NamedObj)model.getRoot();
            }
            this._sourceType = HOTKEY_TYPE;
            this._x = 0;
            this._y = 0;
            canvasPane = layer.getCanvasPane();
            parent = canvasPane.getCanvas();
        } else {
            this._sourceType = null;
            this._target = null;
            parent = null;
            this._x = 0;
            this._y = 0;
        }
        if (parent != null) {
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
        }
        this._frame = parent instanceof Frame ? (Frame)parent : null;
    }

    public Figure getFigure() {
        return this._figure;
    }

    public Frame getFrame() {
        return this._frame;
    }

    public SourceType getSourceType() {
        return this._sourceType;
    }

    public NamedObj getTarget() {
        return this._target;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public static class SourceType {
        private String _name;

        private SourceType(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

