/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.ImageIcon;
import ptolemy.vergil.kernel.attributes.VisibleAttribute;

public class ImageAttribute
extends VisibleAttribute {
    public Parameter scale;
    public FileParameter source;
    private ImageIcon _icon = new ImageIcon((NamedObj)this, "_icon");

    public ImageAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._icon.setPersistent(false);
        this.source = new FileParameter((NamedObj)this, "source");
        this.source.setExpression("$CLASSPATH/ptolemy/vergil/kernel/attributes/ptIIplanetIcon.gif");
        this.scale = new Parameter((NamedObj)this, "scale");
        this.scale.setTypeEquals((Type)BaseType.DOUBLE);
        this.scale.setExpression("100.0");
        this.scale.setVisibility(Settable.EXPERT);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.source) {
            URL url = this.source.asURL();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image image = tk.getImage(url);
            this._icon.setImage(image);
        } else if (attribute == this.scale) {
            double scaleValue = ((DoubleToken)this.scale.getToken()).doubleValue();
            this._icon.scaleImage(scaleValue);
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ImageAttribute newObject = (ImageAttribute)((Object)super.clone(workspace));
        newObject._icon = (ImageIcon)newObject.getAttribute("_icon");
        return newObject;
    }
}

