/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.LabelFigure;
import diva.canvas.toolbox.SVGUtilities;
import diva.graph.GraphController;
import diva.graph.NodeRenderer;
import diva.util.java2d.Polygon2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import ptolemy.actor.IORelation;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.Vertex;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.basic.GetDocumentationAction;
import ptolemy.vergil.basic.ParameterizedNodeController;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class RelationController
extends ParameterizedNodeController {
    private GetDocumentationAction _getDocumentationAction;
    private static Font _relationLabelFont = new Font("SansSerif", 0, 10);

    public RelationController(GraphController controller) {
        super(controller);
        this.setNodeRenderer(new RelationRenderer());
        this._getDocumentationAction = new GetDocumentationAction();
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._getDocumentationAction));
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._getDocumentationAction.setConfiguration(configuration);
    }

    public class RelationRenderer
    implements NodeRenderer {
        public Figure render(Object node) {
            Vertex vertex;
            Token relationSize;
            double height = 12.0;
            double width = 12.0;
            Relation relation = null;
            if (node != null && (relationSize = PtolemyPreferences.preferenceValue((NamedObj)(relation = (Relation)(vertex = (Vertex)node).getContainer()), "_relationSize")) instanceof DoubleToken) {
                width = height = ((DoubleToken)relationSize).doubleValue();
            }
            Polygon2D.Double polygon = new Polygon2D.Double();
            polygon.moveTo(width / 2.0, 0.0);
            polygon.lineTo(0.0, height / 2.0);
            polygon.lineTo(-width / 2.0, 0.0);
            polygon.lineTo(0.0, -height / 2.0);
            polygon.closePath();
            BasicFigure figure = new BasicFigure((Shape)polygon, (Paint)Color.black);
            if (node != null) {
                Object color;
                Object colorAttr;
                ActorGraphModel model = (ActorGraphModel)RelationController.this.getController().getGraphModel();
                figure.setToolTipText(relation.getName(model.getPtolemyModel()));
                try {
                    colorAttr = (StringAttribute)relation.getAttribute("_color", StringAttribute.class);
                    if (colorAttr != null) {
                        color = colorAttr.getExpression();
                        figure.setFillPaint((Paint)SVGUtilities.getColor((String)color));
                    }
                }
                catch (IllegalActionException illegalActionException) {}
                try {
                    colorAttr = (ColorAttribute)relation.getAttribute("_color", ColorAttribute.class);
                    if (colorAttr != null) {
                        color = ((ColorAttribute)((Object)colorAttr)).asColor();
                        figure.setFillPaint((Paint)color);
                    }
                }
                catch (IllegalActionException illegalActionException) {}
            }
            CompositeFigure result = new CompositeFigure((Figure)figure);
            if (relation instanceof IORelation && ((IORelation)relation).getWidth() > 1) {
                width = 12.0;
                height = 12.0;
                Line2D.Double line = new Line2D.Double(-width / 2.0, height / 2.0, width / 2.0, -height / 2.0);
                BasicFigure lineFigure = new BasicFigure((Shape)line, (Paint)Color.black);
                result.add((Figure)lineFigure);
                LabelFigure label = new LabelFigure("" + ((IORelation)relation).getWidth(), _relationLabelFont, 0.0, 6);
                label.translateTo(width / 2.0 + 1.0, -height / 2.0 - 1.0);
                result.add((Figure)label);
            }
            return result;
        }
    }
}

