/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.toolbox.PaintedFigure;
import diva.canvas.toolbox.SVGParser;
import diva.gui.toolbox.FigureIcon;
import diva.util.java2d.PaintedList;
import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import diva.util.xml.XmlReader;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.Icon;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.DynamicEditorIcon;

public class XMLIcon
extends DynamicEditorIcon
implements ValueListener {
    private PaintedList _paintedList;
    private ConfigurableAttribute _description;
    private ConfigurableAttribute _smallIconDescription;

    public XMLIcon(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
        try {
            this.setName(name);
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public XMLIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._paintedList = null;
        this._description = null;
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        XMLIcon newObject = (XMLIcon)((Object)super.clone(workspace));
        newObject._paintedList = null;
        newObject._description = null;
        newObject._smallIconDescription = null;
        return newObject;
    }

    public Figure createBackgroundFigure() {
        NamedObj container = (NamedObj)this.getContainerOrContainerToBe();
        ConfigurableAttribute description = (ConfigurableAttribute)container.getAttribute("_iconDescription");
        if (this._description != description) {
            if (this._description != null) {
                this._description.removeValueListener((ValueListener)this);
            }
            this._description = description;
            if (this._description != null) {
                this._description.addValueListener((ValueListener)this);
            }
            this._recreateFigure();
        }
        this._updatePaintedList();
        if (this._paintedList == null) {
            return this._createDefaultBackgroundFigure();
        }
        return new PaintedFigure(this._paintedList);
    }

    public Icon createIcon() {
        PaintedFigure figure;
        if (this._iconCache != null) {
            return this._iconCache;
        }
        NamedObj container = (NamedObj)this.getContainerOrContainerToBe();
        ConfigurableAttribute description = (ConfigurableAttribute)container.getAttribute("_smallIconDescription");
        if (description == null) {
            return super.createIcon();
        }
        if (this._smallIconDescription != description) {
            if (this._smallIconDescription != null) {
                this._smallIconDescription.removeValueListener((ValueListener)this);
            }
            this._smallIconDescription = description;
            this._smallIconDescription.addValueListener((ValueListener)this);
        }
        this._recreateFigure();
        try {
            String text = this._smallIconDescription.value();
            StringReader in = new StringReader(text);
            XmlDocument document = new XmlDocument(null);
            XmlReader reader = new XmlReader();
            reader.parse(document, (Reader)in);
            XmlElement root = document.getRoot();
            PaintedList paintedList = SVGParser.createPaintedList((XmlElement)root);
            figure = new PaintedFigure(paintedList);
        }
        catch (Exception exception) {
            return super.createIcon();
        }
        this._iconCache = new FigureIcon((Figure)figure, 20, 15, 0, true);
        return this._iconCache;
    }

    public PaintedList paintedList() {
        if (this._paintedList == null) {
            this._updatePaintedList();
        }
        return this._paintedList;
    }

    public String toString() {
        String str = String.valueOf(super.toString()) + "(";
        return String.valueOf(str) + ")";
    }

    public void valueChanged(Settable settable) {
        String name = settable.getName();
        if (name.equals("_iconDescription") || name.equals("_smallIconDescription")) {
            this._recreateFigure();
        }
    }

    protected String _description(int detail, int indent, int bracket) {
        String result = "";
        result = bracket == 0 ? String.valueOf(result) + super._description(detail, indent, 0) : String.valueOf(result) + super._description(detail, indent, 1);
        result = String.valueOf(result) + " graphics {\n";
        result = String.valueOf(result) + "FIXME";
        result = String.valueOf(result) + XMLIcon._getIndentPrefix((int)indent) + "}";
        if (bracket == 2) {
            result = String.valueOf(result) + "}";
        }
        return result;
    }

    protected void _recreateFigure() {
        super._recreateFigure();
        this._paintedList = null;
    }

    private void _updatePaintedList() {
        if (this._description == null) {
            this._paintedList = null;
            return;
        }
        try {
            String text = this._description.value();
            StringReader in = new StringReader(text);
            XmlDocument document = new XmlDocument(null);
            XmlReader reader = new XmlReader();
            reader.parse(document, (Reader)in);
            XmlElement root = document.getRoot();
            this._paintedList = SVGParser.createPaintedList((XmlElement)root);
        }
        catch (Exception exception) {
            this._paintedList = null;
        }
    }
}

