/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.util.xml.XmlDocument;
import diva.util.xml.XmlElement;
import diva.util.xml.XmlReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.kernel.attributes.EllipseAttribute;
import ptolemy.vergil.kernel.attributes.FilledShapeAttribute;
import ptolemy.vergil.kernel.attributes.RectangleAttribute;
import ptolemy.vergil.kernel.attributes.ShapeAttribute;

public class SVGIcon
extends EditorIcon
implements ValueListener {
    private ConfigurableAttribute _description;
    private ConfigurableAttribute _smallIconDescription;

    public SVGIcon(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
        try {
            this.setName(name);
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public SVGIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        super.setContainer(container);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SVGIcon newObject = (SVGIcon)((Object)super.clone(workspace));
        newObject._description = null;
        newObject._smallIconDescription = null;
        return newObject;
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        this._bindToContainer(container);
    }

    public void setContainerToBe(NamedObj container) {
        super.setContainerToBe(container);
        this._bindToContainer(container);
    }

    public void valueChanged(Settable settable) {
        String name = settable.getName();
        if (name.equals("_iconDescription") || name.equals("_smallIconDescription")) {
            this._recreateFigure();
            try {
                this._updateContents();
            }
            catch (Exception ex) {
                throw new InternalErrorException((Throwable)ex);
            }
        }
    }

    private void _bindToContainer(NamedObj container) {
        ConfigurableAttribute description = (ConfigurableAttribute)container.getAttribute("_iconDescription");
        if (this._description != description) {
            if (this._description != null) {
                this._description.removeValueListener((ValueListener)this);
            }
            this._description = description;
            if (this._description != null) {
                this._description.addValueListener((ValueListener)this);
            }
        }
        if (this._smallIconDescription != (description = (ConfigurableAttribute)container.getAttribute("_smallIconDescription"))) {
            if (this._smallIconDescription != null) {
                this._smallIconDescription.removeValueListener((ValueListener)this);
            }
            this._smallIconDescription = description;
            if (this._smallIconDescription != null) {
                this._smallIconDescription.addValueListener((ValueListener)this);
            }
        }
        try {
            this._updateContents();
        }
        catch (Exception ex) {
            throw new InternalErrorException((Throwable)ex);
        }
        this._recreateFigure();
    }

    private void _createAttribute(String type, Map attributes, String content) {
        try {
            if (type.equals("rect")) {
                RectangleAttribute attribute = new RectangleAttribute((NamedObj)this, this.uniqueName("rect"));
                SVGIcon._processFilledShapeAttributeAttributes(attribute, attributes);
            } else if (type.equals("circle")) {
                EllipseAttribute attribute = new EllipseAttribute((NamedObj)this, this.uniqueName("rect"));
                attributes.put("x", SVGIcon._getAttribute(attributes, "cx", "0.0"));
                attributes.put("y", SVGIcon._getAttribute(attributes, "cy", "0.0"));
                double r = SVGIcon._getDouble(attributes, "r", 10.0);
                double width = r * 2.0;
                String widthString = Double.toString(width);
                attributes.put("width", widthString);
                attributes.put("height", widthString);
                SVGIcon._processFilledShapeAttributeAttributes(attribute, attributes);
            }
        }
        catch (KernelException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void _generateContents(XmlElement root) {
        String name = root.getType();
        if (!name.equals("svg")) {
            throw new IllegalArgumentException("Input XML has a rootname which is '" + name + "' instead of 'svg':" + root);
        }
        Iterator children = root.elements();
        while (children.hasNext()) {
            XmlElement child = (XmlElement)children.next();
            this._createAttribute(child.getType(), child.getAttributeMap(), child.getPCData());
        }
    }

    private static String _getAttribute(Map map, String name, String defaultValue) {
        if (map.containsKey(name)) {
            return (String)map.get(name);
        }
        return defaultValue;
    }

    private static double _getDouble(Map map, String name, double defaultValue) {
        if (map.containsKey(name)) {
            return Double.parseDouble((String)map.get(name));
        }
        return defaultValue;
    }

    private static void _processFilledShapeAttributeAttributes(FilledShapeAttribute attribute, Map attributes) {
        SVGIcon._processShapeAttributeAttributes(attribute, attributes);
        String width = SVGIcon._getAttribute(attributes, "width", "10.0");
        String height = SVGIcon._getAttribute(attributes, "height", "10.0");
        attribute.width.setExpression(width);
        attribute.height.setExpression(height);
    }

    private static void _processShapeAttributeAttributes(ShapeAttribute attribute, Map attributes) {
        SVGIcon._processLocation(attribute, attributes);
    }

    private static void _processLocation(Attribute attribute, Map attributes) {
        double[] locationValue = new double[]{SVGIcon._getDouble(attributes, "x", 0.0), SVGIcon._getDouble(attributes, "y", 0.0)};
        try {
            Location location = new Location((NamedObj)attribute, "_location");
            location.setLocation(locationValue);
            location.propagateExistence();
        }
        catch (KernelException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    private void _updateContents() throws Exception {
        if (this._description == null) {
            return;
        }
        String text = this._description.value();
        StringReader in = new StringReader(text);
        XmlDocument document = new XmlDocument(null);
        XmlReader reader = new XmlReader();
        reader.parse(document, (Reader)in);
        XmlElement root = document.getRoot();
        this._generateContents(root);
    }
}

