/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.BasicRectangle;
import diva.canvas.toolbox.LabelFigure;
import diva.canvas.toolbox.RoundedRectangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.icon.TextIcon;

public class NameIcon
extends EditorIcon {
    public Parameter rounding;
    public Parameter spacing;
    protected static Font _labelFont = new Font("SansSerif", 0, 12);
    protected double _roundingValue = 0.0;
    protected double _spacingValue = 0.0;

    public NameIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        TextIcon icon = new TextIcon((NamedObj)this, "_icon");
        icon.setIconText("-N-");
        icon.setText("NameIcon attribute: This sets the icon to be a box with the name.");
        icon.setPersistent(false);
        SingletonParameter hide = new SingletonParameter((NamedObj)this, "_hideName");
        hide.setToken((Token)BooleanToken.TRUE);
        hide.setVisibility(Settable.EXPERT);
        this.rounding = new Parameter((NamedObj)this, "rounding");
        this.rounding.setTypeEquals((Type)BaseType.DOUBLE);
        this.rounding.setExpression("0.0");
        this.spacing = new Parameter((NamedObj)this, "spacing");
        this.spacing.setTypeEquals((Type)BaseType.DOUBLE);
        this.spacing.setExpression("0.0");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.rounding) {
            double roundingValue = ((DoubleToken)this.rounding.getToken()).doubleValue();
            if (roundingValue < 0.0) {
                throw new IllegalActionException((Nameable)this, "Invalid rounding value. Required to be non-negative.");
            }
            if (roundingValue != this._roundingValue) {
                this._roundingValue = roundingValue;
            }
        } else if (attribute == this.spacing) {
            double spacingValue = ((DoubleToken)this.spacing.getToken()).doubleValue();
            if (spacingValue < 0.0) {
                throw new IllegalActionException((Nameable)this, "Invalid spacing value. Required to be non-negative.");
            }
            if (spacingValue != this._spacingValue) {
                this._spacingValue = spacingValue;
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Figure createBackgroundFigure() {
        CompositeFigure result;
        String name = "No Name";
        NamedObj container = this.getContainer();
        if (container != null) {
            name = container.getDisplayName();
        }
        double width = 60.0;
        double height = 30.0;
        LabelFigure label = new LabelFigure(name, _labelFont, 1.0, 0);
        Rectangle2D stringBounds = label.getBounds();
        width = Math.floor(stringBounds.getWidth()) + 20.0;
        height = Math.floor(stringBounds.getHeight()) + 10.0;
        if (this._spacingValue == 0.0) {
            if (this._roundingValue == 0.0) {
                return new BasicRectangle(0.0, 0.0, width, height, this._getFill(), this._getLineWidth());
            }
            return new RoundedRectangle(0.0, 0.0, width, height, this._getFill(), this._getLineWidth(), this._roundingValue, this._roundingValue);
        }
        if (this._roundingValue == 0.0) {
            result = new CompositeFigure((Figure)new BasicRectangle(-this._spacingValue, -this._spacingValue, width + 2.0 * this._spacingValue, height + 2.0 * this._spacingValue, null, this._getLineWidth()));
            result.add((Figure)new BasicRectangle(0.0, 0.0, width, height, this._getFill(), this._getLineWidth()));
        } else {
            result = new CompositeFigure((Figure)new RoundedRectangle(-this._spacingValue, -this._spacingValue, width + 2.0 * this._spacingValue, height + 2.0 * this._spacingValue, null, this._getLineWidth(), this._roundingValue + this._spacingValue, this._roundingValue + this._spacingValue));
            result.add((Figure)new RoundedRectangle(0.0, 0.0, width, height, this._getFill(), this._getLineWidth(), this._roundingValue, this._roundingValue));
        }
        return result;
    }

    public Figure createFigure() {
        CompositeFigure result = (CompositeFigure)super.createFigure();
        String name = "No Name";
        NamedObj container = this.getContainer();
        if (container != null) {
            name = container.getDisplayName();
        }
        LabelFigure label = new LabelFigure(name, _labelFont, 1.0, 0);
        Rectangle2D backBounds = result.getBackgroundFigure().getBounds();
        label.translateTo(backBounds.getCenterX(), backBounds.getCenterY());
        result.add((Figure)label);
        return result;
    }

    public void setContainer(NamedObj container) throws IllegalActionException, NameDuplicationException {
        SingletonParameter hide;
        NamedObj previousContainer = this.getContainer();
        if (previousContainer != container && previousContainer != null && (hide = (SingletonParameter)previousContainer.getAttribute("_hideName", SingletonParameter.class)) != null) {
            hide.setToken((Token)BooleanToken.FALSE);
        }
        super.setContainer(container);
        if (previousContainer != container && container != null) {
            hide = new SingletonParameter(container, "_hideName");
            hide.setToken((Token)BooleanToken.TRUE);
            hide.setVisibility(Settable.EXPERT);
        }
    }

    protected Paint _getFill() {
        return Color.white;
    }

    protected float _getLineWidth() {
        return 1.0f;
    }
}

