/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import diva.canvas.toolbox.LabelFigure;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.icon.XMLIcon;

public class AttributeValueIcon
extends XMLIcon {
    public StringAttribute attributeName = new StringAttribute((NamedObj)this, "attributeName");
    public Parameter displayHeight;
    public Parameter displayWidth = new Parameter((NamedObj)this, "displayWidth");
    protected static Font _labelFont = new Font("SansSerif", 0, 12);

    public AttributeValueIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.displayWidth.setExpression("6");
        this.displayWidth.setTypeEquals((Type)BaseType.INT);
        this.displayHeight = new Parameter((NamedObj)this, "displayHeight");
        this.displayHeight.setExpression("1");
        this.displayHeight.setTypeEquals((Type)BaseType.INT);
    }

    public Figure createFigure() {
        CompositeFigure result = (CompositeFigure)super.createFigure();
        String truncated = this._displayString();
        LabelFigure label = new LabelFigure(truncated, _labelFont, 1.0, 0);
        Rectangle2D backBounds = result.getBackgroundFigure().getBounds();
        label.translateTo(backBounds.getCenterX(), backBounds.getCenterY());
        result.add((Figure)label);
        this._addLiveFigure((Figure)label);
        return result;
    }

    protected String _displayString() {
        Attribute associatedAttribute;
        NamedObj container = this.getContainer();
        if (container != null && (associatedAttribute = container.getAttribute(this.attributeName.getExpression())) instanceof Settable) {
            String value;
            String truncated = value = ((Settable)associatedAttribute).getExpression();
            try {
                int width = ((IntToken)this.displayWidth.getToken()).intValue();
                int height = ((IntToken)this.displayHeight.getToken()).intValue();
                truncated = StringUtilities.truncateString((String)value, (int)width, (int)height);
            }
            catch (IllegalActionException illegalActionException) {}
            if (truncated.length() == 0) {
                truncated = " ";
            }
            return truncated;
        }
        return " ";
    }
}

