/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.Figure;
import diva.canvas.GraphicsPane;
import diva.canvas.interactor.SelectionDragger;
import diva.graph.EdgeController;
import diva.graph.GraphController;
import diva.graph.GraphPane;
import diva.graph.NodeController;
import diva.gui.GUIUtilities;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import ptolemy.actor.gui.Configuration;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.StateEvent;
import ptolemy.domains.fsm.modal.ModalController;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.Locatable;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.RunnableGraphController;
import ptolemy.vergil.fsm.FSMGraphModel;
import ptolemy.vergil.fsm.StateController;
import ptolemy.vergil.fsm.TransitionController;
import ptolemy.vergil.fsm.modal.ModalTransitionController;
import ptolemy.vergil.kernel.AnimationRenderer;
import ptolemy.vergil.kernel.AttributeController;

public class FSMViewerGraphController
extends RunnableGraphController {
    protected NamedObjController _attributeController;
    protected StateController _stateController;
    protected TransitionController _transitionController;
    protected ModalTransitionController _modalTransitionController;
    private SelectionDragger _selectionDragger;

    public FSMViewerGraphController() {
        this._createControllers();
    }

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addHotKey((JComponent)this.getFrame().getJGraph(), (Action)this._transitionController._lookInsideAction);
    }

    public void event(DebugEvent event) {
        Figure figure;
        Attribute location;
        State state;
        if (event instanceof StateEvent && (state = ((StateEvent)event).getState()) != null && (location = state.getAttribute("_location")) != null && (figure = this.getFigure(location)) != null) {
            if (this._animationRenderer == null) {
                this._animationRenderer = new AnimationRenderer();
            }
            if (this._animated != figure) {
                if (this._animated != null) {
                    this._animationRenderer.renderDeselected(this._animated);
                }
                this._animationRenderer.renderSelected(figure);
                this._animated = figure;
                long animationDelay = this.getAnimationDelay();
                if (animationDelay > 0L) {
                    try {
                        Thread.sleep(animationDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public NodeController getNodeController(Object object) {
        NodeController result = super.getNodeController(object);
        if (result != null) {
            return result;
        }
        if (object instanceof Locatable) {
            Object semanticObject = this.getGraphModel().getSemanticObject(object);
            if (semanticObject instanceof Entity) {
                return this._stateController;
            }
            if (semanticObject instanceof Attribute) {
                return this._attributeController;
            }
            if (semanticObject instanceof Port) {
                return this._portController;
            }
        }
        throw new RuntimeException("Node with unknown semantic object: " + object);
    }

    public EdgeController getEdgeController(Object edge) {
        if (((FSMGraphModel)this.getGraphModel()).getPtolemyModel() instanceof ModalController) {
            return this._modalTransitionController;
        }
        return this._transitionController;
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._attributeController.setConfiguration(configuration);
        this._stateController.setConfiguration(configuration);
        this._transitionController.setConfiguration(configuration);
        this._modalTransitionController.setConfiguration(configuration);
    }

    protected void _createControllers() {
        super._createControllers();
        this._attributeController = new AttributeController((GraphController)this, AttributeController.PARTIAL);
        this._stateController = new StateController((GraphController)this, AttributeController.PARTIAL);
        this._modalTransitionController = new ModalTransitionController((GraphController)this);
        this._transitionController = new TransitionController((GraphController)this);
    }

    protected void initializeInteraction() {
        GraphPane pane = this.getGraphPane();
        this._selectionDragger = new SelectionDragger((GraphicsPane)pane);
        this._selectionDragger.addSelectionModel(this.getSelectionModel());
        this._selectionDragger.setConsuming(false);
        super.initializeInteraction();
    }
}

