/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import java.awt.Color;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.vergil.fsm.FSMGraphFrame;

public class FSMGraphTableau
extends Tableau {
    private static Color BACKGROUND_COLOR = new Color(0xE5E5E5);

    public FSMGraphTableau(PtolemyEffigy container, String name) throws IllegalActionException, NameDuplicationException {
        this(container, name, null);
    }

    public FSMGraphTableau(PtolemyEffigy container, String name, LibraryAttribute defaultLibrary) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        NamedObj model = container.getModel();
        if (!(model instanceof FSMActor)) {
            throw new IllegalActionException((Nameable)this, "Cannot edit a model that is not an FSMActor.");
        }
        this.createGraphFrame((CompositeEntity)((FSMActor)model), defaultLibrary);
    }

    public void createGraphFrame(CompositeEntity model) {
        this.createGraphFrame(model, null);
    }

    public void createGraphFrame(CompositeEntity model, LibraryAttribute defaultLibrary) {
        FSMGraphFrame frame = new FSMGraphFrame(model, (Tableau)this, defaultLibrary);
        try {
            this.setFrame(frame);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
        frame.setBackground(BACKGROUND_COLOR);
        frame.pack();
        frame.centerOnScreen();
        frame.setVisible(true);
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (!(effigy instanceof PtolemyEffigy)) {
                return null;
            }
            NamedObj model = ((PtolemyEffigy)effigy).getModel();
            if (model instanceof FSMActor) {
                LibraryAttribute library = (LibraryAttribute)this.getAttribute("_library", LibraryAttribute.class);
                FSMGraphTableau tableau = new FSMGraphTableau((PtolemyEffigy)effigy, effigy.uniqueName("tableau"), library);
                return tableau;
            }
            return null;
        }
    }
}

