/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.Figure;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.SelectionModel;
import diva.graph.NodeDragInteractor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ptolemy.kernel.undo.UndoAction;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.moml.MoMLUndoEntry;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.LocatableNodeController;
import ptolemy.vergil.toolbox.SnapConstraint;

public class LocatableNodeDragInteractor
extends NodeDragInteractor {
    private LocatableNodeController _controller;
    private double[] _dragStart;
    private SnapConstraint _snapConstraint;

    public LocatableNodeDragInteractor(LocatableNodeController controller) {
        super(controller.getController());
        this._controller = controller;
        this._snapConstraint = new SnapConstraint();
        this.appendConstraint(this._snapConstraint);
    }

    public void mousePressed(LayerEvent e) {
        super.mousePressed(e);
        this._dragStart = this._getConstrainedPoint(e);
    }

    public void mouseReleased(LayerEvent e) {
        double[] dragEnd = this._getConstrainedPoint(e);
        double[] transform = new double[]{this._dragStart[0] - dragEnd[0], this._dragStart[1] - dragEnd[1]};
        if (transform[0] == 0.0 && transform[1] == 0.0) {
            return;
        }
        BasicGraphController graphController = (BasicGraphController)this._controller.getController();
        BasicGraphFrame frame = graphController.getFrame();
        SelectionModel model = graphController.getSelectionModel();
        AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)graphController.getGraphModel();
        Object[] selection = model.getSelectionAsArray();
        Object[] userObjects = new Object[selection.length];
        int i = 0;
        while (i < selection.length) {
            userObjects[i] = ((Figure)selection[i]).getUserObject();
            ++i;
        }
        HashSet<NamedObj> namedObjSet = new HashSet<NamedObj>();
        int i2 = 0;
        while (i2 < selection.length) {
            Object userObject;
            if (selection[i2] instanceof Figure && (graphModel.isEdge(userObject = ((Figure)selection[i2]).getUserObject()) || graphModel.isNode(userObject))) {
                NamedObj actual = (NamedObj)graphModel.getSemanticObject(userObject);
                if (actual != null) {
                    namedObjSet.add(actual);
                } else {
                    System.out.println("Object with no semantic object , class: " + userObject.getClass().getName());
                }
            }
            ++i2;
        }
        final NamedObj toplevel = (NamedObj)graphModel.getRoot();
        StringBuffer moml = new StringBuffer();
        StringBuffer undoMoml = new StringBuffer();
        moml.append("<group>\n");
        undoMoml.append("<group>\n");
        for (NamedObj element : namedObjSet) {
            List locationList = element.attributeList(Locatable.class);
            if (locationList.isEmpty()) continue;
            Locatable locatable = (Locatable)locationList.get(0);
            double[] newLocation = new double[]{0.0, 0.0};
            if (locatable.getLocation() != null) {
                newLocation = locatable.getLocation();
            }
            double[] oldLocation = new double[]{newLocation[0] + transform[0], newLocation[1] + transform[1]};
            String containingElementName = element.getElementName();
            String elementToMove = "<" + containingElementName + " name=\"" + element.getName() + "\" >\n";
            moml.append(elementToMove);
            undoMoml.append(elementToMove);
            String momlInfo = ((NamedObj)locatable).getElementName();
            moml.append("<" + momlInfo + " name=\"" + locatable.getName() + "\" value=\"[" + newLocation[0] + ", " + newLocation[1] + "]\" />\n");
            undoMoml.append("<" + momlInfo + " name=\"" + locatable.getName() + "\" value=\"[" + oldLocation[0] + ", " + oldLocation[1] + "]\" />\n");
            moml.append("</" + containingElementName + ">\n");
            undoMoml.append("</" + containingElementName + ">\n");
        }
        moml.append("</group>\n");
        undoMoml.append("</group>\n");
        final String finalUndoMoML = undoMoml.toString();
        MoMLChangeRequest request = new MoMLChangeRequest((Object)this, toplevel, moml.toString()){

            protected void _execute() throws Exception {
                super._execute();
                MoMLUndoEntry newEntry = new MoMLUndoEntry(toplevel, finalUndoMoML);
                UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo((NamedObj)toplevel);
                undoInfo.push((UndoAction)newEntry);
            }
        };
        toplevel.requestChange((ChangeRequest)request);
        if (frame != null) {
            frame.changeExecuted(null);
        }
    }

    public void setSnapResolution(double resolution) {
        this._snapConstraint.setResolution(resolution);
    }

    public void translate(LayerEvent e, double x, double y) {
        double[] snapTranslation;
        Iterator targets = this.targets();
        double[] originalUpperLeft = null;
        if (targets.hasNext()) {
            Figure figure = (Figure)targets.next();
            originalUpperLeft = new double[]{figure.getOrigin().getX(), figure.getOrigin().getY()};
        }
        if (originalUpperLeft == null) {
            double[] oldTranslation = new double[]{x, y};
            snapTranslation = this._snapConstraint.constrain(oldTranslation);
        } else {
            double[] newUpperLeft = new double[]{originalUpperLeft[0] + x, originalUpperLeft[1] + y};
            double[] snapLocation = this._snapConstraint.constrain(newUpperLeft);
            snapTranslation = new double[]{snapLocation[0] - originalUpperLeft[0], snapLocation[1] - originalUpperLeft[1]};
        }
        super.translate(e, snapTranslation[0], snapTranslation[1]);
        try {
            targets = this.targets();
            while (targets.hasNext()) {
                Figure figure = (Figure)targets.next();
                Object node = figure.getUserObject();
                if (!this._controller.getController().getGraphModel().isNode(node)) continue;
                double[] location = new double[]{figure.getOrigin().getX(), figure.getOrigin().getY()};
                this._controller.setLocation(node, location);
            }
        }
        catch (IllegalActionException ex) {
            MessageHandler.error((String)"could not set location", (Throwable)ex);
        }
    }

    private double[] _getConstrainedPoint(LayerEvent e) {
        Iterator targets = this.targets();
        double[] result = new double[2];
        if (targets.hasNext()) {
            result[0] = e.getLayerX();
            result[1] = e.getLayerY();
            return this._snapConstraint.constrain(result);
        }
        return result;
    }
}

