/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.Figure;
import diva.canvas.connector.Connector;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionRenderer;
import diva.graph.AbstractGraphController;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.graph.GraphUtilities;
import diva.graph.NodeController;
import diva.gui.toolbox.MenuCreator;
import diva.gui.toolbox.MenuFactory;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.unit.UnitSolverDialog;
import ptolemy.kernel.Entity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.util.FileUtilities;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.actor.ActorGraphFrame;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.CustomizeDocumentationAction;
import ptolemy.vergil.basic.GetDocumentationAction;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.NodeControllerFactory;
import ptolemy.vergil.basic.PopupMouseFilter;
import ptolemy.vergil.basic.RemoveCustomDocumentationAction;
import ptolemy.vergil.toolbox.ConfigureAction;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.PtolemyMenuFactory;

public abstract class BasicGraphController
extends AbstractGraphController
implements DebugListener,
ValueListener {
    protected Figure _animated;
    protected SelectionRenderer _animationRenderer;
    protected static ConfigureAction _configureAction = new ConfigureAction("Configure");
    protected static MenuActionFactory _configureMenuFactory;
    protected MenuCreator _menuCreator;
    protected PtolemyMenuFactory _menuFactory;
    protected OpenBaseClassAction _openBaseClassAction = new OpenBaseClassAction();
    protected UnitSolverDialogAction _unitSolverDialogAction = new UnitSolverDialogAction();
    private long _animationDelay = 0L;
    private Configuration _configuration;
    private GetDocumentationAction _getDocumentationAction = new GetDocumentationAction();
    private BasicGraphFrame _frame;
    private boolean _inValueChanged = false;

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
    }

    public void clearAnimation() {
        if (this._animated != null && this._animationRenderer != null) {
            this._animationRenderer.renderDeselected(this._animated);
        }
    }

    public void event(DebugEvent event) {
    }

    public long getAnimationDelay() {
        return this._animationDelay;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public BasicGraphFrame getFrame() {
        return this._frame;
    }

    public NodeController getNodeController(Object object) {
        List factoryList;
        Object semanticObject;
        if (object instanceof Locatable && (semanticObject = this.getGraphModel().getSemanticObject(object)) instanceof NamedObj && (factoryList = ((NamedObj)semanticObject).attributeList(NodeControllerFactory.class)).size() > 0) {
            NodeControllerFactory factory = (NodeControllerFactory)((Object)factoryList.get(0));
            NamedObjController controller = factory.create((GraphController)this);
            controller.setConfiguration(this.getConfiguration());
            this._initializeInteraction(controller);
            return controller;
        }
        return null;
    }

    public void message(String message) {
    }

    public void setAnimationDelay(long time) {
        this._animationDelay = time;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
        this._getDocumentationAction.setConfiguration(configuration);
        if (this._configuration != null && this._menuFactory != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._openBaseClassAction));
        }
    }

    public void setFigure(Object semanticObject, Figure figure) {
        super.setFigure(semanticObject, figure);
        if (semanticObject instanceof Settable) {
            ((Settable)semanticObject).addValueListener((ValueListener)this);
        }
    }

    public void setFrame(BasicGraphFrame frame) {
        this._frame = frame;
    }

    public void valueChanged(final Settable settable) {
        if (settable instanceof Locatable && !this._inValueChanged) {
            Runnable action = new Runnable(){

                public void run() {
                    Locatable location = (Locatable)settable;
                    Figure figure = BasicGraphController.this.getFigure(location);
                    if (figure != null) {
                        double[] newLocation;
                        Point2D origin = figure.getOrigin();
                        double originalUpperLeftX = origin.getX();
                        double originalUpperLeftY = origin.getY();
                        try {
                            BasicGraphController.this._inValueChanged = true;
                            newLocation = location.getLocation();
                        }
                        finally {
                            BasicGraphController.this._inValueChanged = false;
                        }
                        double translationX = newLocation[0] - originalUpperLeftX;
                        double translationY = newLocation[1] - originalUpperLeftY;
                        if (translationX != 0.0 || translationY != 0.0) {
                            figure.translate(translationX, translationY);
                            GraphModel model = BasicGraphController.this.getGraphModel();
                            Object userObject = figure.getUserObject();
                            if (userObject != null) {
                                Iterator inEdges = model.inEdges(userObject);
                                while (inEdges.hasNext()) {
                                    Figure connector = BasicGraphController.this.getFigure(inEdges.next());
                                    if (!(connector instanceof Connector)) continue;
                                    ((Connector)connector).reroute();
                                }
                                Iterator outEdges = model.outEdges(userObject);
                                while (outEdges.hasNext()) {
                                    Figure connector = BasicGraphController.this.getFigure(outEdges.next());
                                    if (!(connector instanceof Connector)) continue;
                                    ((Connector)connector).reroute();
                                }
                                if (model.isComposite(userObject)) {
                                    Iterator edges = GraphUtilities.partiallyContainedEdges((Object)userObject, (GraphModel)model);
                                    while (edges.hasNext()) {
                                        Figure connector = BasicGraphController.this.getFigure(edges.next());
                                        if (!(connector instanceof Connector)) continue;
                                        ((Connector)connector).reroute();
                                    }
                                }
                            }
                        }
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                action.run();
            } else {
                SwingUtilities.invokeLater(action);
            }
        }
    }

    protected void _createControllers() {
    }

    protected void _initializeInteraction(NamedObjController controller) {
    }

    protected void initializeInteraction() {
        GraphPane pane = this.getGraphPane();
        this._menuFactory = new SchematicContextMenuFactory((GraphController)this);
        this._menuCreator = new MenuCreator((MenuFactory)this._menuFactory);
        this._menuCreator.setMouseFilter((MouseFilter)new PopupMouseFilter());
        pane.getBackgroundEventLayer().addInteractor((Interactor)this._menuCreator);
        pane.getBackgroundEventLayer().setConsuming(false);
        Action[] actions = new Action[]{this._getDocumentationAction, new CustomizeDocumentationAction(), new RemoveCustomDocumentationAction()};
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(actions, "Documentation"));
        if (this._configuration != null) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._openBaseClassAction));
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._unitSolverDialogAction));
        }
    }

    public class OpenBaseClassAction
    extends FigureAction {
        public OpenBaseClassAction() {
            super("Open Base Class");
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicGraphController.this._configuration == null) {
                MessageHandler.error((String)"Cannot open base class without a configuration.");
                return;
            }
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            if (target == null) {
                return;
            }
            try {
                InstantiableNamedObj deferTo;
                if (target instanceof InstantiableNamedObj && (deferTo = (InstantiableNamedObj)((InstantiableNamedObj)target).getParent()) != null) {
                    BasicGraphController.this._configuration.openModel((NamedObj)deferTo);
                    return;
                }
                String source = target.getSource();
                if (source != null && !source.trim().equals("")) {
                    URL sourceURL = FileUtilities.nameToURL((String)source, null, (ClassLoader)target.getClass().getClassLoader());
                    BasicGraphController.this._configuration.openModel(null, sourceURL, source);
                    return;
                }
                String sourceFileName = StringUtilities.objectToSourceFileName((Object)target);
                URL sourceURL = target.getClass().getClassLoader().getResource(sourceFileName);
                BasicGraphController.this._configuration.openModel(null, sourceURL, sourceURL.toExternalForm());
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Open base class failed.", (Throwable)ex);
            }
        }
    }

    public static class SchematicContextMenuFactory
    extends PtolemyMenuFactory {
        public SchematicContextMenuFactory(GraphController controller) {
            super(controller);
            _configureMenuFactory = new MenuActionFactory(_configureAction);
            this.addMenuItemFactory(_configureMenuFactory);
        }

        protected NamedObj _getObjectFromFigure(Figure source) {
            if (source != null) {
                Object object = source.getUserObject();
                return (NamedObj)this.getController().getGraphModel().getSemanticObject(object);
            }
            return (NamedObj)this.getController().getGraphModel().getRoot();
        }
    }

    public class UnitSolverDialogAction
    extends AbstractAction {
        public UnitSolverDialogAction() {
            super("UnitConstraints Solver");
        }

        public void actionPerformed(ActionEvent e) {
            DialogTableau dialogTableau;
            if (BasicGraphController.this._frame instanceof ActorGraphFrame && (dialogTableau = DialogTableau.createDialog(BasicGraphController.this._frame, BasicGraphController.this._configuration, ((ActorGraphFrame)BasicGraphController.this._frame).getEffigy(), UnitSolverDialog.class, (Entity)((ActorGraphFrame)BasicGraphController.this._frame).getModel())) != null) {
                dialogTableau.show();
            }
        }
    }
}

