/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.AbstractSite;
import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import ptolemy.vergil.actor.IOPortController;
import ptolemy.vergil.actor.PortTerminal;

public class PortConnectSite
extends AbstractSite {
    private int _id = 0;
    private Figure _parentFigure;
    private PortTerminal _terminal;

    public PortConnectSite(Figure figure, PortTerminal terminal, int id, double normal) {
        this._parentFigure = figure;
        this._terminal = terminal;
        this._id = id;
        this._hasNormal = true;
        this._normal = CanvasUtilities.moduloAngle((double)normal);
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._id;
    }

    public Point2D getPoint(double normal) {
        double yout;
        double xout;
        Rectangle2D bounds = this._parentFigure.getShape().getBounds2D();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        if (normal < -2.356194490192345 || normal > 2.356194490192345) {
            if (this._id > 0) {
                int numberOfLinks = this._terminal.getNumberOfLinks();
                xout = x - (double)(numberOfLinks - this._id) * IOPortController.MULTIPORT_CONNECTION_SPACING;
                yout = y + height / 2.0 - (double)(numberOfLinks - this._id) * IOPortController.MULTIPORT_CONNECTION_SPACING;
            } else {
                xout = x;
                yout = y + height / 2.0;
            }
        } else if (normal < -0.7853981633974483) {
            if (this._id > 0) {
                int numberOfLinks = this._terminal.getNumberOfLinks();
                yout = y - (double)(numberOfLinks - this._id) * IOPortController.MULTIPORT_CONNECTION_SPACING;
                xout = x + width / 2.0 - (double)(numberOfLinks - this._id) * IOPortController.MULTIPORT_CONNECTION_SPACING;
            } else {
                xout = x + width / 2.0;
                yout = y;
            }
        } else if (normal < 0.7853981633974483) {
            if (this._id > 0) {
                xout = x + width + (double)(this._id - 1) * IOPortController.MULTIPORT_CONNECTION_SPACING;
                yout = y + height / 2.0 + (double)(this._id - 1) * IOPortController.MULTIPORT_CONNECTION_SPACING;
            } else {
                xout = x + width;
                yout = y + height / 2.0;
            }
        } else if (this._id > 0) {
            yout = y + height + (double)(this._id - 1) * IOPortController.MULTIPORT_CONNECTION_SPACING;
            xout = x + width / 2.0 + (double)(this._id - 1) * IOPortController.MULTIPORT_CONNECTION_SPACING;
        } else {
            xout = x + width / 2.0;
            yout = y + height;
        }
        return new Point2D.Double(xout, yout);
    }

    public PortTerminal getTerminal() {
        return this._terminal;
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public void setNormal(double normal) {
    }

    public String toString() {
        return "PortConnectSite for connection number " + this._id + " of port " + this._terminal.getPort().getFullName();
    }
}

