/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphViewListener;
import diva.graph.layout.GlobalLayout;
import diva.graph.layout.IncrLayoutAdapter;
import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.IncrementalLayoutListener;
import diva.util.Filter;
import java.awt.event.ActionEvent;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.actor.ActorController;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class ActorInstanceController
extends ActorController {
    protected ConvertToClassAction _convertToClassAction = new ConvertToClassAction("Convert to Class");

    public ActorInstanceController(GraphController controller) {
        this(controller, FULL);
    }

    public ActorInstanceController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        if (access == FULL) {
            this._menuFactory.addMenuItemFactory(new MenuActionFactory(this._convertToClassAction));
        }
        Filter portFilter = new Filter(){

            public boolean accept(Object candidate) {
                GraphModel model = ActorInstanceController.this.getController().getGraphModel();
                Object semanticObject = model.getSemanticObject(candidate);
                return candidate instanceof Locatable && semanticObject instanceof Entity && !((Entity)semanticObject).isClassDefinition();
            }
        };
        ActorController.EntityLayout layout = new ActorController.EntityLayout();
        controller.addGraphViewListener((GraphViewListener)new IncrementalLayoutListener((IncrementalLayout)new IncrLayoutAdapter((GlobalLayout)layout){

            public void nodeDrawn(Object node) {
                this.layout(node);
            }
        }, portFilter));
    }

    private class ConvertToClassAction
    extends FigureAction {
        public ConvertToClassAction(String commandName) {
            super(commandName);
        }

        public void actionPerformed(ActionEvent e) {
            if (ActorInstanceController.this._access != FULL) {
                return;
            }
            super.actionPerformed(e);
            NamedObj object = this.getTarget();
            NamedObj container = object.getContainer();
            if (((Instantiable)object).isClassDefinition()) {
                return;
            }
            String moml = "<class name=\"" + object.getName() + "\"/>";
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, container, moml);
            container.requestChange((ChangeRequest)request);
        }
    }
}

